/*
 * @(#)src/classes/sov/java/beans/beancontext/BeanContextServicesListener.java, bean, as131, 20031014 1.5.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 *
 * ===========================================================================
 *
 * Copyright 1998-2000 Sun Microsystems, Inc. All Rights Reserved.
 * ===========================================================================
 */
 
/*
 * @(#)BeanContextServicesListener.java	1.4 99/06/22
 *
 */

package java.beans.beancontext;

import java.beans.beancontext.BeanContextServiceAvailableEvent;
import java.beans.beancontext.BeanContextServiceRevokedEvent;
import java.beans.beancontext.BeanContextServiceRevokedListener;


/**
 * The listener interface for receiving 
 * <code>BeanContextServiceAvailableEvent</code> objects. 
 * A class that is interested in processing a 
 * <code>BeanContextServiceAvailableEvent</code> implements this interface. 
 */
public interface BeanContextServicesListener extends BeanContextServiceRevokedListener {

    /**
     * The service named has been registered. getService requests for
     * this service may now be made.
     * @param bcsae the <code>BeanContextServiceAvailableEvent</code> 
     */
    void serviceAvailable(BeanContextServiceAvailableEvent bcsae);
}
