/*
 * @(#)src/classes/sov/java/lang/reflect/InvocationHandler.java, reflect, as131, 20031014 1.3.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 *
 * ===========================================================================
 * Copyright 1999, 2000 Sun Microsystems, Inc. All Rights Reserved.
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 * 
 * ===========================================================================
 * Change activity:
 *
 * Reason  Date    Origin  Description
 * ------  ----    ------  ---------------------------------------------------
 * 004727 251199   hdrl    Sun 1.3 rollup - file created
 *
 * ===========================================================================
 */

package java.lang.reflect;

/**
 * <code>InvocationHandler</code> is the interface implemented by
 * the <i>invocation handler</i> of a proxy instance.
 *
 * <p>Each proxy instance has an associated invocation handler.
 * When a method is invoked on a proxy instance, the method
 * invocation is encoded and dispatched to the <code>invoke</code>
 * method of the invocation handler.
 *
 * @author	Peter Jones
 * @version	1.2, 99/06/06
 * @see		Proxy
 * @since	JDK1.3
 */
public interface InvocationHandler {

    /**
     * Processes a method invocation on a proxy instance and returns
     * the result.  This method will be invoked on an invocation handler
     * when a method is invoked on a proxy instance that it is
     * associated with.
     *
     * @param	proxy the proxy instance that the method was invoked on
     *
     * @param	method the <code>Method</code> instance corresponding to
     * the interface method invoked on the proxy instance.  The declaring
     * class of the <code>Method</code> object will be the interface that
     * the method was declared in, which may be a superinterface of the
     * proxy interface that the proxy class inherits the method through.
     *
     * @param	args an array of objects containing the values of the
     * arguments passed in the method invocation on the proxy instance.
     * Arguments of primitive types are wrapped in instances of the
     * appropriate wrapper class, such as
     * <code>java.lang.Integer</code> or <code>java.lang.Boolean</code>.
     *
     * @return	the value to return from the method invocation on the
     * proxy instance.  If the declared return value of the interface
     * method is a primitive type, then the value returned by
     * <code>invoke</code> must be an instance of the corresponding
     * primitive wrapper class; otherwise, it must be a type assignable
     * to the declared return type.
     *
     * @throws	Throwable the exception to throw from the method
     * invocation on the proxy instance.  The exception's type must be
     * assignable to either any of the exception types declared in the
     * <code>throws</code> clause of the interface method or to the
     * unchecked exception types <code>java.lang.RuntimeException</code>
     * or <code>java.lang.Error</code>.
     *
     * @see	UndeclaredThrowableException
     */
    public Object invoke(Object proxy, Method method, Object[] args)
	throws Throwable;
}
