/*
 * @(#)src/classes/sov/java/net/URLDecoder.java, net, as131, 20031014 1.6.2.2
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 *
 * ===========================================================================
 *
 * Copyright 1998-2000 Sun Microsystems, Inc. All Rights Reserved.
 * ===========================================================================
 * Change activity:
 *
 * Reason  Date   Origin  Description
 * ------  ----   ------  ----------------------------------------------------
 * 003683  051199 hdrl    Sun 1.3 rollup
 * 39891.1 210102 aclarke Incorrect Unicode encoding/decoding problem
 * ===========================================================================
 */
 
/*
 * @(#)URLDecoder.java	1.2 98/06/29
 *
 */

package java.net;

import java.io.*;

/**
 * The class contains a utility method for converting from
 * a MIME format called "<code>x-www-form-urlencoded</code>"
 * to a <code>String</code>
 * <p>
 * To convert to a <code>String</code>, each character is examined in turn:
 * <ul>
 * <li>The ASCII characters '<code>a</code>' through '<code>z</code>',
 * '<code>A</code>' through '<code>Z</code>', and '<code>0</code>'
 * through '<code>9</code>' remain the same.
 * <li>The plus sign '<code>+</code>'is converted into a
 * space character '<code>&nbsp;</code>'.
 * <li>The remaining characters are represented by 3-character
 * strings which begin with the percent sign,
 * "<code>%<i>xy</i></code>", where <i>xy</i> is the two-digit
 * hexadecimal representation of the lower 8-bits of the character.
 * </ul>
 *
 * @author  Mark Chamness
 * @author  Michael McCloskey
 * @version 1.6, 06/24/99
 * @since   1.2
 */

public class URLDecoder {

    public static String decode(String s) {
        StringBuffer sb = new StringBuffer();
        for(int i=0; i<s.length(); i++) {
            char c = s.charAt(i);
            switch (c) {
                case '+':
                    sb.append(' ');
                    break;
                case '%':
                    try {
                        sb.append((char)Integer.parseInt(
                                        s.substring(i+1,i+3),16));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException();
                    }
                    i += 2;
                    break;
                default:
                    sb.append(c);
                    break;
            }
        }
        // Undo conversion to external encoding
        String result = sb.toString();
	try {
	    byte[] inputBytes = result.getBytes("8859_1");
	    result = new String(inputBytes); 	                 // ibm@39891.1

            // 39891.1 backs out the following fix...
	    // /* Only convert if outside ASCII range ibm@4235 */
	    // byte[] convertBytes = new byte[1];
            // sb = new StringBuffer(inputBytes.length);
            // for (int i = 0; i < inputBytes.length; i++) {
            //     /* bytes are signed: don't convert 0-127 */
            //     if (inputBytes[i] >= 0) {
            //         sb.append((char)inputBytes[i]);
            //     }
            //     else {
            //         convertBytes[0] = inputBytes[i];
            //         sb.append(new String(convertBytes));
            //     }
            // }
            // result = sb.toString();

	} catch (UnsupportedEncodingException e) {
	    // The system should always have 8859_1
	}
	return result;
    }
}


