/*
 * @(#)src/classes/sov/java/rmi/ServerRuntimeException.java, rmi, as131, 20031014 1.4.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 *
 * ===========================================================================
 *
 * Copyright 1996-2000 Sun Microsystems, Inc. All Rights Reserved.
 * ===========================================================================
 */
 
/*
 * @(#)ServerRuntimeException.java	1.8 98/09/21
 *
 */

package java.rmi;

/**
 * A <code>ServerRuntimeException</code> is thrown as a result of a remote
 * method call if the execution of the remote method on the server machine
 * throws a <code>java.lang.RuntimeException</code>.
 * A <code>ServerRuntimeException</code> is not thrown from servers executing
 * in JDK1.2 or later versions.
 * 
 * @version 1.8, 09/21/98
 * @author  Ann Wollrath
 * @since   JDK1.1
 * @deprecated no replacement
 */
public class ServerRuntimeException extends RemoteException {

    /* indicate compatibility with JDK 1.1.x version of class */
    private static final long serialVersionUID = 7054464920481467219L;

    /**
     * Constructs a <code>ServerRuntimeException</code> with the specified
     * detail message and nested exception.
     *
     * @param s the detail message
     * @param ex the nested exception
     * @deprecated no replacement
     * @since JDK1.1
     */
    public ServerRuntimeException(String s, Exception ex) {
	super(s, ex);
    }
}
