/*
 * @(#)src/classes/sov/java/sql/SQLInput.java, jdbc, as131, 20031014 1.5.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 *
 *
 * @(#)SQLInput.java	1.13 99/07/11
 * 
 * Copyright 1998-2000 Sun Microsystems, Inc. All Rights Reserved.
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 */

package java.sql;
 
/**
 * An input stream that contains a stream of values representing an 
 * instance of an SQL structured or distinct type.
 * This interface, used only for custom mapping, is used by the driver
 * behind the scenes, and a programmer never directly invokes
 * <code>SQLInput</code> methods. The <code>readXXX</code> methods
 * provide a way to read the values in an <code>SQLInput</code> object.
 * The method <code>wasNull</code> is used to determine whether the 
 * the last value read was SQL <code>NULL</code>.
 * <P>When the method <code>getObject</code> is called with an
 * object of a class implementing the interface <code>SQLData</code>,
 * the JDBC driver calls the method <code>SQLData.getSQLType</code>
 * to determine the SQL type of the user-defined type (UDT)
 * being custom mapped. The driver
 * creates an instance of <code>SQLInput</code>, populating it with the
 * attributes of the UDT.  The driver then passes the input
 * stream to the method <code>SQLData.readSQL</code>, which in turn 
 * calls the <code>SQLInput.readXXX</code> methods 
 * in its implementation for reading the
 * attributes from the input stream.
 * @since 1.2
 * @see <a href="package-summary.html#2.0 API">What Is in the JDBC
 *      2.0 API</a>
 */

public interface SQLInput {
  

  //================================================================
  // Methods for reading attributes from the stream of SQL data.
  // These methods correspond to the column-accessor methods of
  // java.sql.ResultSet.
  //================================================================

  /**
   * Reads the next attribute in the stream as a <code>String</code> 
   * in the Java programming language.
   *
   * @return the attribute; if the value is SQL <code>NULL</code>, returns <code>null</code>
   * @exception <code>SQLException</code> if a database access error occurs
   */
  String readString() throws SQLException;

  /**
   * Reads the next attribute in the stream as a <code>boolean</code> 
   * in the Java programming language.
   *
   * @return the attribute; if the value is SQL <code>NULL</code>, returns <code>false</code>
   * @exception <code>SQLException</code> if a database access error occurs
   */
  boolean readBoolean() throws SQLException;

  /**
   * Reads the next attribute in the stream as a <code>byte</code> 
   * in the Java programming language.
   *
   * @return the attribute; if the value is SQL <code>NULL</code>, returns <code>0</code>
   * @exception <code>SQLException</code> if a database access error occurs
   */
  byte readByte() throws SQLException;

  /**
   * Reads the next attribute in the stream as a <code>short</code> 
   * in the Java programming language.
   *
   * @return the attribute; if the value is SQL <code>NULL</code>, returns <code>0</code>
   * @exception <code>SQLException</code> if a database access error occurs
   */
  short readShort() throws SQLException;

  /**
   * Reads the next attribute in the stream as an <code>int</code> 
   * in the Java programming language.
   *
   * @return the attribute; if the value is SQL <code>NULL</code>, returns <code>0</code>
   * @exception <code>SQLException</code> if a database access error occurs
   */
  int readInt() throws SQLException;

  /**
   * Reads the next attribute in the stream as a <code>long</code> 
   * in the Java programming language.
   *
   * @return the attribute; if the value is SQL <code>NULL</code>, returns <code>0</code>
   * @exception <code>SQLException</code> if a database access error occurs
   */
  long readLong() throws SQLException;

  /**
   * Reads the next attribute in the stream as a <code>float</code> 
   * in the Java programming language.
   *
   * @return the attribute; if the value is SQL <code>NULL</code>, returns <code>0</code>
   * @exception <code>SQLException</code> if a database access error occurs
   */
  float readFloat() throws SQLException;

  /**
   * Reads the next attribute in the stream as a <code>double</code> 
   * in the Java programming language.
   *
   * @return the attribute; if the value is SQL <code>NULL</code>, returns <code>0</code>
   * @exception <code>SQLException</code> if a database access error occurs
   */
  double readDouble() throws SQLException;

  /**
   * Reads the next attribute in the stream as a <code>java.math.BigDecimal</code> 
   * object in the Java programming language.
   *
   * @return the attribute; if the value is SQL <code>NULL</code>, returns <code>null</code>
   * @exception <code>SQLException</code> if a database access error occurs
   */
  java.math.BigDecimal readBigDecimal() throws SQLException;

  /**
   * Reads the next attribute in the stream as an array of bytes
   * in the Java programming language.
   *
   * @return the attribute; if the value is SQL <code>NULL</code>, returns <code>null</code>
   * @exception <code>SQLException</code> if a database access error occurs
   */
  byte[] readBytes() throws SQLException;

  /**
   * Reads the next attribute in the stream as a <code>java.sql.Date</code> object.
   *
   * @return the attribute; if the value is SQL <code>NULL</code>, returns <code>null</code>
   * @exception <code>SQLException</code> if a database access error occurs
   */
  java.sql.Date readDate() throws SQLException;

  /**
   * Reads the next attribute in the stream as a <code>java.sql.Time</code> object.
   *
   * @return the attribute; if the value is SQL <code>NULL</code>, returns <code>null</code>
   * @exception <code>SQLException</code> if a database access error occurs
   */
  java.sql.Time readTime() throws SQLException;

  /**
   * Reads the next attribute in the stream as a <code>java.sql.Timestamp</code> object.
   *
   * @return the attribute; if the value is SQL <code>NULL</code>, returns <code>null</code>
   * @exception <code>SQLException</code> if a database access error occurs
   */
  java.sql.Timestamp readTimestamp() throws SQLException;

  /**
   * Returns the next attribute in the stream as a stream of Unicode characters.
   *
   * @return the attribute; if the value is SQL <code>NULL</code>, returns <code>null</code>
   * @exception <code>SQLException</code> if a database access error occurs
   */
  java.io.Reader readCharacterStream() throws SQLException;

  /**
   * Returns the next attribute in the stream as a stream of ASCII characters.
   *
   * @return the attribute; if the value is SQL <code>NULL</code>, returns <code>null</code>
   * @exception <code>SQLException</code> if a database access error occurs
   */
  java.io.InputStream readAsciiStream() throws SQLException;

  /**
   * Returns the next attribute in the stream as a stream of uninterpreted
   * bytes.
   *
   * @return the attribute; if the value is SQL <code>NULL</code>, returns <code>null</code>
   * @exception <code>SQLException</code> if a database access error occurs
   */
  java.io.InputStream readBinaryStream() throws SQLException;
  
  //================================================================
  // Methods for reading items of SQL user-defined types from the stream.
  //================================================================

  /**
   * Returns the datum at the head of the stream as an
   * <code>Object</code> in the Java programming language.  The
   * actual type of the object returned is determined by the default type
   * mapping, and any customizations present in this stream's type map.
   *
   * <P>A type map is registered with the stream by the JDBC driver before the
   * stream is passed to the application.
   *
   * <P>When the datum at the head of the stream is an SQL <code>NULL</code>, 
   * the method returns <code>null</code>.  If the datum is an SQL structured or distinct
   * type, it determines the SQL type of the datum at the head of the stream. 
   * If the stream's type map has an entry for that SQL type, the driver
   * constructs an object of the appropriate class and calls the method 
   * <code>SQLData.readSQL</code> on that object, which reads additional data from the 
   * stream, using the protocol described for that method.
   *
   * @return the datum at the head of the stream as an <code>Object</code> in the
   * Java programming language;<code>null</code> if the datum is SQL <code>NULL</code>
   * @exception <code>SQLException</code> if a database access error occurs
   */
  Object readObject() throws SQLException;

  /**
   * Reads an SQL <code>REF</code> value from the stream and returns it as a
   * <code>Ref</code> object in the Java programming language.
   *
   * @return a <code>Ref</code> object representing the SQL <code>REF</code> value
   * at the head of the stream; <code>null</code> if the value read is 
   * SQL <code>NULL</code>
   * @exception <code>SQLException</code> if a database access error occurs
   */
  Ref readRef() throws SQLException;

  /**
   * Reads an SQL <code>BLOB</code> value from the stream and returns it as a
   * <code>Blob</code> object in the Java programming language.
   *
   * @return a <code>Blob</code> object representing data of the SQL <code>BLOB</code> value
   * at the head of the stream; <code>null</code> if the value read is 
   * SQL <code>NULL</code>
   * @exception <code>SQLException</code> if a database access error occurs
   */
  Blob readBlob() throws SQLException;

  /**
   * Reads an SQL <code>CLOB</code> value from the stream and returns it as a
   * <code>Clob</code> object in the Java programming language.
   *
   * @return a <code>Clob</code> object representing data of the SQL <code>CLOB</code> value
   * at the head of the stream; <code>null</code> if the value read is 
   * SQL <code>NULL</code>
   * @exception <code>SQLException</code> if a database access error occurs
   */
  Clob readClob() throws SQLException;

  /**
   * Reads an SQL <code>ARRAY</code> value from the stream and returns it as an
   * <code>Array</code> object in the Java programming language.
   *
   * @return an <code>Array</code> object representing data of the SQL
   * <code>ARRAY</code> value at the head of the stream; <code>null</code>
   * if the value read is SQL <code>NULL</code>
   * @exception <code>SQLException</code> if a database access error occurs
   */
  Array readArray() throws SQLException;

  /**
   * Determines whether the last value read was SQL <code>NULL</code>.
   * 
   * @return <code>true</code> if the most recently read SQL value was SQL
   * <code>NULL</code>; otherwise, <code>false</code>
   * @exception <code>SQLException</code> if a database access error occurs
   * 
   */
  boolean wasNull() throws SQLException;

}
