/*
 * @(#)src/classes/sov/java/util/zip/Adler32.java, zip, as131, 20031014 1.4.2.2
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 *
 * ===========================================================================
 *
 * Copyright 1996-2000 Sun Microsystems, Inc. All Rights Reserved.
 * ===========================================================================
 */

/*
 * @(#)Adler32.java     1.19 98/07/24
 *
 */

package java.util.zip;

/**
 * A class that can be used to compute the Adler-32 checksum of a data
 * stream. An Adler-32 checksum is almost as reliable as a CRC-32 but
 * can be computed much faster.
 *
 * @see         Checksum
 * @version     1.19, 07/24/98
 * @author      David Connelly
 */
public
class Adler32 implements Checksum {
    private int adler = 1;

    /*
     * Loads the ZLIB library.
     */
    static {
        java.security.AccessController.doPrivileged(
                  new sun.security.action.LoadLibraryAction("zip"));
    }

    /**
     * Creates a new Adler32 class.
     */
    public Adler32() {
    }


    /**
     * Updates checksum with specified byte.
     */
    public void update(int b) {
        adler = update(adler, b);
    }

    /**
     * Updates checksum with specified array of bytes.
     */
    public void update(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {  /* ibm@59654 */
            throw new ArrayIndexOutOfBoundsException();
        }
        adler = updateBytes(adler, b, off, len);
    }

    /**
     * Updates checksum with specified array of bytes.
     */
    public void update(byte[] b) {
        adler = updateBytes(adler, b, 0, b.length);
    }

    /**
     * Resets checksum to initial value.
     */
    public void reset() {
        adler = 1;
    }

    /**
     * Returns checksum value.
     */
    public long getValue() {
        return (long)adler & 0xffffffffL;
    }

    private native static int update(int adler, int b);
    private native static int updateBytes(int adler, byte[] b, int off,
                                          int len);
}
