/*
 * @(#)src/classes/sov/javax/accessibility/Accessible.java, accessibility, as131, 20031014 1.6.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 *
 * ===========================================================================
 *
 * Copyright 1997-2000 Sun Microsystems, Inc. All Rights Reserved.
 * ===========================================================================
 */
 
/*
 * @(#)Accessible.java	1.30 98/08/26
 *
 */

package javax.accessibility;

/**
 * Interface Accessible is the main interface for the accessibility package. 
 * All components that support
 * the accessibility package must implement this interface.  
 * It contains a single method, {@link #getAccessibleContext}, which  
 * returns an instance of the class {@link AccessibleContext}.
 *
 * @version     1.1 11/24/97 20:34:48
 * @author	Peter Korn
 * @author      Hans Muller
 * @author      Willie Walker
 */
public interface Accessible {

    /**
     * Returns the AccessibleContext associated with this object.  In most
     * cases, the return value should not be null if the object implements
     * interface Accessible.  If a component developer creates a subclass
     * of an object that implements Accessible, and that subclass
     * is not Accessible, the developer should override the 
     * getAccessibleContext method to return null.
     */
    public AccessibleContext getAccessibleContext();
}
