/*
 * @(#)src/classes/sov/javax/swing/Popup.java, swing, as131, 20031014 1.4.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 * @(#)Popup.java	1.1 99/06/02
 *
 * Copyright 1997-2000 Sun Microsystems, Inc. All Rights Reserved.
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 */

package javax.swing;

import java.awt.*;

    /*
     * The following interface describes what a popup should implement.
     * We do this because JPopupMenu uses popup that can be windows or
     * panels. 
     */
interface Popup {
    public void show(Component invoker);
    public boolean isShowing();
    public void hide();
    
    public Rectangle getBoundsOnScreen();
    public void setLocationOnScreen(int x,int y);
    
    public void setSize(int width,int height);
    public int  getWidth();
    public int  getHeight();
    
    public void addComponent(Component aComponent,Object constraints);
    public void removeComponent(Component c);
    
    public void pack();
}
