/*
 * @(#)src/classes/sov/javax/swing/colorchooser/ColorSelectionModel.java, swing, as131, 20031014 1.5.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 *
 * ===========================================================================
 *
 * Copyright 1998-2000 Sun Microsystems, Inc. All Rights Reserved.
 * ===========================================================================
 */
 
/*
 * @(#)ColorSelectionModel.java	1.5 98/08/26
 *
 */

package javax.swing.colorchooser;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.Color;

/**
 * A model that supports selecting a Color.
 *
 * @version 1.5 08/26/98
 * @author Steve Wilson
 *
 * @see java.awt.Color
 */
public interface ColorSelectionModel {
    /**
     * @return  the model's selection.
     * @see     #setSelectedColor
     */
    Color getSelectedColor();

    /**
     * Sets the model's selected color to <I>color</I>.
     *
     * Notifies any listeners if the model changes
     *
     * @see   #getSelectedColor
     * @see   #addChangeListener
     */
    void setSelectedColor(Color color);

    /**
     * Adds <I>listener</I> as a listener to changes in the model.
     */
    void addChangeListener(ChangeListener listener);

    /**
     * Removes <I>listener</I> as a listener to changes in the model.
     */
    void removeChangeListener(ChangeListener listener);
}
