/*
 * @(#)src/classes/sov/javax/swing/event/PopupMenuListener.java, swing, as131, 20031014 1.5.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 *
 * ===========================================================================
 *
 * Copyright 1997-2000 Sun Microsystems, Inc. All Rights Reserved.
 * ===========================================================================
 */
 
/*
 * @(#)PopupMenuListener.java	1.4 98/09/21
 *
 */
package javax.swing.event;

import java.util.EventListener;

/**
 * A popup menu listener
 *
 * @version 1.4 09/21/98
 * @author Arnaud Weber
 */
public interface PopupMenuListener extends EventListener {
    
    /**
     *  This method is called before the popup menu becomes visible 
     */
    void popupMenuWillBecomeVisible(PopupMenuEvent e);

    /**
     * This method is called before the popup menu becomes invisible
     * Note that a JPopupMenu can become invisible any time 
     */
    void popupMenuWillBecomeInvisible(PopupMenuEvent e);

    /**
     * This method is called when the popup menu is canceled
     */
    void popupMenuCanceled(PopupMenuEvent e);
}

