/*
 * @(#)src/classes/sov/javax/swing/plaf/basic/BasicInternalFrameTitlePane.java, swing, as131, 20031014 1.17.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 * @(#)src/classes/sov/javax/swing/plaf/basic/BasicInternalFrameTitlePane.java, asdev, asdev 1.10
 * ===========================================================================
 *
 * Copyright 1997-2000 Sun Microsystems, Inc. All Rights Reserved.
 * ===========================================================================
 */

/*
 * @(#)BasicInternalFrameTitlePane.java 1.28 99/04/22
 *
 */

package javax.swing.plaf.basic;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.plaf.*;
import javax.swing.border.*;
import javax.swing.event.InternalFrameEvent;
import java.util.EventListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.event.*;                                    /* ibm.947 */

/**
 * The class that manages a basic title bar
 * <p>
 * <strong>Warning:</strong>
 * Serialized objects of this class will not be compatible with
 * future Swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between applications running the same
 * version of Swing.  A future release of Swing will provide support for
 * long term persistence.
 *
 * @version 1.31 07/01/99
 * @author David Kloba
 * @author Steve Wilson
 */
public class BasicInternalFrameTitlePane extends JComponent
{
    protected JMenuBar menuBar;
    protected JButton iconButton;
    protected JButton maxButton;
    protected JButton closeButton;

    protected JMenu windowMenu;
    protected JInternalFrame frame;

    protected Color selectedTitleColor;
    protected Color selectedTextColor;
    protected Color notSelectedTitleColor;
    protected Color notSelectedTextColor;

    protected Icon maxIcon;
    protected Icon minIcon;
    protected Icon iconIcon;
    protected Icon closeIcon;

    protected PropertyChangeListener propertyChangeListener;
    private   DoubleClickAdapter doubleClickAdapter;   /* ibm.947, ibm.1127*/

    protected Action closeAction;
    protected Action maximizeAction;
    protected Action iconifyAction;
    protected Action restoreAction;
    protected Action moveAction;
    protected Action sizeAction;

/*      ibm.1199 extracted the hardcoded text to property file javax/swing/plaf/basic/resources/basic.properties, now using
                ResourceBundles to access the strings.
*/
    protected static final String CLOSE_CMD = UIManager.getString( "InternalFrame.closeText" );/* ibm.1199*/
    protected static final String ICONIFY_CMD = UIManager.getString( "InternalFrame.iconifyText" );    /* ibm.1199*/
    protected static final String RESTORE_CMD = UIManager.getString( "InternalFrame.restoreText" );    /* ibm.1199*/
    protected static final String MAXIMIZE_CMD = UIManager.getString( "InternalFrame.maximizeText" );  /* ibm.1199*/
    protected static final String MOVE_CMD = UIManager.getString( "InternalFrame.moveText" );  /* ibm.1199*/
    protected static final String SIZE_CMD = UIManager.getString( "InternalFrame.sizeText" );  /* ibm.1199*/

    public BasicInternalFrameTitlePane(JInternalFrame f) {
        frame = f;
        installTitlePane();
    }

    protected void installTitlePane() {
   installDefaults();

        // Installing listeners must be done in addNotify because they are
        // uninstalled in removeNotify. Internal frames (and their title panes)
        // get removed and re-added to their parent every time they are
        // selected,  although this is an implementation detail that may
        // eventually change.  Installing the defaults should not happen in
        // addNotify however because changes in the default LAF would be picked
        // up every time a frame was selected.


   createActions();
   enableActions();
   createActionMap();

   setLayout(createLayout());

   assembleSystemMenu();
   createButtons();
   addSubComponents();

    }

    protected void addSubComponents() {
   add(menuBar);
   add(iconButton);
   add(maxButton);
   add(closeButton);

    }

    protected void createActions() {
   maximizeAction = new MaximizeAction();
   iconifyAction = new IconifyAction();
   closeAction = new CloseAction();
   restoreAction = new RestoreAction();
   moveAction = new MoveAction();
   sizeAction = new SizeAction();
    }

    ActionMap createActionMap() {
   ActionMap map = new ActionMapUIResource();
   map.put("showSystemMenu", new ShowSystemMenuAction(true));
   map.put("hideSystemMenu", new ShowSystemMenuAction(false));
   return map;
    }

    protected void installListeners() {
        if( propertyChangeListener == null ) {
            propertyChangeListener = createPropertyChangeListener();
        }
   frame.addPropertyChangeListener(propertyChangeListener);
    }

    protected void uninstallListeners() {
   frame.removePropertyChangeListener(propertyChangeListener);
    }

    protected void installDefaults() {
        maxIcon = UIManager.getIcon("InternalFrame.maximizeIcon");
   minIcon = UIManager.getIcon("InternalFrame.minimizeIcon");
   iconIcon = UIManager.getIcon("InternalFrame.iconifyIcon");
   closeIcon = UIManager.getIcon("InternalFrame.closeIcon");

   selectedTitleColor = UIManager.getColor("InternalFrame.activeTitleBackground");
   selectedTextColor = UIManager.getColor("InternalFrame.activeTitleForeground");
   notSelectedTitleColor = UIManager.getColor("InternalFrame.inactiveTitleBackground");
   notSelectedTextColor = UIManager.getColor("InternalFrame.inactiveTitleForeground");
    }


    protected void uninstallDefaults() {
    }


    public void addNotify() {
        super.addNotify();
        installListeners();
        addSystemMenuItems(windowMenu);
        if (doubleClickAdapter==null) {                          /* ibm.947*/
           doubleClickAdapter = new DoubleClickAdapter();        /* ibm.947*/
           if (windowMenu != null) windowMenu.addMouseListener(doubleClickAdapter); //ibm.5483 /* ibm.947*/
        }                                                        /* ibm.947*/
        enableActions();
    }

    public void removeNotify() {
        super.removeNotify();
        if (doubleClickAdapter != null) {                        /* ibm.947*/
           if (windowMenu != null) windowMenu.removeMouseListener(doubleClickAdapter); //ibm.5483 /* ibm.947*/
           doubleClickAdapter = null;                            /* ibm.947*/
        }                                                        /* ibm.947*/
        if (windowMenu!=null) {
            windowMenu.removeAll();
        }
        uninstallDefaults();
        uninstallListeners();
    }

    protected void createButtons() {
   iconButton = new NoFocusButton();
   iconButton.addActionListener(iconifyAction);

   maxButton = new NoFocusButton();
   maxButton.addActionListener(maximizeAction);

   closeButton = new NoFocusButton();
   closeButton.addActionListener(closeAction);

        setButtonIcons();
    }

    protected void setButtonIcons() {
   if(frame.isIcon()) {
       iconButton.setIcon(minIcon);
       maxButton.setIcon(maxIcon);
        } else if (frame.isMaximum()) {
       iconButton.setIcon(iconIcon);
       maxButton.setIcon(minIcon);
        } else {
       iconButton.setIcon(iconIcon);
       maxButton.setIcon(maxIcon);
        }

   closeButton.setIcon(closeIcon);
    }


    protected void assembleSystemMenu() {
        menuBar = createSystemMenuBar();
   windowMenu = createSystemMenu();
   menuBar.add(windowMenu);
   // moved to addNotify - addSystemMenuItems(windowMenu);
   enableActions();
    }

/*      ibm.1199 The hardcoded mnemonics of the menu items are extracted to the property file javax/swing/plaf/basic/resources/basic.properties
                and accessed using ResourceBundles. Changes were made to convert the String returned by UIManager.getString() to a char that
                is passed to the setMnemonic() method.
*/

    protected void addSystemMenuItems(JMenu systemMenu) {
        JMenuItem mi = (JMenuItem)systemMenu.add(restoreAction);
        mi.setMnemonic( UIManager.getString( "InternalFrame.restoreTextMnemonic" ).charAt(0) );/* ibm.1199*/
        mi = (JMenuItem)systemMenu.add(moveAction);
        mi.setMnemonic( UIManager.getString( "InternalFrame.moveTextMnemonic" ).charAt(0) );/* ibm.1199*/
        mi = (JMenuItem)systemMenu.add(sizeAction);
        mi.setMnemonic( UIManager.getString( "InternalFrame.sizeTextMnemonic" ).charAt(0) );/* ibm.1199*/
        mi = (JMenuItem)systemMenu.add(iconifyAction);
        mi.setMnemonic( UIManager.getString( "InternalFrame.iconifyTextMnemonic" ).charAt(0) );/* ibm.1199*/
        mi = (JMenuItem)systemMenu.add(maximizeAction);
        mi.setMnemonic( UIManager.getString( "InternalFrame.maximizeTextMnemonic" ).charAt(0) );/* ibm.1199*/
        systemMenu.add(new JSeparator());
        mi = (JMenuItem)systemMenu.add(closeAction);
        mi.setMnemonic( UIManager.getString( "InternalFrame.closeTextMnemonic" ).charAt(0) );/* ibm.1199*/
    }

    protected JMenu createSystemMenu() {
   return new JMenu("    ");
    }

    protected JMenuBar createSystemMenuBar() {
   menuBar = new SystemMenuBar();
   menuBar.setBorderPainted(false);
   return menuBar;
    }

    protected void showSystemMenu(){
   //      windowMenu.setPopupMenuVisible(true);
      //      windowMenu.setVisible(true);
      windowMenu.doClick();
    }

    public void paintComponent(Graphics g)  {
   boolean isSelected = frame.isSelected();

   if(isSelected)
       g.setColor(selectedTitleColor);
   else
       g.setColor(notSelectedTitleColor);
   g.fillRect(0, 0, getWidth(), getHeight());

   if(frame.getTitle() != null) {
       Font f = g.getFont();
       g.setFont(UIManager.getFont("InternalFrame.titleFont"));
       if(isSelected)
      g.setColor(selectedTextColor);
       else
      g.setColor(notSelectedTextColor);

            // Center text vertically.
       FontMetrics fm = g.getFontMetrics();
            int fmHeight = fm.getHeight() - fm.getLeading();
            int baseline = (18 - fmHeight) / 2 +
                fm.getAscent() + fm.getLeading();

            int titleX;
            String title = frame.getTitle().trim(); // IBM.7520
            if( BasicGraphicsUtils.isLeftToRight(frame) ) {
                titleX = menuBar.getX() + menuBar.getWidth() + 2;
            } else {
                titleX = menuBar.getX() - 2
                         - SwingUtilities.computeStringWidth(fm,title);
            }

            ////////// START IBM.7520
            String    ellipsis       = "...";                                          // IBM.7520
            int       ellipsisWidth  = SwingUtilities.computeStringWidth(fm,ellipsis); // IBM.7520
            boolean   leftToRight    = BasicGraphicsUtils.isLeftToRight(frame);        // IBM.7520
            Rectangle clipRegion     = g.getClip().getBounds();                        // IBM.7520
            int       titleClipWidth = getWidth();         // IBM.10138
            int       titleWidth     = SwingUtilities.computeStringWidth(fm,title);    // IBM.7520
                                                                                       // IBM.7520
            /*                                                                         // IBM.7520
             * Calculate the clip region for the title-only                            // IBM.7520
             */                                                                        // IBM.7520
            titleClipWidth    -= (leftToRight) ? 2 : -(2); // space after text         // IBM.7520
                                                                                       // IBM.7520
            if(frame.isClosable())     // -close button/spacing                        // IBM.7520
               titleClipWidth -= (leftToRight) ? (16 + 2) : -(16 + 2);                 // IBM.7520
                                                                                       // IBM.7520
            if(frame.isMaximizable())  // -maximize button/spacing                     // IBM.7520
               titleClipWidth -= (leftToRight) ? (16 + 2) : -(16 + 2);                 // IBM.7520
                                                                                       // IBM.7520
            if(frame.isIconifiable())  // -minimize button/spacing                     // IBM.7520
               titleClipWidth -= (leftToRight) ? (16 + 2) : -(16 + 2);                 // IBM.7520
                                                                                       // IBM.7520
            int maxTitleWidth = titleClipWidth;                                        // IBM.7520
            maxTitleWidth -= (leftToRight) ? (titleX) : -(titleX);                     // IBM.7520
            /*                                                                         // IBM.7520
             *  Debug Info                                                             // IBM.7520
             */                                                                        // IBM.7520
         // System.out.println("BasicInternalFrameTitlePane:\n"+                       // IBM.7520
         //   "\t Title x/strlen/len/chars  = "+                                       // IBM.7520
         //      Integer.toString(titleX)+"/"+                                         // IBM.7520
         //      Integer.toString(title.length())+"/"+                                 // IBM.7520
         //      Integer.toString(titleWidth)+"/"+                                     // IBM.7520
         //      title+"\n"+                                                           // IBM.7520
         //   "\t Clip Region: x/y/w = "+                                              // IBM.7520
         //      Integer.toString(clipRegion.x)+"/"+                                   // IBM.7520
         //      Integer.toString(clipRegion.y)+"/"+                                   // IBM.7520
         //      Integer.toString(clipRegion.width)+"\n"+                              // IBM.7520
         //   "\t Max/New Title Clip Width = "+                                        // IBM.7520
         //      Integer.toString(maxTitleWidth)+"/"+                                  // IBM.7520
         //      Integer.toString(titleClipWidth)+                                     // IBM.7520
         //   "");     // IBM.7520                                                     // IBM.7520
                                                                                       // IBM.7520
            if (titleWidth > maxTitleWidth)                                            // IBM.7520
            {                                                                          // IBM.7520
               /*                                                                      // IBM.7520
                *  truncate the string with ellipsis                                   // IBM.7520
                */                                                                     // IBM.7520
               String newTitle = leftToRight ?                                         // IBM.7520
                                    title.trim().concat(ellipsis) :                    // IBM.7520
                                    ellipsis.concat(title.trim());                     // IBM.7520
               int newTitleWidth = SwingUtilities.computeStringWidth(fm,newTitle);     // IBM.7520
               int newStrlen = (int)(((float)maxTitleWidth / (float)newTitleWidth)     // IBM.7520
                                    * (float)newTitle.length())+1;                     // IBM.7520
               //int    prevWidth     = 0;                                             // IBM.7520
                                                                                       // IBM.7520
            // System.out.println( "Before Trunc, new strlen/width/chars:"+            // IBM.7520
            //    Integer.toString(newStrlen)+"/"+                                     // IBM.7520
            //    Integer.toString(newTitleWidth)+"/"+                                 // IBM.7520
            //    newTitle+                                                            // IBM.7520
            //    ""); // IBM.7520                                                     // IBM.7520
               while ((newTitleWidth > maxTitleWidth) && (newStrlen > ellipsis.length()+1))// IBM.7520
               {                                                                       // IBM.7520
                  --newStrlen;                                                         // IBM.7520
                  newTitle = title.substring(0, newStrlen-ellipsis.length());          // IBM.7520
                  newTitle = leftToRight ?                                             // IBM.7520
                                newTitle.concat(ellipsis) :                            // IBM.7520
                                ellipsis.concat(newTitle);                             // IBM.7520
                  newTitleWidth = SwingUtilities.computeStringWidth(fm,newTitle);      // IBM.7520
               }   /* end while (newTitleWidth > maxTitleWidth) */                     // IBM.7520
               title = newTitle;                                                       // IBM.7520
            // System.out.println( "After Trunc, new strlen/width/chars:"+             // IBM.7520
            //    Integer.toString(newStrlen)+"/"+                                     // IBM.7520
            //    Integer.toString(newTitleWidth)+"/"+                                 // IBM.7520
            //    newTitle+                                                            // IBM.7520
            //    ""); // IBM.7520                                                     // IBM.7520
               g.setClip(clipRegion.x,                                                 // IBM.7520
                         clipRegion.y,                                                 // IBM.7520
                         titleClipWidth,                                               // IBM.7520
                         clipRegion.height);                                           // IBM.7520
            }                                                                          // IBM.7520
                                                                                       // IBM.7520
            g.drawString(title, titleX, baseline);                    //ibm.597
                                                                                       // IBM.7520
            if (titleWidth > maxTitleWidth)                                            // IBM.7520
            {                                                                          // IBM.7520
               /*                                                                      // IBM.7520
                *  Restore original clip region                                        // IBM.7520
                */                                                                     // IBM.7520
          //   System.out.println("UnClipping to "+Integer.toString(clipRegion.width));// IBM.7520
               g.setClip(clipRegion);                                                  // IBM.7520
            }                                                                          // IBM.7520
            ////////// END IBM.7520
       g.setFont(f);
   }
    }

    /**
     * Post a WINDOW_CLOSING-like event to the frame, so that it can
     * be treated like a regular Frame.
     */
    protected void postClosingEvent(JInternalFrame frame) {
        InternalFrameEvent e = new InternalFrameEvent(
            frame, InternalFrameEvent.INTERNAL_FRAME_CLOSING);
        // Try posting event, unless there's a SecurityManager.
        if (JInternalFrame.class.getClassLoader() == null) {
            try {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(e);
                return;
            } catch (SecurityException se) {
                // Use dispatchEvent instead.
            }
        }
        frame.dispatchEvent(e);
    }


    protected void enableActions() {
        restoreAction.setEnabled(frame.isMaximum() || frame.isIcon());
   maximizeAction.setEnabled(frame.isMaximizable() && !frame.isMaximum() );
   iconifyAction.setEnabled(frame.isIconifiable() && !frame.isIcon());
   closeAction.setEnabled(frame.isClosable());
   sizeAction.setEnabled(false);
   moveAction.setEnabled(false);
    }


    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected LayoutManager createLayout() {
        return new TitlePaneLayout();
    }


    /**
     * This inner class is marked &quot;public&quot; due to a compiler bug.
     * This class should be treated as a &quot;protected&quot; inner class.
     * Instantiate it only within subclasses of <Foo>.
     */
    public class PropertyChangeHandler implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {

       String prop = (String)evt.getPropertyName();

       if(JInternalFrame.IS_SELECTED_PROPERTY.equals(prop)) {
           repaint();
      return;
       }

       if(JInternalFrame.IS_ICON_PROPERTY.equals(prop) ||
          JInternalFrame.IS_MAXIMUM_PROPERTY.equals(prop)) {
      setButtonIcons();
      enableActions();
      return;
       }

            if( prop.equals("closable") ) {
                if( (Boolean)evt.getNewValue() == Boolean.TRUE )
                    add(closeButton);
                else
                    remove(closeButton);
            } else if( prop.equals("maximizable") ) {
                if( (Boolean)evt.getNewValue() == Boolean.TRUE )
                    add(maxButton);
                else
                    remove(maxButton);
            } else if( prop.equals("iconifiable") ) {
                if( (Boolean)evt.getNewValue() == Boolean.TRUE )
                    add(iconButton);
                else
                    remove(iconButton);
            }
       enableActions();

            revalidate();
            repaint();
   }

    }  // end PropertyHandler class

    /**
     * This inner class is marked &quot;public&quot; due to a compiler bug.
     * This class should be treated as a &quot;protected&quot; inner class.
     * Instantiate it only within subclasses of <Foo>.
     */
    public class TitlePaneLayout implements LayoutManager {
        public void addLayoutComponent(String name, Component c) {}
        public void removeLayoutComponent(Component c) {}
        public Dimension preferredLayoutSize(Container c)  {
       return new Dimension(100, 18);
   }

        public Dimension minimumLayoutSize(Container c) {
       return preferredLayoutSize(c);
   }

        public void layoutContainer(Container c) {
            boolean leftToRight = BasicGraphicsUtils.isLeftToRight(frame);

       int w = getWidth();
            int x;

            x = (leftToRight) ? 2 : w - 16 - 2;
            menuBar.setBounds(x, 1, 16, 16);

            x = (leftToRight) ? w - 16 - 2 : 2;

       if(frame.isClosable()) {
                closeButton.setBounds(x, 2, 16, 14);
                x += (leftToRight) ? -(16 + 2) : 16 + 2;
       }

       if(frame.isMaximizable()) {
           maxButton.setBounds(x, 2, 16, 14);
      x += (leftToRight) ? -(16 + 2) : 16 + 2;
       }

       if(frame.isIconifiable()) {
           iconButton.setBounds(x, 2, 16, 14);
       }
   }
    } // end TitlePaneLayout

    /**
     * This inner class is marked &quot;public&quot; due to a compiler bug.
     * This class should be treated as a &quot;protected&quot; inner class.
     * Instantiate it only within subclasses of <Foo>.
     */
    public class CloseAction extends AbstractAction {
        public CloseAction() {
       super(CLOSE_CMD);
        }

        public void actionPerformed(ActionEvent e) {
       if(frame.isClosable()) {
      frame.doDefaultCloseAction();
       }
   }
    } // end CloseAction

    /**
     * This inner class is marked &quot;public&quot; due to a compiler bug.
     * This class should be treated as a &quot;protected&quot; inner class.
     * Instantiate it only within subclasses of <Foo>.
     */
    public class MaximizeAction extends AbstractAction {
        public MaximizeAction() {
       super(MAXIMIZE_CMD);
        }

        public void actionPerformed(ActionEvent e) {
            if(frame.isMaximizable()) {
                if(!frame.isMaximum()) {
                    try { frame.setMaximum(true); } catch (PropertyVetoException e5) { }
                } else {
                    try {
// ibm.947                        frame.setMaximum(false);
                        if (frame.isIconifiable() && frame.isIcon()) {
                            frame.setIcon(false);
                        }
                        else {                                   /* ibm.947*/
                           frame.setMaximum(false);              /* ibm.947*/
                        }                                        /* ibm.947*/
                    } catch (PropertyVetoException e6) { }
                }
            }
        }
    } // MaximizeAction

    /**
     * This inner class is marked &quot;public&quot; due to a compiler bug.
     * This class should be treated as a &quot;protected&quot; inner class.
     * Instantiate it only within subclasses of <Foo>.
     */
    public class IconifyAction extends AbstractAction {
        public IconifyAction() {
       super(ICONIFY_CMD);
        }

        public void actionPerformed(ActionEvent e) {
       if(frame.isIconifiable()) {
         if(!frame.isIcon()) {
      try { frame.setIcon(true); } catch (PropertyVetoException e1) { }
         } else{
      try { frame.setIcon(false); } catch (PropertyVetoException e1) { }
         }
       }
   }
    } // end IconifyAction

    /**
     * This inner class is marked &quot;public&quot; due to a compiler bug.
     * This class should be treated as a &quot;protected&quot; inner class.
     * Instantiate it only within subclasses of <Foo>.
     */
    public class RestoreAction extends AbstractAction {
        public RestoreAction() {
       super(RESTORE_CMD);
        }

        public void actionPerformed(ActionEvent e) {
       if(frame.isMaximizable() && frame.isMaximum()) {
           try { frame.setMaximum(false); } catch (PropertyVetoException e4) { }
       }
       else if ( frame.isIconifiable() && frame.isIcon() ) {
         try { frame.setIcon(false); } catch (PropertyVetoException e4) { }
       }
   }
    } // end RestoreAction

    /**
     * This inner class is marked &quot;public&quot; due to a compiler bug.
     * This class should be treated as a &quot;protected&quot; inner class.
     * Instantiate it only within subclasses of <Foo>.
     */
    public class MoveAction extends AbstractAction {
        public MoveAction() {
       super(MOVE_CMD);
        }

        public void actionPerformed(ActionEvent e) {
       // This action is currently undefined
   }
    } // end MoveAction

    /*
     * Handles showing and hiding the system menu.
     */
    private class ShowSystemMenuAction extends AbstractAction {
   private boolean show;   // whether to show the menu

   public ShowSystemMenuAction(boolean show) {
       this.show = show;
   }

        public void actionPerformed(ActionEvent e) {
       if (show) {
      windowMenu.doClick();
       } else {
      windowMenu.setVisible(false);
       }
   }
    }

    /**
     * This inner class is marked &quot;public&quot; due to a compiler bug.
     * This class should be treated as a &quot;protected&quot; inner class.
     * Instantiate it only within subclasses of <Foo>.
     */
    public class SizeAction extends AbstractAction {
        public SizeAction() {
       super(SIZE_CMD);
        }

        public void actionPerformed(ActionEvent e) {
       // This action is currently undefined
   }
    } // end SizeAction


    /**
     * This inner class is marked &quot;public&quot; due to a compiler bug.
     * This class should be treated as a &quot;protected&quot; inner class.
     * Instantiate it only within subclasses of <Foo>.
     */
    public class SystemMenuBar extends JMenuBar {
   public boolean isFocusTraversable() { return false; }
   public void requestFocus() {}
   public void paint(Graphics g) {
       Icon icon = frame.getFrameIcon();
       if (icon == null) {
         icon = UIManager.getIcon("InternalFrame.icon");
       }
       if (icon != null) {
           // Resize to 16x16 if necessary.
           if (icon instanceof ImageIcon && (icon.getIconWidth() > 16 || icon.getIconHeight() > 16)) {
          Image img = ((ImageIcon)icon).getImage();
          ((ImageIcon)icon).setImage(img.getScaledInstance(16, 16, Image.SCALE_SMOOTH));
      }
      icon.paintIcon(this, g, 0, 0);
       }
   }

   public boolean isOpaque() {
       return true;
   }
    } // end SystemMenuBar


    private class NoFocusButton extends JButton {
      public NoFocusButton() { setFocusPainted(false); }
   public boolean isFocusTraversable() { return false; }
   public void requestFocus() {};
        public boolean isOpaque() { return true; }
    };  // end NoFocusButton

    private class DoubleClickAdapter extends MouseInputAdapter { /* ibm.947*/
       public void mousePressed(MouseEvent e)                    /* ibm.947*/
       {                                                         /* ibm.947*/
          if (frame.isClosable() & e.getClickCount() == 2) {     /* ibm.947*/
             try {                                               /* ibm.947*/
                frame.setClosed(true);                           /* ibm.947*/
             } catch (PropertyVetoException e0) { }              /* ibm.947*/
             windowMenu.setVisible(false);                       /* ibm.947*/
          }                                                      /* ibm.947*/
       }                                                         /* ibm.947*/
    } // end DoubleClickAdapter                                  /* ibm.947*/

}   // End Title Pane Class
