/*
 * @(#)src/classes/sov/javax/swing/plaf/basic/BasicMenuItemUI.java, swing, as131, 20031014 1.15.2.2
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 * @(#)BasicMenuItemUI.java     1.100 00/02/17
 *
 * Copyright 1997-2000 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to licence terms.
 */
/* 
 * ===========================================================================
 * Change activity:
 *
 * Reason  Date         Origin  Description
 * ------  ----------   ------  ---------------------------------------------- 
 * 37920   12/12/2001  chenerys Don't add ChangeHandler to JMenuItem (was added by 8159:FlexOS specific)
 * ===========================================================================
 */

package javax.swing.plaf.basic;

import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;
import javax.swing.plaf.*;
import javax.swing.text.View;


/**
 * BasicMenuItem implementation
 *
 * @version 1.100 02/17/00
 * @author Georges Saab
 * @author David Karlton
 * @author Arnaud Weber
 * @author Fredrik Lagerblad
 */
public class BasicMenuItemUI extends MenuItemUI
{
    protected JMenuItem menuItem = null;
    protected Color selectionBackground;
    protected Color selectionForeground;
    protected Color disabledForeground;
    protected Color acceleratorForeground;
    protected Color acceleratorSelectionForeground;
    private   String acceleratorDelimiter;

    protected int defaultTextIconGap;
    protected Font acceleratorFont;

    protected MouseInputListener mouseInputListener;
    protected MenuDragMouseListener menuDragMouseListener;
    protected MenuKeyListener menuKeyListener;
    private   PropertyChangeListener propertyChangeListener;
    private   ChangeListener         changeListener;    //ibm.8159

    protected Icon arrowIcon = null;
    protected Icon checkIcon = null;

    protected boolean oldBorderPainted;

    private transient Color disfg;                      //ibm.8159
    private transient Object bindings[];                //ibm.8159

    /** Used for accelerator binding, lazily created. */
    InputMap windowInputMap;

    /* diagnostic aids -- should be false for production builds. */
    private static final boolean TRACE =   false; // trace creates and disposes

    private static final boolean VERBOSE = false; // show reuse hits/misses
    private static final boolean DEBUG =   false;  // show bad params, misc.

    /* Client Property keys for text and accelerator text widths */
    private static final String MAX_TEXT_WIDTH =  "maxTextWidth";
    private static final String MAX_ACC_WIDTH  =  "maxAccWidth";

    /** Uses as the parent of the windowInputMap when selected. */ //ibm.8159
    private InputMap selectedWindowInputMap;                       //ibm.8159

    public static ComponentUI createUI(JComponent c) {
        return new BasicMenuItemUI();
    }

    public void installUI(JComponent c) {
        menuItem = (JMenuItem) c;

        installDefaults();
        installComponents(menuItem);
        installListeners();
        installKeyboardActions();
    }


    protected void installDefaults() {
        String prefix = getPropertyPrefix();

        acceleratorFont = UIManager.getFont("MenuItem.acceleratorFont");

        menuItem.setOpaque(true);
        if(menuItem.getMargin() == null ||
           (menuItem.getMargin() instanceof UIResource)) {
            menuItem.setMargin(UIManager.getInsets(prefix + ".margin"));
        }

        defaultTextIconGap = 4;   // Should be from table

        LookAndFeel.installBorder(menuItem, prefix + ".border");
        oldBorderPainted = menuItem.isBorderPainted();
        menuItem.setBorderPainted( ( (Boolean) (UIManager.get(prefix + ".borderPainted")) ).booleanValue() );
        LookAndFeel.installColorsAndFont(menuItem,
                                         prefix + ".background",
                                         prefix + ".foreground",
                                         prefix + ".font");

        // MenuItem specific defaults
        if (selectionBackground == null ||
            selectionBackground instanceof UIResource) {
            selectionBackground =
                UIManager.getColor(prefix + ".selectionBackground");
        }
        if (selectionForeground == null ||
            selectionForeground instanceof UIResource) {
            selectionForeground =
                UIManager.getColor(prefix + ".selectionForeground");
        }
        if (disabledForeground == null ||
            disabledForeground instanceof UIResource) {
            disabledForeground =
                UIManager.getColor(prefix + ".disabledForeground");
        }
        if (acceleratorForeground == null ||
            acceleratorForeground instanceof UIResource) {
            acceleratorForeground =
                UIManager.getColor(prefix + ".acceleratorForeground");
        }
        if (acceleratorSelectionForeground == null ||
            acceleratorSelectionForeground instanceof UIResource) {
            acceleratorSelectionForeground =
                UIManager.getColor(prefix + ".acceleratorSelectionForeground");
        }
        // Get accelerator delimiter
        acceleratorDelimiter =
            UIManager.getString("MenuItem.acceleratorDelimiter");
        if (acceleratorDelimiter == null) { acceleratorDelimiter = "+"; }
        // Icons
        if (arrowIcon == null ||
            arrowIcon instanceof UIResource) {
            arrowIcon = UIManager.getIcon(prefix + ".arrowIcon");
        }
        if (checkIcon == null ||
            checkIcon instanceof UIResource) {
            checkIcon = UIManager.getIcon(prefix + ".checkIcon");
        }

        disfg = UIManager.getColor("MenuItem.disabledForeground");  //ibm.8159
        bindings = (Object[])UIManager.get                          //ibm.8159
                   ("Menu.selectedWindowInputMapBindings");         //ibm.8159
    }

    /**
     * @since 1.3
     */
    protected void installComponents(JMenuItem menuItem){
        BasicHTML.updateRenderer(menuItem, menuItem.getText());
    }

    protected String getPropertyPrefix() {
        return "MenuItem";
    }

    protected void installListeners() {
        mouseInputListener = createMouseInputListener(menuItem);
        menuDragMouseListener = createMenuDragMouseListener(menuItem);
        menuKeyListener = createMenuKeyListener(menuItem);
        propertyChangeListener = createPropertyChangeListener(menuItem);
        //changeListener = createMIChangeListener(menuItem);   //ibm.8159  //ibm@37920

        menuItem.addMouseListener(mouseInputListener);
        menuItem.addMouseMotionListener(mouseInputListener);
        menuItem.addMenuDragMouseListener(menuDragMouseListener);
        menuItem.addMenuKeyListener(menuKeyListener);
        menuItem.addPropertyChangeListener(propertyChangeListener);
        //menuItem.addChangeListener(changeListener);         //ibm.8159  //ibm@37920
    }

    protected void installKeyboardActions() {
        ActionMap actionMap = getActionMap();

        SwingUtilities.replaceUIActionMap(menuItem, actionMap);
        updateAcceleratorBinding();
    }

    public void uninstallUI(JComponent c) {
        menuItem = (JMenuItem)c;
        uninstallDefaults();
        uninstallComponents(menuItem);
        uninstallListeners();
        uninstallKeyboardActions();


        //Remove the textWidth and accWidth values from the parent's Client Properties.
        Container parent = menuItem.getParent();
        if ( (parent != null && parent instanceof JComponent)  &&
             !(menuItem instanceof JMenu && ((JMenu) menuItem).isTopLevelMenu())) {
            JComponent p = (JComponent) parent;
            p.putClientProperty(BasicMenuItemUI.MAX_ACC_WIDTH, null );
            p.putClientProperty(BasicMenuItemUI.MAX_TEXT_WIDTH, null );
        }

        menuItem = null;
    }


    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(menuItem);
        menuItem.setBorderPainted( oldBorderPainted );
        if (menuItem.getMargin() instanceof UIResource)
            menuItem.setMargin(null);
        if (arrowIcon instanceof UIResource)
            arrowIcon = null;
        if (checkIcon instanceof UIResource)
            checkIcon = null;
    }

    /**
     * @since 1.3
     */
    protected void uninstallComponents(JMenuItem menuItem){
        BasicHTML.updateRenderer(menuItem, "");
    }

    protected void uninstallListeners() {
        menuItem.removeMouseListener(mouseInputListener);
        menuItem.removeMouseMotionListener(mouseInputListener);
        menuItem.removeMenuDragMouseListener(menuDragMouseListener);
        menuItem.removeMenuKeyListener(menuKeyListener);
        menuItem.removePropertyChangeListener(propertyChangeListener);
        //menuItem.removeChangeListener(changeListener);          //ibm.9734 (ibm.8159) //ibm@37920

        mouseInputListener = null;
        menuDragMouseListener = null;
        menuKeyListener = null;
        propertyChangeListener = null;
        //changeListener = null;                          //ibm.9734 (ibm.8159) //ibm@37920
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(menuItem, null);
        if (windowInputMap != null) {
            SwingUtilities.replaceUIInputMap(menuItem, JComponent.
                                           WHEN_IN_FOCUSED_WINDOW, null);
            windowInputMap = null;
        }
    }

    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new MouseInputHandler();
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent c) {
        return new MenuDragMouseHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent c) {
        return new MenuKeyHandler();
    }

    private PropertyChangeListener createPropertyChangeListener(JComponent c) {
        return new PropertyChangeHandler();
    }

    private ChangeListener createMIChangeListener(JComponent c) {       //ibm.8159
        return new ChangeHandler((JMenuItem)c, this);                   //ibm.8159
    }                                                                   //ibm.8159

    ActionMap getActionMap() {
        String propertyPrefix = getPropertyPrefix();
        String uiKey = propertyPrefix + ".actionMap";
        ActionMap am = (ActionMap)UIManager.get(uiKey);
        if (am == null) {
            am = createActionMap();
            UIManager.put(uiKey, am);
        }
        return am;
    }

    ActionMap createActionMap() {
        ActionMap map = new ActionMapUIResource();
        map.put("doClick", new ClickAction());

        if (!(this instanceof BasicMenuUI)) {                      //ibm.8159
           // Get the ActionMap that can be shared.                //ibm.8159
           ActionMap parent = (ActionMap)UIManager.                //ibm.8159
                              get("Menu.sharedActionMap");         //ibm.8159
           if (parent == null) {                                   //ibm.8159
               parent = createMISharedActionMap();                 //ibm.8159
               if (parent != null) {                               //ibm.8159
                   UIManager.put("MenuItemUI.sharedActionMap", parent);//ibm.8159
               }                                                   //ibm.8159
           }                                                       //ibm.8159
           if (parent != null) {                                   //ibm.8159
               map.setParent(parent);                              //ibm.8159
           }                                                       //ibm.8159
        }                                                          //ibm.8159
        return map;
    }

    private ActionMap createMISharedActionMap() {                     //ibm.8159
        ActionMap am = new ActionMapUIResource();                     //ibm.8159
        am.put("cancel", new CancelAction());                         //ibm.8159
        am.put("selectNext", new SelectNextItemAction());             //ibm.8159
        am.put("selectPrevious", new SelectPreviousItemAction());     //ibm.8159
        am.put("selectParent", new SelectParentItemAction());         //ibm.8159
        am.put("selectChild", new SelectChildItemAction());           //ibm.8159
        am.put("return", new ReturnAction());                         //ibm.8159
        return am;                                                    //ibm.8159
    }                                                                 //ibm.8159

    InputMap createInputMap(int condition) {
        if (condition == JComponent.WHEN_IN_FOCUSED_WINDOW) {
            return new ComponentInputMapUIResource(menuItem);
        }
        return null;
    }

    void updateAcceleratorBinding() {
        KeyStroke accelerator = menuItem.getAccelerator();

        if (accelerator != null) {
            if (windowInputMap == null) {
                windowInputMap = createInputMap(JComponent.
                                                WHEN_IN_FOCUSED_WINDOW);
                SwingUtilities.replaceUIInputMap(menuItem,
                           JComponent.WHEN_IN_FOCUSED_WINDOW, windowInputMap);
            }
            windowInputMap.put(accelerator, "doClick");
        }
        else if (windowInputMap != null) {
            windowInputMap.clear();
        }
    }

    public Dimension getMinimumSize(JComponent c) {
        Dimension d = null;
        View v = (View) c.getClientProperty(BasicHTML.propertyKey);
        if (v != null) {
            d = getPreferredSize(c);
            d.width -= v.getPreferredSpan(View.X_AXIS) - v.getMinimumSpan(View.X_AXIS);
        }
        return d;
    }

    public Dimension getPreferredSize(JComponent c) {
        return getPreferredMenuItemSize(c,
                                        checkIcon,
                                        arrowIcon,
                                        defaultTextIconGap);
    }

    public Dimension getMaximumSize(JComponent c) {
        Dimension d = null;
        View v = (View) c.getClientProperty(BasicHTML.propertyKey);
        if (v != null) {
            d = getPreferredSize(c);
            d.width += v.getMaximumSpan(View.X_AXIS) - v.getPreferredSpan(View.X_AXIS);
        }
        return d;
    }

  // these rects are used for painting and preferredsize calculations.
  // they used to be regenerated constantly.  Now they are reused.
    static Rectangle zeroRect = new Rectangle(0,0,0,0);
    static Rectangle iconRect = new Rectangle();
    static Rectangle textRect = new Rectangle();
    static Rectangle acceleratorRect = new Rectangle();
    static Rectangle checkIconRect = new Rectangle();
    static Rectangle arrowIconRect = new Rectangle();
    static Rectangle viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    static Rectangle r = new Rectangle();

    private void resetRects() {
        iconRect.setBounds(zeroRect);
        textRect.setBounds(zeroRect);
        acceleratorRect.setBounds(zeroRect);
        checkIconRect.setBounds(zeroRect);
        arrowIconRect.setBounds(zeroRect);
        viewRect.setBounds(0,0,Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(zeroRect);
    }

    protected Dimension getPreferredMenuItemSize(JComponent c,
                                                     Icon checkIcon,
                                                     Icon arrowIcon,
                                                     int defaultTextIconGap) {
        JMenuItem b = (JMenuItem) c;
        Icon icon = (Icon) b.getIcon();
        String text = b.getText();
        KeyStroke accelerator =  b.getAccelerator();
        String acceleratorText = "";

        if (accelerator != null) {
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                //acceleratorText += "-";
                acceleratorText += acceleratorDelimiter;
          }
            acceleratorText += KeyEvent.getKeyText(accelerator.getKeyCode());
        }

        Font font = b.getFont();
        FontMetrics fm = b.getToolkit().getFontMetrics(font);
        FontMetrics fmAccel = b.getToolkit().getFontMetrics( acceleratorFont );

        resetRects();

        layoutMenuItem(
                  fm, text, fmAccel, acceleratorText, icon, checkIcon, arrowIcon,
                  b.getVerticalAlignment(), b.getHorizontalAlignment(),
                  b.getVerticalTextPosition(), b.getHorizontalTextPosition(),
                  viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect,
                  text == null ? 0 : defaultTextIconGap,
                  defaultTextIconGap
                  );
        // find the union of the icon and text rects
        r.setBounds(textRect);
        r = SwingUtilities.computeUnion(iconRect.x,
                                        iconRect.y,
                                        iconRect.width,
                                        iconRect.height,
                                        r);
        //   r = iconRect.union(textRect);


        // To make the accelerator texts appear in a column, find the widest MenuItem text
        // and the widest accelerator text.

        //Get the parent, which stores the information.
        Container parent = menuItem.getParent();

        //Check the parent, and see that it is not a top-level menu.
        if (parent != null && parent instanceof JComponent &&
            !(menuItem instanceof JMenu && ((JMenu) menuItem).isTopLevelMenu())) {
            JComponent p = (JComponent) parent;

            //Get widest text so far from parent, if no one exists null is returned.
            Integer maxTextWidth = (Integer) p.getClientProperty(BasicMenuItemUI.MAX_TEXT_WIDTH);
            Integer maxAccWidth = (Integer) p.getClientProperty(BasicMenuItemUI.MAX_ACC_WIDTH);

            int maxTextValue = maxTextWidth!=null ? maxTextWidth.intValue() : 0;
            int maxAccValue = maxAccWidth!=null ? maxAccWidth.intValue() : 0;

            //Compare the text widths, and adjust the r.width to the widest.
            if (r.width < maxTextValue) {
                r.width = maxTextValue;
            } else {
                p.putClientProperty(BasicMenuItemUI.MAX_TEXT_WIDTH, new Integer(r.width) );
            }

          //Compare the accelarator widths.
            if (acceleratorRect.width > maxAccValue) {
                maxAccValue = acceleratorRect.width;
                p.putClientProperty(BasicMenuItemUI.MAX_ACC_WIDTH, new Integer(acceleratorRect.width) );
            }

            //Add on the widest accelerator
            r.width += maxAccValue;
            r.width += defaultTextIconGap;

        }

        if( useCheckAndArrow() ) {
            // Add in the checkIcon
            r.width += checkIconRect.width;
            r.width += defaultTextIconGap;

            // Add in the arrowIcon
            r.width += defaultTextIconGap;
            r.width += arrowIconRect.width;
        }

        r.width += 2*defaultTextIconGap;

        Insets insets = b.getInsets();
        if(insets != null) {
            r.width += insets.left + insets.right;
            r.height += insets.top + insets.bottom;
        }

        // if the width is even, bump it up one. This is critical
        // for the focus dash line to draw properly
        if(r.width%2 == 0) {
            r.width++;
        }

        // if the height is even, bump it up one. This is critical
        // for the text to center properly
        if(r.height%2 == 0) {
            r.height++;
        }
/*
        if(!(b instanceof JMenu && ((JMenu) b).isTopLevelMenu()) ) {

            // Container parent = menuItem.getParent();
            JComponent p = (JComponent) parent;

            System.out.println("MaxText: "+p.getClientProperty(BasicMenuItemUI.MAX_TEXT_WIDTH));
            System.out.println("MaxACC"+p.getClientProperty(BasicMenuItemUI.MAX_ACC_WIDTH));

            System.out.println("returning pref.width: " + r.width);
            System.out.println("Current getSize: " + b.getSize() + "\n");
        }*/
        return r.getSize();
    }

    /**
     * We draw the background in paintMenuItem()
     * so override update (which fills the background of opaque
     * components by default) to just call paint().
     *
     */
    public void update(Graphics g, JComponent c) {
        paint(g, c);
    }

    public void paint(Graphics g, JComponent c) {
        paintMenuItem(g, c, checkIcon, arrowIcon,
                      selectionBackground, selectionForeground,
                      defaultTextIconGap);
    }


    protected void paintMenuItem(Graphics g, JComponent c,
                                     Icon checkIcon, Icon arrowIcon,
                                     Color background, Color foreground,
                                     int defaultTextIconGap) {
        JMenuItem b = (JMenuItem) c;
        ButtonModel model = b.getModel();

        //   Dimension size = b.getSize();
        int menuWidth = b.getWidth();
        int menuHeight = b.getHeight();
        Insets i = c.getInsets();

        resetRects();

        viewRect.setBounds( 0, 0, menuWidth, menuHeight );

        viewRect.x += i.left;
        viewRect.y += i.top;
        viewRect.width -= (i.right + viewRect.x);
        viewRect.height -= (i.bottom + viewRect.y);


        Font holdf = g.getFont();
        Font f = c.getFont();
        g.setFont( f );
        FontMetrics fm = g.getFontMetrics( f );
        FontMetrics fmAccel = g.getFontMetrics( acceleratorFont );

        // Paint background
        Color holdc = g.getColor();
        if(c.isOpaque()) {
            if (model.isArmed()|| (c instanceof JMenu && model.isSelected())) {
                g.setColor(background);
                g.fillRect(0,0, menuWidth, menuHeight);
            } else {
                g.setColor(b.getBackground());
                g.fillRect(0,0, menuWidth, menuHeight);
            }
            g.setColor(holdc);
        }

        // get Accelerator text
        KeyStroke accelerator =  b.getAccelerator();
        String acceleratorText = "";
        if (accelerator != null) {
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                //acceleratorText += "-";
                acceleratorText += acceleratorDelimiter;
          }
            acceleratorText += KeyEvent.getKeyText(accelerator.getKeyCode());
        }

        // layout the text and icon
        String text = layoutMenuItem(
            fm, b.getText(), fmAccel, acceleratorText, b.getIcon(),
            checkIcon, arrowIcon,
            b.getVerticalAlignment(), b.getHorizontalAlignment(),
            b.getVerticalTextPosition(), b.getHorizontalTextPosition(),
            viewRect, iconRect, textRect, acceleratorRect,
            checkIconRect, arrowIconRect,
            b.getText() == null ? 0 : defaultTextIconGap,
            defaultTextIconGap
        );

        // Paint the Check
        if (checkIcon != null) {
            if(model.isArmed() || (c instanceof JMenu && model.isSelected())) {
                g.setColor(foreground);
            } else {
                g.setColor(holdc);
            }
            if( useCheckAndArrow() )
                checkIcon.paintIcon(c, g, checkIconRect.x, checkIconRect.y);
            g.setColor(holdc);
        }

        // Paint the Icon
        if(b.getIcon() != null) {
            Icon icon;
            if(!model.isEnabled()) {
                icon = (Icon) b.getDisabledIcon();
            } else if(model.isPressed() && model.isArmed()) {
                icon = (Icon) b.getPressedIcon();
                if(icon == null) {
                    // Use default icon
                    icon = (Icon) b.getIcon();
                }
            } else {
                icon = (Icon) b.getIcon();
            }

            if (icon!=null)
                icon.paintIcon(c, g, iconRect.x, iconRect.y);
        }

        // Draw the Text
        if(text != null) {
            View v = (View) c.getClientProperty(BasicHTML.propertyKey);
            if (v != null) {
                v.paint(g, textRect);
            } else {
                if(!model.isEnabled()) {
                    // *** paint the text disabled
                    if ( disfg instanceof Color )       //ibm.8159
                        {
                            g.setColor( disfg );        //ibm.8159
                            BasicGraphicsUtils.drawString(g,text,model.getMnemonic(),
                                                          textRect.x, textRect.y + fm.getAscent());
                        }
                    else
                        {
                            g.setColor(b.getBackground().brighter());
                            BasicGraphicsUtils.drawString(g,text,model.getMnemonic(),
                                                          textRect.x, textRect.y + fm.getAscent());
                            g.setColor(b.getBackground().darker());
                            BasicGraphicsUtils.drawString(g,text,model.getMnemonic(),
                                                          textRect.x - 1, textRect.y + fm.getAscent() - 1);
                        }
                } else {
                    // *** paint the text normally
                    if (model.isArmed()|| (c instanceof JMenu && model.isSelected())) {
                        g.setColor(foreground);
                    } else {
                        g.setColor(holdc);
                    }
                    BasicGraphicsUtils.drawString(g,text,
                                                  model.getMnemonic(),
                                                  textRect.x,
                                                  textRect.y + fm.getAscent());
                }
            }
        }

        // Draw the Accelerator Text
        if(acceleratorText != null && !acceleratorText.equals("")) {

          //Get the maxAccWidth from the parent to calculate the offset.
          int accOffset = 0;
          Container parent = menuItem.getParent();
          if (parent != null && parent instanceof JComponent) {
            JComponent p = (JComponent) parent;
            Integer maxValueInt = (Integer) p.getClientProperty(BasicMenuItemUI.MAX_ACC_WIDTH);
            int maxValue = maxValueInt!=null ? maxValueInt.intValue() : 0;

            //Calculate the offset, with which the accelerator texts will be drawn with.
            accOffset = maxValue - acceleratorRect.width;
          }

          g.setFont( acceleratorFont );
            if(!model.isEnabled()) {
                // *** paint the acceleratorText disabled
              if ( disabledForeground != null )
                  {
                  g.setColor( disabledForeground );
                  BasicGraphicsUtils.drawString(g,acceleratorText,0,
                                                acceleratorRect.x - accOffset,
                                                acceleratorRect.y + fmAccel.getAscent());
                }
                else
                {
                  g.setColor(b.getBackground().brighter());
                  BasicGraphicsUtils.drawString(g,acceleratorText,0,
                                                acceleratorRect.x - accOffset,
                                                acceleratorRect.y + fmAccel.getAscent());
                  g.setColor(b.getBackground().darker());
                  BasicGraphicsUtils.drawString(g,acceleratorText,0,
                                                acceleratorRect.x - accOffset - 1,
                                                acceleratorRect.y + fmAccel.getAscent() - 1);
                }
            } else {
                // *** paint the acceleratorText normally
                if (model.isArmed()|| (c instanceof JMenu && model.isSelected())) {
                    g.setColor( acceleratorSelectionForeground );
                } else {
                    g.setColor( acceleratorForeground );
                }
                BasicGraphicsUtils.drawString(g,acceleratorText, 0,
                                              acceleratorRect.x - accOffset,
                                              acceleratorRect.y + fmAccel.getAscent());
            }
        }

        // Paint the Arrow
        if (arrowIcon != null) {
            if(model.isArmed() || (c instanceof JMenu &&model.isSelected()))
                g.setColor(foreground);
            if(useCheckAndArrow())
                arrowIcon.paintIcon(c, g, arrowIconRect.x, arrowIconRect.y);
        }
        g.setColor(holdc);
        g.setFont(holdf);
    }


    /**
     * Compute and return the location of the icons origin, the
     * location of origin of the text baseline, and a possibly clipped
     * version of the compound labels string.  Locations are computed
     * relative to the viewRect rectangle.
     */

    private String layoutMenuItem(
        FontMetrics fm,
        String text,
        FontMetrics fmAccel,
        String acceleratorText,
        Icon icon,
        Icon checkIcon,
        Icon arrowIcon,
        int verticalAlignment,
        int horizontalAlignment,
        int verticalTextPosition,
        int horizontalTextPosition,
        Rectangle viewRect,
        Rectangle iconRect,
        Rectangle textRect,
        Rectangle acceleratorRect,
        Rectangle checkIconRect,
        Rectangle arrowIconRect,
        int textIconGap,
        int menuItemGap
        )
    {

        SwingUtilities.layoutCompoundLabel(
                            menuItem, fm, text, icon, verticalAlignment,
                            horizontalAlignment, verticalTextPosition,
                            horizontalTextPosition, viewRect, iconRect, textRect,
                            textIconGap);

        /* Initialize the acceelratorText bounds rectangle textRect.  If a null
         * or and empty String was specified we substitute "" here
         * and use 0,0,0,0 for acceleratorTextRect.
         */
        if( (acceleratorText == null) || acceleratorText.equals("") ) {
            acceleratorRect.width = acceleratorRect.height = 0;
            acceleratorText = "";
        }
        else {
            acceleratorRect.width = SwingUtilities.computeStringWidth( fmAccel, acceleratorText );
            acceleratorRect.height = fmAccel.getHeight();
        }

        /* Initialize the checkIcon bounds rectangle's width & height.
         */

        if( useCheckAndArrow()) {
            if (checkIcon != null) {
                checkIconRect.width = checkIcon.getIconWidth();
                checkIconRect.height = checkIcon.getIconHeight();
            }
            else {
                checkIconRect.width = checkIconRect.height = 0;
            }

            /* Initialize the arrowIcon bounds rectangle width & height.
             */

            if (arrowIcon != null) {
                arrowIconRect.width = arrowIcon.getIconWidth();
                arrowIconRect.height = arrowIcon.getIconHeight();
            } else {
                arrowIconRect.width = arrowIconRect.height = 0;
            }
        }

        Rectangle labelRect = iconRect.union(textRect);
        boolean l2r;                                                //ibm.25095
        try {                                                       //ibm.25095
            l2r = BasicGraphicsUtils.isLeftToRight(menuItem);       //ibm.25095
        } catch (Exception e) {                                     //ibm.25095
            l2r = true;                                             //ibm.25095
        }                                                           //ibm.25095
        if(l2r) {                                                   //ibm.25095
            textRect.x += menuItemGap;
            iconRect.x += menuItemGap;

            // Position the Accelerator text rect
            acceleratorRect.x = viewRect.x + viewRect.width - arrowIconRect.width
                             - menuItemGap - acceleratorRect.width;

            // Position the Check and Arrow Icons
            if (useCheckAndArrow()) {
                checkIconRect.x = viewRect.x + menuItemGap;
                textRect.x += menuItemGap + checkIconRect.width;
                iconRect.x += menuItemGap + checkIconRect.width;
                arrowIconRect.x = viewRect.x + viewRect.width - menuItemGap
                                  - arrowIconRect.width;
            }
        } else {
            textRect.x -= menuItemGap;
            iconRect.x -= menuItemGap;

            // Position the Accelerator text rect
            acceleratorRect.x = viewRect.x + arrowIconRect.width + menuItemGap;

            // Position the Check and Arrow Icons
            if (useCheckAndArrow()) {
                checkIconRect.x = viewRect.x + viewRect.width - menuItemGap
                                  - checkIconRect.width;
                textRect.x -= menuItemGap + checkIconRect.width;
                iconRect.x -= menuItemGap + checkIconRect.width;
                arrowIconRect.x = viewRect.x + menuItemGap;
            }
        }

        // Align the accelertor text and the check and arrow icons vertically
        // with the center of the label rect.
        acceleratorRect.y = labelRect.y + (labelRect.height/2) - (acceleratorRect.height/2);
        if( useCheckAndArrow() ) {
            arrowIconRect.y = labelRect.y + (labelRect.height/2) - (arrowIconRect.height/2);
            checkIconRect.y = labelRect.y + (labelRect.height/2) - (checkIconRect.height/2);
        }

        /*
        System.out.println("Layout: text="+menuItem.getText()+"\n\tv="
                           +viewRect+"\n\tc="+checkIconRect+"\n\ti="
                           +iconRect+"\n\tt="+textRect+"\n\tacc="
                           +acceleratorRect+"\n\ta="+arrowIconRect+"\n");
        */

        return text;
    }

    /*
     * Returns false if the component is a JMenu and it is a top
     * level menu (on the menubar).
     */
    private boolean useCheckAndArrow(){
        boolean b = true;
        if((menuItem instanceof JMenu) &&
           (((JMenu)menuItem).isTopLevelMenu())) {
            b = false;
        }
        return b;
    }

    public MenuElement[] getPath() {
        MenuSelectionManager m = MenuSelectionManager.defaultManager();
        MenuElement oldPath[] = m.getSelectedPath();
        MenuElement newPath[];
        int i = oldPath.length;
        if (i == 0)
            return new MenuElement[0];
        Component parent = menuItem.getParent();
        if (oldPath[i-1].getComponent() == parent) {
            // The parent popup menu is the last so far
            newPath = new MenuElement[i+1];
            System.arraycopy(oldPath, 0, newPath, 0, i);
            newPath[i] = menuItem;
        } else {
            // A sibling menuitem is the current selection
            //
            //  This probably needs to handle 'exit submenu into
            // a menu item.  Search backwards along the current
            // selection until you find the parent popup menu,
            // then copy up to that and add yourself...
            int j;
            for (j = oldPath.length-1; j >= 0; j--) {
                if (oldPath[j].getComponent() == parent)
                    break;
            }
            newPath = new MenuElement[j+2];
            System.arraycopy(oldPath, 0, newPath, 0, j+1);
            newPath[j+1] = menuItem;
            /*
            System.out.println("Sibling condition -- ");
            System.out.println("Old array : ");
            printMenuElementArray(oldPath, false);
            System.out.println("New array : ");
            printMenuElementArray(newPath, false);
            */
        }
        return newPath;
    }

    void printMenuElementArray(MenuElement path[], boolean dumpStack) {
        System.out.println("Path is(");
        int i, j;
        for(i=0,j=path.length; i<j ;i++){
            for (int k=0; k<=i; k++)
                System.out.print("  ");
            MenuElement me = (MenuElement) path[i];
            if(me instanceof JMenuItem)
                System.out.println(((JMenuItem)me).getText() + ", ");
            else if (me == null)
                System.out.println("NULL , ");
            else
                System.out.println("" + me + ", ");
        }
        System.out.println(")");

        if (dumpStack == true)
            Thread.dumpStack();
    }
    protected class MouseInputHandler implements MouseInputListener {
        public void mouseClicked(MouseEvent e) {}
        public void mousePressed(MouseEvent e) {
        }
        public void mouseReleased(MouseEvent e) {
            MenuSelectionManager manager =
                MenuSelectionManager.defaultManager();
            Point p = e.getPoint();
            if(p.x >= 0 && p.x < menuItem.getWidth() &&
               p.y >= 0 && p.y < menuItem.getHeight()) {
               manager.clearSelectedPath();
               menuItem.doClick(0);
            } else {
                manager.processMouseEvent(e);
            }
        }
        public void mouseEntered(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            int modifiers = e.getModifiers();
            // 4188027: drag enter/exit added in JDK 1.1.7A, JDK1.2
            if ((modifiers & (InputEvent.BUTTON1_MASK |
                              InputEvent.BUTTON2_MASK | InputEvent.BUTTON3_MASK)) !=0 ) {
                MenuSelectionManager.defaultManager().processMouseEvent(e);
            } else {
            manager.setSelectedPath(getPath());
             }
        }
        public void mouseExited(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();

            int modifiers = e.getModifiers();
            // 4188027: drag enter/exit added in JDK 1.1.7A, JDK1.2
            if ((modifiers & (InputEvent.BUTTON1_MASK |
                              InputEvent.BUTTON2_MASK | InputEvent.BUTTON3_MASK)) !=0 ) {
                MenuSelectionManager.defaultManager().processMouseEvent(e);
            } else {

                MenuElement path[] = manager.getSelectedPath();
                if (path.length > 1) {
                    MenuElement newPath[] = new MenuElement[path.length-1];
                    int i,c;
                    for(i=0,c=path.length-1;i<c;i++)
                        newPath[i] = path[i];
                    manager.setSelectedPath(newPath);
                }
                }
        }

        public void mouseDragged(MouseEvent e) {
            MenuSelectionManager.defaultManager().processMouseEvent(e);
        }
        public void mouseMoved(MouseEvent e) {
        }
    }


    private class MenuDragMouseHandler implements MenuDragMouseListener {
        public void menuDragMouseEntered(MenuDragMouseEvent e) {}
        public void menuDragMouseDragged(MenuDragMouseEvent e) {
            MenuSelectionManager manager = e.getMenuSelectionManager();
            MenuElement path[] = e.getPath();
            manager.setSelectedPath(path);
        }
        public void menuDragMouseExited(MenuDragMouseEvent e) {}
        public void menuDragMouseReleased(MenuDragMouseEvent e) {
            MenuSelectionManager manager = e.getMenuSelectionManager();
            MenuElement path[] = e.getPath();
            Point p = e.getPoint();
            if(p.x >= 0 && p.x < menuItem.getWidth() &&
               p.y >= 0 && p.y < menuItem.getHeight()) {
               manager.clearSelectedPath();
               menuItem.doClick(0);
            } else {
                manager.clearSelectedPath();
            }
        }
    }

    private class MenuKeyHandler implements MenuKeyListener {
        public void menuKeyTyped(MenuKeyEvent e) {
            if (DEBUG) {
                System.out.println("in BasicMenuItemUI.menuKeyTyped for " + menuItem.getText());
            }
            int key = menuItem.getMnemonic();
            if(key == 0)
                return;
            if(lower(key) == lower((int)(e.getKeyChar()))) {
                MenuSelectionManager manager =
                    e.getMenuSelectionManager();
                manager.clearSelectedPath();
                menuItem.doClick(0);
                e.consume();
            }
        }
        public void menuKeyPressed(MenuKeyEvent e) {
            if (DEBUG) {
                System.out.println("in BasicMenuItemUI.menuKeyPressed for " + menuItem.getText());
            }
        }
        public void menuKeyReleased(MenuKeyEvent e) {}

        private int lower(int ascii) {
            if(ascii >= 'A' && ascii <= 'Z')
                return ascii + 'a' - 'A';
            else
                return ascii;
        }

    }

    private class PropertyChangeHandler implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();

            if (name.equals("labelFor") || name.equals("displayedMnemonic") ||
                name.equals("accelerator")) {
                updateAcceleratorBinding();
            } else if (name.equals("text")) {
                // remove the old html view client property if one
                // existed, and install a new one if the text installed
                // into the JLabel is html source.
                JMenuItem lbl = ((JMenuItem) e.getSource());
                String text = lbl.getText();
                BasicHTML.updateRenderer(lbl, text);
            }
        }
    }

    private static class ClickAction extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            JMenuItem mi = (JMenuItem)e.getSource();
            MenuSelectionManager.defaultManager().clearSelectedPath();
            mi.doClick();
        }
    }

    //ibm.8159 : start  : Copied from BasicMenuUI.java
    // This is necessary for JMenuItem's in the root of a JPopupMenu, where
    // the parent is not a JMenu.
    private class ChangeHandler implements ChangeListener {
        public JMenuItem    menu;                       //ibm.8159
        public BasicMenuItemUI ui;                      //ibm.8159
        public boolean  isSelected = false;
        public Component wasFocused;

        public ChangeHandler(JMenuItem m, BasicMenuItemUI ui) {     //ibm.8159
            menu = m;
            this.ui = ui;
            validateKeyboardActions(menu.isSelected() || menu.isArmed()); //ibm.8159
        }

        public void stateChanged(ChangeEvent e) {
            validateKeyboardActions(menu.isSelected() || menu.isArmed()); //ibm.8159
        }

        private Component findFocusedComponent(Component c) {
            Container parent;
            for(parent = c.getParent() ; parent != null ; parent = parent.getParent()) {
                if(parent instanceof java.awt.Window)
                    return ((java.awt.Window)parent).getFocusOwner();
            }
            return null;
        }

        private void validateKeyboardActions(boolean sel) {
            if(sel != isSelected) {
                isSelected = sel;
                if(isSelected) {
                    boolean isRequestFocusEnabled = menu.isRequestFocusEnabled();
                    wasFocused = findFocusedComponent(menu);
                    if ((wasFocused instanceof JComponent) &&
                        ((JComponent)wasFocused).getRootPane() != menu.getRootPane()) {
                      wasFocused = null;
                    }
                    if(!isRequestFocusEnabled)
                        menu.setRequestFocusEnabled(true);
                    menu.requestFocus();
                    if(!isRequestFocusEnabled)
                        menu.setRequestFocusEnabled(false);
                    if (selectedWindowInputMap == null) {
                        if (bindings != null) {
                            selectedWindowInputMap = LookAndFeel.
                                makeComponentInputMap(menuItem, bindings);
                        }
                    }
                    if (windowInputMap == null) {
                        windowInputMap = createInputMap(JComponent.
                                                    WHEN_IN_FOCUSED_WINDOW);
                        SwingUtilities.replaceUIInputMap(menuItem, JComponent.
                                                   WHEN_IN_FOCUSED_WINDOW,
                                                   windowInputMap);
                    }
                    if (windowInputMap != null && selectedWindowInputMap != null) {
                        windowInputMap.setParent(selectedWindowInputMap);
                    }
                } else {
                    if (windowInputMap != null && selectedWindowInputMap != null) {
                        windowInputMap.setParent(null);
                    }
                    if(wasFocused != null) {
                        if(wasFocused instanceof JComponent) {
                            JComponent jc = (JComponent) wasFocused;
                            boolean isRFEnabled = jc.isRequestFocusEnabled();
                            if(!isRFEnabled)
                                jc.setRequestFocusEnabled(true);
                            wasFocused.requestFocus();
                            if(!isRFEnabled)
                                jc.setRequestFocusEnabled(false);
                        } else {                                        //ibm.8159
                            wasFocused.requestFocus();                  //ibm.8159
                        }                                               //ibm.8159
                        wasFocused = null;
                    }
                }
            }
        }
    }

    private static class CancelAction extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            /* Must be commented out to work around compiler bug (4242000)
              if (DEBUG) {
                System.out.println("In CancelAction.actionPerformed");
                Thread.dumpStack();
            }
            */
            JMenuItem menu = (JMenuItem)e.getSource();          //ibm.8159
            if (!menu.isEnabled())
                return;

            MenuElement path[] = MenuSelectionManager.defaultManager().getSelectedPath();
            if(path.length > 4) { /* PENDING(arnaud) Change this to 2 when a mouse grabber is available for MenuBar */
                MenuElement newPath[] = new MenuElement[path.length - 2];
                System.arraycopy(path,0,newPath,0,path.length-2);
                MenuSelectionManager.defaultManager().setSelectedPath(newPath);
            } else
                MenuSelectionManager.defaultManager().clearSelectedPath();
        }
    }

    private class ReturnAction extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            JMenuItem menu = (JMenuItem)e.getSource();          //ibm.8159
            if (!menu.isEnabled())
                return;

            MenuElement path[] = MenuSelectionManager.defaultManager().getSelectedPath();
            MenuElement lastElement;
            if(path.length > 0) {
                lastElement = path[path.length-1];
                if(lastElement instanceof JMenu) {
                    MenuElement newPath[] = new MenuElement[path.length+1];
                    System.arraycopy(path,0,newPath,0,path.length);
                    newPath[path.length] = ((JMenu)lastElement).getPopupMenu();
                    MenuSelectionManager.defaultManager().setSelectedPath(newPath);
                } else if(lastElement instanceof JMenuItem) {
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                    ((JMenuItem)lastElement).doClick(0);
                    ((JMenuItem)lastElement).setArmed(false);
                }
            }
        }
    }

    private static MenuElement nextEnabledChild(MenuElement e[],int fromIndex) {
        int i,c;
        for(i=fromIndex,c=e.length ; i < c ; i++) {
            if (e[i]!=null) {
                Component comp = e[i].getComponent();
                if(comp != null && comp.isEnabled())
                    return e[i];
            }
        }
        return null;
    }

    private static MenuElement previousEnabledChild(MenuElement e[],int fromIndex) {
        int i;
        for(i=fromIndex ; i >= 0 ; i--) {
            if (e[i]!=null) {
                Component comp = e[i].getComponent();
                if(comp != null && comp.isEnabled())
                    return e[i];
            }
        }
        return null;
    }

    private static class SelectNextItemAction extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            /* Must be commented out to work around compiler bug (4242000)
              if (DEBUG) {
                System.out.println("In SelectNextItemAction.actionPerformed");
            }
            */

            JMenuItem menu = (JMenuItem)e.getSource();  //ibm.8159
            if (!menu.isEnabled())
                return;

            MenuElement currentSelection[] = MenuSelectionManager.defaultManager().getSelectedPath();
            if(currentSelection.length > 1) {
                MenuElement parent = currentSelection[currentSelection.length-2];
                if(parent.getComponent() instanceof JMenu) {
                    MenuElement childs[];
                    parent = currentSelection[currentSelection.length-1];
                    childs = parent.getSubElements();
                    if(childs.length > 0) {
                        MenuElement newPath[] = new MenuElement[currentSelection.length+1];
                        System.arraycopy(currentSelection,0,
                                         newPath,0,currentSelection.length);
                        newPath[currentSelection.length] = nextEnabledChild(childs,0);
                        if(newPath[currentSelection.length] != null) {
                            MenuSelectionManager.defaultManager().setSelectedPath(newPath);
                        }
                    }
                } else if(currentSelection.length == 2 && currentSelection[0].getComponent() instanceof JMenuBar) { //ibm.8159
                   // For MenuBar, this should be SelectChildItem                                                   //ibm.8159
                   MenuElement nextMenu=null,popup=null,firstItem=null;                                             //ibm.8159
                   MenuElement tmp[];                                                                               //ibm.8159
                   int i,c;                                                                                         //ibm.8159
                                                                                                                    //ibm.8159
                   MenuElement path[] = currentSelection;                                                           //ibm.8159
                                                                                                                    //ibm.8159
                   if(path.length > 1) {                                                                            //ibm.8159
                      nextMenu = path[1];                                                                           //ibm.8159
                   }                                                                                                //ibm.8159
                                                                                                                    //ibm.8159
                   if(nextMenu != null) {                                                                           //ibm.8159
                       MenuElement newSelection[];                                                                  //ibm.8159
                       popup = ((JMenu)nextMenu).getPopupMenu();                                                    //ibm.8159
                       for (int j = 0; j<((JPopupMenu)popup).getComponentCount(); j++) {                        //ibm.8159
                          Component itm = ((JPopupMenu)popup).getComponent(j);                                  //ibm.8159
                          if (itm != null && itm.isEnabled()) {                                                 //ibm.8159
                             firstItem = (MenuElement) itm;                                                     //ibm.8159
                             break;
                          }                                                                                     //ibm.8159
                       }                                                                                        //ibm.8159

                       if(firstItem != null) {                                                                      //ibm.8159
                           newSelection = new MenuElement[4];                                                       //ibm.8159
                           newSelection[0] = path[0];                                                               //ibm.8159
                           newSelection[1] = nextMenu;                                                              //ibm.8159
                           newSelection[2] = popup;                                                                 //ibm.8159
                           newSelection[3] = firstItem;                                                             //ibm.8159
                       } else {                                                                                     //ibm.8159
                           newSelection = new MenuElement[3];                                                       //ibm.8159
                           newSelection[0] = path[0];                                                               //ibm.8159
                           newSelection[1] = nextMenu;                                                              //ibm.8159
                           newSelection[2] = popup;                                                                 //ibm.8159
                       }                                                                                            //ibm.8159
                       MenuSelectionManager.defaultManager().setSelectedPath(newSelection);                         //ibm.8159
                   }                                                                                                //ibm.8159
                } else {
                    MenuElement childs[] = parent.getSubElements();
                    MenuElement nextChild;
                    int i,c;
                    for(i=0,c=childs.length;i<c;i++) {
                        if(childs[i] == currentSelection[currentSelection.length-1]) {
                            nextChild = nextEnabledChild(childs,i+1);
                            if(nextChild == null)
                                nextChild = nextEnabledChild(childs,0);
                            if(nextChild != null) {
                                currentSelection[currentSelection.length-1] = nextChild;
                                MenuSelectionManager.defaultManager().setSelectedPath(currentSelection);
                            }
                            break;
                        }
                    }
                }
            }
        }
    }

    private static class SelectPreviousItemAction extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            /* Must be commented out to work around compiler bug (4242000)
              if (DEBUG) {
                System.out.println("In SelectPreviousItemAction.actionPerformed");
            }
            */

            JMenuItem menu = (JMenuItem)e.getSource();          //ibm.8159
            if (!menu.isEnabled())
                return;

            MenuElement currentSelection[] = MenuSelectionManager.defaultManager().getSelectedPath();
            if(currentSelection.length > 1) {
                MenuElement parent = currentSelection[currentSelection.length-2];
                if(parent.getComponent() instanceof JMenu) {
                    MenuElement childs[];
                    parent = currentSelection[currentSelection.length-1];
                    childs = parent.getSubElements();
                    if(childs.length > 0) {
                        MenuElement newPath[] = new MenuElement[currentSelection.length+1];
                        System.arraycopy(currentSelection,0,
                                         newPath,0,currentSelection.length);
                        newPath[currentSelection.length] = previousEnabledChild(childs,childs.length-1);
                        if(newPath[currentSelection.length] != null)
                            MenuSelectionManager.defaultManager().setSelectedPath(newPath);
                    }
                } else if(currentSelection.length == 2 && currentSelection[0].getComponent() instanceof JMenuBar) { //ibm.8159
                   // For MenuBar, this should be SelectParentItem                                                  //ibm.8159
                   MenuElement nextMenu=null,popup=null,firstItem=null;                                             //ibm.8159
                   MenuElement tmp[];                                                                               //ibm.8159
                   int i,c;                                                                                         //ibm.8159
                                                                                                                    //ibm.8159
                   MenuElement path[] = currentSelection;                                                           //ibm.8159
                                                                                                                    //ibm.8159
                   if(path.length > 1) {                                                                            //ibm.8159
                       MenuElement previousElement;                                                                 //ibm.8159
                       tmp = path[0].getSubElements();                                                              //ibm.8159
                       for(i=0,c=tmp.length;i<c;i++) {                                                              //ibm.8159
                           if(tmp[i] == path[1]) {                                                                  //ibm.8159
                               nextMenu = previousEnabledChild(tmp,i-1);                                            //ibm.8159
                               if(nextMenu == null)                                                                 //ibm.8159
                                   nextMenu = previousEnabledChild(tmp,tmp.length-1);                               //ibm.8159
                           }                                                                                        //ibm.8159
                       }                                                                                            //ibm.8159
                   }                                                                                                //ibm.8159
                                                                                                                    //ibm.8159
                   if(nextMenu != null) {                                                                           //ibm.8159
                       MenuElement newSelection[];                                                                  //ibm.8159
                       popup = ((JMenu)nextMenu).getPopupMenu();                                                    //ibm.8159
                       if(((JMenu)nextMenu).isTopLevelMenu())                                                       //ibm.8159
                           firstItem = null;                                                                        //ibm.8159
                       else {                                                                                       //ibm.8159
                           tmp = popup.getSubElements();                                                            //ibm.8159
                           if(tmp.length > 0)                                                                       //ibm.8159
                               firstItem = nextEnabledChild(tmp,0);                                                 //ibm.8159
                       }                                                                                            //ibm.8159
                                                                                                                    //ibm.8159
                       if(firstItem != null) {                                                                      //ibm.8159
                           newSelection = new MenuElement[4];                                                       //ibm.8159
                           newSelection[0] = path[0];                                                               //ibm.8159
                           newSelection[1] = nextMenu;                                                              //ibm.8159
                           newSelection[2] = popup;                                                                 //ibm.8159
                           newSelection[3] = firstItem;                                                             //ibm.8159
                       } else {                                                                                     //ibm.8159
                           newSelection = new MenuElement[3];                                                       //ibm.8159
                           newSelection[0] = path[0];                                                               //ibm.8159
                           newSelection[1] = nextMenu;                                                              //ibm.8159
                           newSelection[2] = popup;                                                                 //ibm.8159
                       }                                                                                            //ibm.8159
                       MenuSelectionManager.defaultManager().setSelectedPath(newSelection);                         //ibm.8159
                   }                                                                                                //ibm.8159
                } else {
                    MenuElement childs[] = parent.getSubElements();
                    MenuElement nextChild;
                    int i,c;
                    for(i=0,c=childs.length;i<c;i++) {
                        if(childs[i] == currentSelection[currentSelection.length-1]) {
                            nextChild = previousEnabledChild(childs,i-1);
                            if(nextChild == null)
                                nextChild = previousEnabledChild(childs,childs.length-1);
                            if(nextChild != null) {
                                currentSelection[currentSelection.length-1] = nextChild;
                                MenuSelectionManager.defaultManager().setSelectedPath(currentSelection);
                            }
                            break;
                        }
                    }
                }
            }
        }
    }

    private static class SelectParentItemAction extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            JMenuItem menu = (JMenuItem)e.getSource();      //ibm.8159 //ibm.10771
            if (!menu.isEnabled())
                return;

            MenuElement path[] = MenuSelectionManager.defaultManager().getSelectedPath();

            if(path.length > 3 && path[path.length-3].getComponent() instanceof JMenu &&
               !((JMenu)path[path.length-3].getComponent()).isTopLevelMenu()) {
                MenuElement newPath[] = new MenuElement[path.length-2];
                System.arraycopy(path,0,newPath,0,path.length-2);
                MenuSelectionManager.defaultManager().setSelectedPath(newPath);
            } else if(path.length == 2 && path[0].getComponent() instanceof JMenuBar) {                 //ibm.8159
                // For MenuBar this should be SelectPrevItem                                            //ibm.8159
                MenuElement parent = path[path.length-2];                                               //ibm.8159
                MenuElement childs[] = parent.getSubElements();                                         //ibm.8159
                MenuElement nextChild;                                                                  //ibm.8159
                int i,c;                                                                                //ibm.8159
                                                                                                        //ibm.8159
                MenuElement currentSelection[] = path;                                                  //ibm.8159
                                                                                                        //ibm.8159
                for(i=0,c=childs.length;i<c;i++) {                                                      //ibm.8159
                    if(childs[i] == currentSelection[currentSelection.length-1]) {                      //ibm.8159
                        nextChild = previousEnabledChild(childs,i-1);                                   //ibm.8159
                        if(nextChild == null)                                                           //ibm.8159
                            nextChild = previousEnabledChild(childs,childs.length-1);                   //ibm.8159
                        if(nextChild != null) {                                                         //ibm.8159
                            currentSelection[currentSelection.length-1] = nextChild;                    //ibm.8159
                            MenuSelectionManager.defaultManager().setSelectedPath(currentSelection);    //ibm.8159
                        }                                                                               //ibm.8159
                        break;                                                                          //ibm.8159
                    }                                                                                   //ibm.8159
                }                                                                                       //ibm.8159
            } else if(path.length > 0 && path[0].getComponent() instanceof JMenuBar) {
                MenuElement nextMenu=null,popup=null,firstItem=null;
                MenuElement tmp[];
                int i,c;

                if(path.length > 1) {
                    MenuElement previousElement;
                    tmp = path[0].getSubElements();
                    for(i=0,c=tmp.length;i<c;i++) {
                        if(tmp[i] == path[1]) {
                            nextMenu = previousEnabledChild(tmp,i-1);
                            if(nextMenu == null)
                                nextMenu = previousEnabledChild(tmp,tmp.length-1);
                        }
                    }
                }

                if(nextMenu != null) {
                    MenuElement newSelection[];
                    popup = ((JMenu)nextMenu).getPopupMenu();
                    if(((JMenu)nextMenu).isTopLevelMenu())
                        firstItem = null;
                    else {
                        tmp = popup.getSubElements();
                        if(tmp.length > 0)
                            firstItem = nextEnabledChild(tmp,0);
                    }

                    if(firstItem != null) {
                        newSelection = new MenuElement[4];
                        newSelection[0] = path[0];
                        newSelection[1] = nextMenu;
                        newSelection[2] = popup;
                        newSelection[3] = firstItem;
                    } else {
                        newSelection = new MenuElement[3];
                        newSelection[0] = path[0];
                        newSelection[1] = nextMenu;
                        newSelection[2] = popup;
                    }
                    MenuSelectionManager.defaultManager().setSelectedPath(newSelection);
                }
            }
        }
    }

    private static class SelectChildItemAction extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            JMenuItem menu = (JMenuItem)e.getSource();   //ibm.8159
            if (!menu.isEnabled())
                return;

            MenuElement path[] = MenuSelectionManager.defaultManager().getSelectedPath();

            if(path.length > 0 && path[path.length-1].getComponent().isEnabled() &&
               path[path.length-1].getComponent() instanceof JMenu &&
               !((JMenu)path[path.length-1].getComponent()).isTopLevelMenu()) {
                MenuElement newPath[] = new MenuElement[path.length+2];
                MenuElement subElements[];
                System.arraycopy(path,0,newPath,0,path.length);
                newPath[path.length] = ((JMenu)path[path.length-1].getComponent()).getPopupMenu();
                subElements = newPath[path.length].getSubElements();
                if(subElements.length > 0) {
                    newPath[path.length+1] = nextEnabledChild(subElements,0);
                    MenuSelectionManager.defaultManager().setSelectedPath(newPath);
                }
            } else if(path.length == 2 && path[0].getComponent() instanceof JMenuBar) {                  //ibm.8159
               // For MenuBar, this should be SelectNextItem                                             //ibm.8159
               MenuElement parent = path[path.length-2];                                                 //ibm.8159
               MenuElement childs[] = parent.getSubElements();                                           //ibm.8159
               MenuElement nextChild;                                                                    //ibm.8159
                                                                                                         //ibm.8159
               MenuElement currentSelection[] = path;                                                    //ibm.8159
                                                                                                         //ibm.8159
               int i,c;                                                                                  //ibm.8159
               for(i=0,c=childs.length;i<c;i++) {                                                        //ibm.8159
                   if(childs[i] == currentSelection[currentSelection.length-1]) {                        //ibm.8159
                       nextChild = nextEnabledChild(childs,i+1);                                         //ibm.8159
                       if(nextChild == null)                                                             //ibm.8159
                           nextChild = nextEnabledChild(childs,0);                                       //ibm.8159
                       if(nextChild != null) {                                                           //ibm.8159
                           currentSelection[currentSelection.length-1] = nextChild;                      //ibm.8159
                           MenuSelectionManager.defaultManager().setSelectedPath(currentSelection);      //ibm.8159
                       }                                                                                 //ibm.8159
                       break;                                                                            //ibm.8159
                   }                                                                                     //ibm.8159
               }                                                                                         //ibm.8159

            } else if(path.length > 0 && path[0].getComponent() instanceof JMenuBar) {
                MenuElement nextMenu=null,popup=null,firstItem=null;
                MenuElement tmp[];
                int i,c;

                if(path.length > 1) {
                    tmp = path[0].getSubElements();
                    for(i=0,c=tmp.length;i<c;i++) {
                        if(tmp[i] == path[1]) {
                            nextMenu = nextEnabledChild(tmp,i+1);
                            if(nextMenu == null)
                                nextMenu = nextEnabledChild(tmp,0);
                        }
                    }
                }

                if(nextMenu != null) {
                    MenuElement newSelection[];
                    popup = ((JMenu)nextMenu).getPopupMenu();
                    if(((JMenu)nextMenu).isTopLevelMenu())
                        firstItem = null;
                    else {
                        tmp = popup.getSubElements();
                        if(tmp.length > 0)
                            firstItem = nextEnabledChild(tmp,0);
                    }

                    if(firstItem != null) {
                        newSelection = new MenuElement[4];
                        newSelection[0] = path[0];
                        newSelection[1] = nextMenu;
                        newSelection[2] = popup;
                        newSelection[3] = firstItem;
                    } else {
                        newSelection = new MenuElement[3];
                        newSelection[0] = path[0];
                        newSelection[1] = nextMenu;
                        newSelection[2] = popup;
                    }
                    MenuSelectionManager.defaultManager().setSelectedPath(newSelection);
                }
            }
        }
    }
    //ibm.8159 : end
}
