/*
 * @(#)src/classes/sov/javax/swing/plaf/basic/MultiACI.java, as131, as131, 20031014 1.4.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 *
 * ===========================================================================
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Change activity:
 *
 * Reason  Date   Origin  Description
 * ------  ----   ------  ----------------------------------------------------
 *         270799         New file.
 * ===========================================================================
 * Module Information:
 *		
 * DESCRIPTION: Hindi, Thai, and Bidi enhancements.
 * ===========================================================================
 */

//ibm.597
/*
 * @(#)MultiACI.java	1.2 99/07/23
 *
 * Multiple attributed character iterator.
 *
 *
 * This file requires Java1.2.
 *
 * This implementation is sufficient for use in creating TextLayouts but is
 * not fully general and should not be used elsewhere.
 */

package javax.swing.plaf.basic;

import java.text.AttributedCharacterIterator;
import java.text.AttributedCharacterIterator.Attribute;
import java.text.CharacterIterator;
import java.util.Map;
import java.util.Set;

class MultiACI implements AttributedCharacterIterator {
    int start;
    int limit;
    AttributedCharacterIterator[] iters;
    int currentIter = -1;
    int currentIterStart = -1;
    int currentIterLimit = -1;

    MultiACI(int start, int limit, AttributedCharacterIterator[] iters) {
        this.start = start;
        this.limit = limit;
        this.iters = iters;

        // debug
        int count = 0;
        for (int i = 0; i < iters.length; ++i) {
            count += iterLength(i);
        }
        if (count != (limit - start)) {
            throw new IllegalArgumentException("start: " + start + " limit: " + limit + " != count: " + count);
        }
    }

    private int iterLength(int index) {
        return iters[index].getEndIndex() - iters[index].getBeginIndex();
    }

    // CI
    public char first() {
        currentIter = 0;
        currentIterStart = start;
        currentIterLimit = start + iterLength(currentIter);
        return iters[currentIter].first();
    }

    public char last() {
        currentIter = iters.length - 1;
        currentIterStart = limit - iterLength(currentIter);
        currentIterLimit = limit;
        return iters[currentIter].last();
    }

    public char current() {
        return iters[currentIter].current();
    }

    public char next() {
        char c = iters[currentIter].next();
        if (c == DONE && currentIter < iters.length - 1) {
            ++currentIter;
            currentIterStart = currentIterLimit;
            currentIterLimit += iterLength(currentIter);
            return iters[currentIter].first();
        }
        return c;
    }

    public char previous() {
        char c = iters[currentIter].previous();
        if (c == DONE && currentIter > 0) {
            --currentIter;
            currentIterLimit = currentIterStart;
            currentIterStart = currentIterLimit - iterLength(currentIter);
            return iters[currentIter].last();
        }
        return c;
    }

    public char setIndex(int position) {
        if (position < start || position > limit) {
            throw new IllegalArgumentException("Invalid index: " + position + " (" + start + ", " + limit + ")");
        }

        currentIter = 0;
        currentIterStart = 0;
        do {
            AttributedCharacterIterator aci = iters[currentIter];
            int len = aci.getEndIndex() - aci.getBeginIndex();
            currentIterLimit = currentIterStart + len;
            if (position < currentIterLimit) {
                return aci.setIndex(aci.getBeginIndex() + position - currentIterStart);
            }
            currentIterStart = currentIterLimit;
            ++currentIter;
        } while (currentIter < iters.length);

        currentIter = iters.length - 1;
        currentIterLimit = limit;
        currentIterStart = limit - iterLength(currentIter);
        return iters[currentIter].setIndex(iters[currentIter].getEndIndex());
    }

    public int getBeginIndex() {
        return start;
    }

    public int getEndIndex() {
        return limit;
    }

    public int getIndex() {
        return currentIterStart + iters[currentIter].getIndex() - iters[currentIter].getBeginIndex();
    }

    public Object clone() {
        try {
            MultiACI result = (MultiACI)super.clone();
            for (int i = 0; i < iters.length; ++i) {
                AttributedCharacterIterator iter = (AttributedCharacterIterator)iters[i].clone();
                if (iter == null) {
                    return null;
                }
                result.iters[i] = iter;
            }

            return result;
        }
        catch (CloneNotSupportedException e) {
        }

        return null;
    }

    // ACI
    // !!! doesn't merge runs, for this use it doesn't matter

    public int getRunStart() {
        int result = currentIterStart + iters[currentIter].getRunStart() - iters[currentIter].getBeginIndex();
        return result;
    }

    public int getRunStart(Attribute attribute) {
        int result = currentIterStart + iters[currentIter].getRunStart(attribute) - iters[currentIter].getBeginIndex();
        return result;
    }

    public int getRunStart(Set attributes){
        int result = currentIterStart + iters[currentIter].getRunStart(attributes) - iters[currentIter].getBeginIndex();
        return result;
    }

    public int getRunLimit() {
        int result = currentIterStart + iters[currentIter].getRunLimit() - iters[currentIter].getBeginIndex();
        return result;
    }

    public int getRunLimit(Attribute attribute) {
        int result = currentIterStart + iters[currentIter].getRunLimit(attribute) - iters[currentIter].getBeginIndex();
        return result;
    }

    public int getRunLimit(Set attributes){
        int result = currentIterStart + iters[currentIter].getRunLimit(attributes) - iters[currentIter].getBeginIndex();
        return result;
    }

    public Map getAttributes() {
        return iters[currentIter].getAttributes();
    }

    public Object getAttribute(Attribute attribute) {
        return iters[currentIter].getAttribute(attribute);
    }

    public Set getAllAttributeKeys() {
        Set result = iters[0].getAllAttributeKeys();
        for (int i = 1; i < iters.length; ++i) {
            result.addAll(iters[i].getAllAttributeKeys());
        }
        return result;
    }
}
