/*
 * @(#)src/classes/sov/javax/swing/plaf/metal/MetalDesktopIconUI.java, swing, as131, 20031014 1.8.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 *
 * ===========================================================================
 *
 * Copyright 1998-2000 Sun Microsystems, Inc. All Rights Reserved.
 * ===========================================================================
 */

/*
 * @(#)MetalDesktopIconUI.java  1.12 98/08/26
 *
 */

package javax.swing.plaf.metal;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.plaf.*;
import java.beans.*;
import java.util.EventListener;
import java.io.Serializable;
import javax.swing.plaf.basic.BasicDesktopIconUI;

/**
 * Metal desktop icon.
 *
 * @version 1.12 08/26/98
 * @author Steve Wilson
 */
public class MetalDesktopIconUI extends BasicDesktopIconUI
{

    JButton button;
    JLabel label;
    TitleListener titleListener;

    public static ComponentUI createUI(JComponent c)    {
        return new MetalDesktopIconUI();
    }

    public MetalDesktopIconUI() {
    }

    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installColorsAndFont(desktopIcon,                 //ibm.597
                                         "DesktopIcon.background",    //ibm.597
                                         "DesktopIcon.foreground",    //ibm.597
                                         "DesktopIcon.font");         //ibm.597
        desktopIcon.setOpaque(true);
    }

    protected void installComponents() {
        JInternalFrame frame = desktopIcon.getInternalFrame();
        boolean leftToRight = MetalUtils.isLeftToRight(frame);        //ibm.597
        Icon icon = frame.getFrameIcon();
        String title = frame.getTitle();

        button = new JButton(title, icon);                            //ibm.597
        button.addActionListener( new ActionListener() {
                                  public void actionPerformed(ActionEvent e) { //ibm.597
                                      deiconize();                    //ibm.597
                                  }                                   //ibm.597
        });                                                           //ibm.597

        button.setFont(desktopIcon.getFont());
        button.setBackground(desktopIcon.getBackground());
        button.setForeground(desktopIcon.getForeground());
        button.setComponentOrientation(frame.getComponentOrientation()); //ibm.597
        int buttonH = button.getPreferredSize().height;

        Icon drag = new MetalBumps((buttonH/3), buttonH,
                                   MetalLookAndFeel.getControlHighlight(),
                                   MetalLookAndFeel.getControlDarkShadow(),
                                   MetalLookAndFeel.getControl());
        label = new JLabel(drag);
        label.setBorder( new MatteBorder( 0, 2, 0, 1,                 //ibm.597
                                          desktopIcon.getBackground()) ); //ibm.597
        label.setComponentOrientation(frame.getComponentOrientation()); //ibm.597

        desktopIcon.setLayout(new BorderLayout(2, 0));
        if (leftToRight) {                                            //ibm.597
            desktopIcon.add(button, BorderLayout.CENTER);
            desktopIcon.add(label, BorderLayout.WEST);
        }                                                             //ibm.597
        else {                                                        //ibm.597
            desktopIcon.add(button, BorderLayout.WEST);               //ibm.597
            desktopIcon.add(label, BorderLayout.CENTER);              //ibm.597
        }                                                             //ibm.597
        desktopIcon.getInternalFrame().addPropertyChangeListener( titleListener = new TitleListener() );
    }

    protected void uninstallComponents() {
        desktopIcon.setLayout(null);
        desktopIcon.remove(label);
        desktopIcon.remove(button);
        desktopIcon.getInternalFrame().removePropertyChangeListener(titleListener);
    }

    public Dimension getPreferredSize(JComponent c) {
        return null;
    }

    /*                                                                //ibm.597
     * Convenience function to propagate property change for          //ibm.597
     * ComponentOrientation to the layout of the desktopIconUI        //ibm.597
     */                                                               //ibm.597
    private void changeComponentOrientation(ComponentOrientation o) { //ibm.597
        button.setComponentOrientation(o);                            //ibm.597
        label.setComponentOrientation(o);                             //ibm.597
        desktopIcon.remove(button);                                   //ibm.597
        desktopIcon.remove(label);                                    //ibm.597
        if (o.isLeftToRight()) {                                      //ibm.597
            desktopIcon.add(button, BorderLayout.CENTER);             //ibm.597
            desktopIcon.add(label, BorderLayout.WEST);                //ibm.597
        }                                                             //ibm.597
        else {                                                        //ibm.597
            desktopIcon.add(button, BorderLayout.WEST);               //ibm.597
            desktopIcon.add(label, BorderLayout.CENTER);              //ibm.597
        }                                                             //ibm.597
    }                                                                 //ibm.597

    class TitleListener implements PropertyChangeListener {
        public void propertyChange (PropertyChangeEvent e) {
          if (e.getPropertyName().equals("title")) {
            button.setText((String)e.getNewValue());
          }

          if (e.getPropertyName().equals("frameIcon")) {
            button.setIcon((Icon)e.getNewValue());
          }
          if (e.getPropertyName().equals("componentOrientation")) {   //ibm.597
             changeComponentOrientation((ComponentOrientation)e.getNewValue());    //ibm.597
             }                                                        //ibm.597
        }

    }
}
