/*
 * @(#)src/classes/sov/javax/swing/plaf/metal/MetalLabelUI.java, swing, as131, 20031014 1.7.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 * @(#)src/classes/sov/javax/swing/plaf/metal/MetalLabelUI.java, asdev, asdev, 20000317 1.4
 * ===========================================================================
 *
 * Copyright 1998-2000 Sun Microsystems, Inc. All Rights Reserved.
 * ===========================================================================
 */

/*
 * @(#)MetalLabelUI.java        1.5 98/08/26
 *
 */

package javax.swing.plaf.metal;

import javax.swing.*;
import javax.swing.plaf.*;
import javax.swing.plaf.basic.*;


import java.awt.*;


/**
 * A Windows L&F implementation of LabelUI.  This implementation
 * is completely static, i.e. there's only one UIView implementation
 * that's shared by all JLabel objects.
 *
 * @version 1.5 08/26/98
 * @author Hans Muller
 */

public class MetalLabelUI extends BasicLabelUI
{
    protected static MetalLabelUI metalLabelUI = new MetalLabelUI();

    private transient Color bg = null;

    public static ComponentUI createUI(JComponent c) {
        return metalLabelUI;
    }

    /**
     * Just paint the text gray (Label.disabledForeground) rather than
     * in the labels foreground color.
     *
     * @see #paint
     * @see #paintEnabledText
     */
    protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY)
    {
        int accChar = l.getDisplayedMnemonic();
        if (bg == null) {                                       //ibm.8159
         bg = UIManager.getColor("Label.disabledForeground");   //ibm.8159
        }                                                       //ibm.8159
        g.setColor(bg);                                         //ibm.8159
        BasicGraphicsUtils.drawString(g, s, accChar, textX, textY);
    }
}

