/*
 * @(#)src/classes/sov/javax/swing/plaf/metal/MetalTextFieldUI.java, swing, as131, 20031014 1.9.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 * @(#)src/classes/sov/javax/swing/plaf/metal/MetalTextFieldUI.java, asdev, asdev, 20000317 1.6
 * ===========================================================================
 *
 * Copyright 1998-2000 Sun Microsystems, Inc. All Rights Reserved.
 * ===========================================================================
 */

package javax.swing.plaf.metal;

import java.awt.*;
import java.beans.*;

import javax.swing.*;

import javax.swing.text.*;
import javax.swing.plaf.*;
import javax.swing.plaf.basic.*;

/**
 * Basis of a look and feel for a JTextField.
 * <p>
 * <strong>Warning:</strong>
 * Serialized objects of this class will not be compatible with
 * future Swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between applications running the same
 * version of Swing.  A future release of Swing will provide support for
 * long term persistence.
 *
 * @author  Steve Wilson
 * @version 1.8 12/09/99
 */
public class MetalTextFieldUI extends BasicTextFieldUI {

    private transient Color bg;                         //ibm.8159
    private transient Color cntr;                       //ibm.8159

    public static ComponentUI createUI(JComponent c) {
        return new MetalTextFieldUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        cntr = UIManager.getColor("control");           //ibm.8159
        bg = UIManager.getColor("TextField.background");//ibm.8159
        editableChanged(c, ((JTextComponent)c).isEditable());
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("editable")) {
            JComponent source = (JComponent)e.getSource();
            Color background = source.getBackground();
            boolean editable =  ((Boolean)e.getNewValue()).booleanValue();
            editableChanged( source, editable);
        }
        super.propertyChange(e);
    }
    private void editableChanged(JComponent c, boolean editable) {
            Color background = c.getBackground();
            if (editable == false) {
                if (background instanceof UIResource) {
                   c.setBackground(cntr);               //ibm.8159
                }
            } else {
                 if (background instanceof UIResource) {
                    c.setBackground(bg);                //ibm.8159
                }
            }
    }

}
