/*
 * @(#)src/classes/sov/javax/swing/text/html/ResourceLoader.java, swing, as131, 20031014 1.8.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 *
 * ===========================================================================
 *
 * Copyright 1998-2000 Sun Microsystems, Inc. All Rights Reserved.
 * ===========================================================================
 */
 
/*
 * @(#)ResourceLoader.java	1.3 99/04/22
 *
 */

package javax.swing.text.html;

import java.io.InputStream;

/**
 * Simple class to load resources using the 1.2
 * security model.  Since the html support is loaded
 * lazily, it's resources are potentially fetched with
 * applet code in the call stack.  By providing this 
 * functionality in a class that is only built on 1.2,
 * reflection can be used from the code that is also
 * built on 1.1 to call this functionality (and avoid
 * the evils of preprocessing).  This functionality
 * is called from HTMLEditorKit.getResourceAsStream.
 *
 * @author  Timothy Prinzing
 * @version 1.3 04/22/99
 */
class ResourceLoader implements java.security.PrivilegedAction {

    ResourceLoader(String name) {
	this.name = name;
    }

    public Object run() {
	Object o = HTMLEditorKit.class.getResourceAsStream(name);
	return o;
    }

    public static InputStream getResourceAsStream(String name) {
	java.security.PrivilegedAction a = new ResourceLoader(name);
        return (InputStream) java.security.AccessController.doPrivileged(a);
    }

    private String name;
}
