/*
 * @(#)src/classes/sov/javax/swing/text/html/TextAreaDocument.java, swing, as131, 20031014 1.7.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 * @(#)TextAreaDocument.java	1.3 98/08/26
 *
 * Copyright 1997-2000 Sun Microsystems, Inc. All Rights Reserved.
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 */
package javax.swing.text.html;

import javax.swing.text.*;


/**
 * TextAreaDocument extends the capabilities of the PlainDocument 
 * to store the data that is initially set in the Document.
 * This is stored in order to enable an accurate reset of the 
 * state when a reset is requested.
 *
 * @author Sunita Mani
 * @version 1.3 08/26/98
 */
  
class TextAreaDocument extends PlainDocument {

    String initialText;
  

    /**
     * Resets the model by removing all the data,
     * and restoring it to its initial state.
     */
    void reset() {
	try {
	    remove(0, getLength());
	    if (initialText != null) {
		insertString(0, initialText, null);
	    }
	} catch (BadLocationException e) {
	}
    }

    /**
     * Stores the data that the model is initially
     * loaded with.
     */
    void storeInitialText() {
	try {
	    initialText = getText(0, getLength());
	} catch (BadLocationException e) {
	}
    }
}




