/*
 * @(#)src/tools/sov/java.c, tool, as131, 20031014 1.27.2.12
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * US Government Users Restricted Rights - Use, duplication or disclosure
 * restricted by GSA ADP Schedule Contract with IBM Corp.
 * ===========================================================================
 */

/*
 *
 * ===========================================================================
 *
 * Copyright 2000 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 * Change activity:
 *
 * Reason  Date   Origin  Description
 * ------  ----   ------  ----------------------------------------------------
 * 005558  150300 hdece:  Missing -showversion
 * 011412  310500 hdngmr  Fixed PrintJavaVersion() (calls sun.misc.Version.print)
 * 011978  010600 hdtdg   Get jarfile name in platform encoding
 * 009648  110800 addeb   OS/2 Provide JNI compatibility for 1.1.x EXEs
 * 004561  310800 fgp     Javadump changes
 * 031774  300401 hdece   Not supporting either -hotspot or -server
 * 024586  130601 corbin  Command line options not in Javacore
 * 033260  150601 hdtdg   24586 causes LE heap damage on OS/390
 * 033224  190601 corbin  Tidy up comments
 * 033468  210601 hdpsm   Type mismatch causes 64bit compiler warnings
 * 035562  040901 hdajc   Command line arguments broken when file.encoding is ascii
 * 035768  120901 kwb     Back out change from defect 35562
 * 034732  141101 sripathiMade 'main' call '_exit' for Linux.
 * 39014.1 070102 nrichard Enable mtrace diagnostics
 * 056789  210103 websterm Sidecar launcher
 * 058362  060203 rsivaram Sidecar launcher changes
 * 061373  150503 mcculls  Allow use of -Xj9 without requiring -Xdebug
 * 061974  100603 hardillb Fix the parsing of the -Xdebug/-debug options
 * 062225  170603 hardillb refix for 061974
 * 062816  110703 sampaths Unicode characters are not allowed into the java class name
 * ===========================================================================
 * Module Information:
 *
 * DESCRIPTION: Shared source for 'java' command line tool.
 *
 * If JAVA_ARGS is defined, then acts as a launcher for applications. For
 * instance, the JDK command line tools such as javac and javadoc (see
 * makefiles for more details) are built with this program.  Any arguments
 * prefixed with '-J' will be passed directly to the 'java' command.
 *
 * If OLDJAVA is defined then enables old-style launcher behavior. In the
 * old launcher, both application and system classes are loaded from the
 * system class path.  In the new launcher, there is a separate class path
 * and class loader for loading application classes.
 *
 * ===========================================================================
 */
#if !defined(lint)
#include <oco_header.h>
static char sccsid[] = "@(#)src/tools/sov/java.c, tool, as131, 20031014 1.27.2.12";   /* CMVC and SCCS what string */
static char oco_header[] = OCO_HEADER; /* IBM copyright for object code */
#endif /* !lint */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <jni.h>
#include "java.h"

#if defined(IBM_GNUMALLOC)					/*ibm@39014.1*/
#include <mcheck.h>						/*ibm@39014.1*/
#endif /* +IBM_GNUMALLOC */					/*ibm@39014.1*/

#ifndef FULL_VERSION
#define FULL_VERSION "1.3"                              /*ibm@5558*/
#endif

#ifndef OSVERSION
#define OSVERSION "0"
#endif
static char osVersion[] = OSVERSION;                    /*ibm@409*/

static jboolean printVersion = JNI_FALSE;               /*print and exit*/
static jboolean showVersion = JNI_FALSE;                /*ibm@5558 print but continue*/
static char *progname;
jboolean debug = JNI_FALSE;

/*
 * List of VM options to be specified when the VM is created.
 */
static JavaVMOption *options;
static int numOptions, maxOptions;

/*
 * Prototypes for functions internal to launcher.
 */
static void AddOption(char *str, void *info);
static void SetClassPath(char *s);
static jboolean ParseArguments(int *pargc, char ***pargv, char **pjarfile,
                               char **pclassname, int *pret);
static jboolean InitializeJVM(JavaVM **pvm, JNIEnv **penv,
                              InvocationFunctions *ifn);
static void* MemAlloc(size_t size);
static jstring NewPlatformString(JNIEnv *env, char *s);
static jobjectArray NewPlatformStringArray(JNIEnv *env, char **strv, int strc);
static jclass LoadClass(JNIEnv *env, char *name);
static jstring GetMainClassName(JNIEnv *env, char *jarname);

#ifdef JAVA_ARGS
static void TranslateDashJArgs(int *pargc, char ***pargv);
static jboolean AddApplicationOptions(void);
#endif

static void PrintJavaVersion(JNIEnv *env);
static void PrintUsage(void);
static jint PrintXUsage(void);

/**************************************************************************
 * name         - main
 * description  - Entry point.
 * parameters   - argc  Count of command line arguments in argv
 *                argv  Array of char* holding command line parameters.
 * returns      - int status code (0=run successfully, 1=failure)
 **************************************************************************/
int
main(int argc, char **argv)
{
    JavaVM *vm = 0;
    JNIEnv *env = 0;
    char *jarfile = 0;
    char *classname = 0;
    char *s = 0;
    jclass mainClass;
    jmethodID mainID;
    jobjectArray mainArgs;
    int ret;
    InvocationFunctions ifn;
    char *jvmtype = 0;
    jboolean jvmspecified = JNI_FALSE;     /* Assume no option specified. */
    jlong start, end;
    char *commandLine;                              /*ibm@24586*/
        int i;                                          /*ibm@24586*/
    size_t commandLineLength;                       /*ibm@33468*/
    jboolean j9Override = JNI_FALSE;                /*ibm@58362*/
    char *prevArg = 0;                              /*ibm@61974*/

    /*ibm@39014.1 start*/
#if defined(IBM_GNUMALLOC)
    /*
     * The mtrace facility is enabled if IBM_MALLOCTRACE and MALLOC_TRACE
     * are both set.
     * See: http://www.gnu.org/manual/glibc-2.2.3/html_node/libc_37.html
     */
    if (getenv("IBM_MALLOCTRACE") != NULL) {
	mtrace();
    }
#endif /* +IBM_GNUMALLOC */
    /*ibm@39014.1 end*/

    InitMain(argc, argv);                           /*ibm@1140*/ /*ibm@3218*/

    ExpandCommandLineArgs();                                        /*ibm@1369*/

    if (getenv("_JAVA_LAUNCHER_DEBUG") != 0) {
        debug = JNI_TRUE;
        printf("----_JAVA_LAUNCHER_DEBUG----\n");
    }

    /* ibm@24586 ibm@33224 start
       We can get the user args easily enough later on, but we will lose
       the command line as actually typed in by the user so store it here */

        commandLineLength=0;

    for(i=0; i<argc; i++) {
        commandLineLength+=strlen(argv[i])+1;
    }

    commandLine = (char *) calloc(commandLineLength, sizeof(char));
    if(commandLine) {
        char *envName="IBM_JAVA_COMMAND_LINE", *envString;
        strcpy(commandLine, argv[0]);                         /*ibm@33260*/
        for(i=1; i<argc; i++) {                               /*ibm@33260*/
            strcat(commandLine, " ");                         /*ibm@33260*/
            strcat(commandLine, argv[i]);
        }
        envString = (char *) calloc(strlen(envName)+1 +
                                    strlen(commandLine)+1,
                                    sizeof(char));
        if(envString) {
            sprintf(envString, "%s=%s", envName, commandLine);
            putenv(envString);
        }
    }
    // ibm@24586 end


    /* Did the user pass a -classic as the first option to the launcher? ibm@31774 */
    if (argc > 1) {
        if(strcmp(argv[1], "-classic") == 0) {
            jvmtype = "classic";
            jvmspecified = JNI_TRUE;
        }
    }

    /*
     * Check Sidecar options. When "-Xdebug" specified load J9 if
     * "-Xj9" also specified
     */
     
     /* ibm@61974
      *  We need to stop searching the command line for -debug/-Xdebug and 
      *  -Xj9 when we get to the jar file or the class name, so we do not
      *  parse the application args for these options.
      */
     
    prevArg = "java";
     
    /*ibm@56789,ibm@58362*/
    ifn.debug = JNI_FALSE;
    for (i = 1; i < argc; i++) { /*ibm@61974*/
        
        /*ibm@61974 start*/
        if (argv[i][0] != '-'){
            if (strcmp(prevArg,"-cp") == 0 || strcmp(prevArg,"-classpath") == 0){  /*ibm@062225*/
                /* This is the classpath so no need to continue this itteration */
                prevArg = argv[i];
                continue;
            }
            /* Reached the jar file or the class name, time to stop looking*/
            break;
        }
        
        prevArg = argv[i];
        /*ibm@61974 end*/
        
        if (strcmp(argv[i], "-Xdebug") == 0 || strcmp(argv[i], "-debug") == 0) {
            ifn.debug = JNI_TRUE;
        }
#ifndef JAVA_ARGS
        else if (strcmp(argv[i], "-Xj9") == 0) {
            j9Override = JNI_TRUE;
        }
#endif
        
    }
    if (j9Override) {
        /* ibm@61373 - allow use of -Xj9 without requiring -Xdebug */
        ifn.debug = JNI_TRUE;
    } else {
        ifn.debug = JNI_FALSE;
    }

    ifn.CreateJavaVM = 0; ifn.GetDefaultJavaVMInitArgs = 0;
    if (!LoadJavaVM(jvmtype, &ifn))
        return 1;

    /* Grab the program name */
    progname = *argv++;
    if ((s = strrchr(progname, FILE_SEPARATOR)) != 0) {
        progname = s + 1;
    }
    --argc;

    /* Skip over a specified -classic option ibm@31774 */
    if (jvmspecified) {
        argv++;
        argc--;
    }

#ifdef JAVA_ARGS
    /* Preprocess wrapper arguments */
    TranslateDashJArgs(&argc, &argv);
    if (!AddApplicationOptions())
        return 1;
#endif

    /* Set default CLASSPATH */
    if ((s = getenv("CLASSPATH")) == 0) {
        s = ".";
    }
#ifdef OLDJAVA
    /* Prepend system class path to default */
    {
        JDK1_1InitArgs args;
        char *buf;
        args.version = JNI_VERSION_1_1;
        if (ifn.GetDefaultJavaVMInitArgs(&args) != JNI_OK ||
                args.classpath == 0) {
            fprintf(stderr, "Could not get default system class path.\n");
            return 1;
        }
        buf = MemAlloc(strlen(args.classpath) + strlen(s) + 2);
        sprintf(buf, "%s%c%s", args.classpath, PATH_SEPARATOR, s);
        s = buf;
    }
#endif
#ifndef JAVA_ARGS
    SetClassPath(s);
#endif

    /* Parse command line options */
    if (!ParseArguments(&argc, &argv, &jarfile, &classname, &ret)) {
        return ret;
    }

    /* Override class path if -jar flag was specified */
    if (jarfile != 0) {
        SetClassPath(jarfile);
    }

    /* Initialize the virtual machine */

    if (debug)
        start = CounterGet();
    if (!InitializeJVM(&vm, &env, &ifn)) {
        fprintf(stderr, "Could not create the Java virtual machine.\n");
        return 1;
    }

    if (printVersion || showVersion) {                    /*ibm@5558*/
        PrintJavaVersion(env);
        if ((*env)->ExceptionOccurred(env)) {
            (*env)->ExceptionDescribe(env);
            ret = 1;
            goto leave;
        }
        if (printVersion) {
                ret = 0;
                goto leave;
            }
        if (showVersion) {
                fprintf(stderr, "\n");
            }
    }

    /* If the user specified neither a class name or a JAR file */
    if (jarfile == 0 && classname == 0) {
        PrintUsage();
        goto leave;
    }

    if (debug) {
        end   = CounterGet();
        printf("%ld micro seconds to InitializeJVM\n",
               (jint)Counter2Micros(end-start));
    }

    /* At this stage, argc/argv have the applications' arguments */
    if (debug) {
        int i = 0;
        printf("Main-Class is '%s'\n", classname ? classname : "");
        printf("Apps' argc is %d\n", argc);
        for (; i < argc; i++) {
            printf("    argv[%2d] = '%s'\n", i, argv[i]);
        }
    }

    ret = 1;

    /* Get the application's main class */
    if (jarfile != 0) {
        char *platformJarfile = strdup(jarfile);                /*ibm@11978*/
        jstring mainClassName;                                  /*ibm@11978*/
        ConvertArgsToPlatform(1, &platformJarfile);             /*ibm@11978*/
        mainClassName = GetMainClassName(env, platformJarfile); /*ibm@11978*/
        free(platformJarfile);                                  /*ibm@11978*/
        if (mainClassName == NULL) {
            fprintf(stderr, "Failed to load Main-Class manifest attribute "
                    "from\n%s\n", jarfile);
            goto leave;
        }
        if ((*env)->ExceptionOccurred(env)) {
            (*env)->ExceptionDescribe(env);
            goto leave;
        }
        classname = (char *)(*env)->GetStringUTFChars(env, mainClassName, 0);
        if (classname == NULL) {
            (*env)->ExceptionDescribe(env);
            goto leave;
        }
        mainClass = LoadClass(env, classname);
        (*env)->ReleaseStringUTFChars(env, mainClassName, classname);
    } else {
        mainClass = LoadClass(env, classname);
    }
    if (mainClass == NULL) {
        (*env)->ExceptionDescribe(env);
        goto leave;
    }

    /* Get the application's main method */
    mainID = (*env)->GetStaticMethodID(env, mainClass, "main",
                                       "([Ljava/lang/String;)V");
    if (mainID == NULL) {
        if ((*env)->ExceptionOccurred(env)) {
            (*env)->ExceptionDescribe(env);
        } else {
            fprintf(stderr, "No main method found in specified class.\n");
        }
        goto leave;
    }

    ConvertArgsToPlatform(argc, argv);                         /*ibm@1140*/

    /* Build argument array */
    mainArgs = NewPlatformStringArray(env, argv, argc);
    if (mainArgs == NULL) {
        (*env)->ExceptionDescribe(env);
        goto leave;
    }

    /* Invoke main method. */
    (*env)->CallStaticVoidMethod(env, mainClass, mainID, mainArgs);
    if ((*env)->ExceptionOccurred(env)) {
        /* Formerly, we used to call the "uncaughtException" method of the
           main thread group, but this was later shown to be unnecessary
           since the default definition merely printed out the same exception
           stack trace as ExceptionDescribe and could never actually be
           overridden by application programs. */
        (*env)->ExceptionDescribe(env);
        goto leave;
    }

    /*
     * Detach the current thread so that it appears to have exited when
     * the application's main method exits.
     */
    if ((*vm)->DetachCurrentThread(vm) != 0) {
        fprintf(stderr, "Could not detach main thread.\n");
        goto leave;
    }
    ret = 0;

leave:
    (*vm)->DestroyJavaVM(vm);

#ifdef linux
/* ibm@34732. There exists some race condition within glibc code when more than one
 * threads try to exit simultaneously. This can result in the main thread hanging
 * indefinitely after calling 'return' or 'exit'. We are told that this problem in 
 * glibc will not be fixed. Hence until we adopt NGPT, we have to call '_exit' instead
 * of 'return'. 
 * Known side effect: Other threads may be reported as 'defunct' for a short duration until 
 * the main thread exits and other threads are cleaned up. 
 * Please refer to defect 34732 for a detailed explanation.
 */

/* ibm@61542
 * The problem with _exit() is that it terminates immediately without calling
 * any registered atexit() handlers.  This causes a problem for j9, so let's
 * try reinstating the return() call.
 */
if (j9Override) {					/*ibm@61542*/
    return ret;
} else {
    _exit(ret);
}
#else
    return ret;
#endif
}

/**************************************************************************
 * name         - AddOption
 * description  - Adds a new VM option with the given name and value.
 * parameters   - str   Option string (e.g. "-Djava.class.path=...")
 *                info  Additional information
 * returns      -
 **************************************************************************/
static void
AddOption(char *str, void *info)
{
    /*
     * Expand options array if needed to accomodate at least one more
     * VM option.
     */
    if (numOptions >= maxOptions) {
        if (options == 0) {
            maxOptions = 4;
            options = MemAlloc(maxOptions * sizeof(JavaVMOption));
        } else {
            JavaVMOption *tmp;
            maxOptions *= 2;
            tmp = MemAlloc(maxOptions * sizeof(JavaVMOption));
            memcpy(tmp, options, numOptions * sizeof(JavaVMOption));
            free(options);
            options = tmp;
        }
    }
    options[numOptions].optionString = str;
    options[numOptions++].extraInfo = info;
}

/**************************************************************************
 * name         - SetClassPath
 * description  - Set the classpath option using the supplied string
 * parameters   - s     Null terminated string holding the classpath.
 * returns      -
 **************************************************************************/
static void
SetClassPath(char *s)
{
    char *def = MemAlloc(strlen(s) + 40);
#ifdef OLDJAVA
    sprintf(def, "-Xbootclasspath:%s", s);
#else
    sprintf(def, "-Djava.class.path=%s", s);
#endif
    AddOption(def, NULL);
}

/**************************************************************************
 * name         - ParseArguments
 * description  - Parses command line arguments.
 * parameters   - pargc
 *                pargv
 *                pjarfile
 *                pclassname
 *                pret
 * returns      - JNI_FALSE or JNI_TRUE
 **************************************************************************/
static jboolean
ParseArguments(int *pargc, char ***pargv, char **pjarfile,
                       char **pclassname, int *pret)
{
    int argc = *pargc;
    char **argv = *pargv;
    jboolean jarflag = JNI_FALSE;
    char *arg;

    *pret = 1;
    while ((arg = *argv) != 0 && *arg == '-') {
        argv++; --argc;
        if (strcmp(arg, "-classpath") == 0 || strcmp(arg, "-cp") == 0) {
            if (argc < 1) {
                fprintf(stderr, "%s requires class path specification\n", arg);
                PrintUsage();
                return JNI_FALSE;
            }
            SetClassPath(*argv);
            argv++; --argc;
#ifndef OLDJAVA
        } else if (strcmp(arg, "-jar") == 0) {
            jarflag = JNI_TRUE;
#endif
        } else if (strcmp(arg, "-help") == 0 ||
                   strcmp(arg, "-h") == 0 ||
                   strcmp(arg, "-?") == 0) {
            PrintUsage();
            *pret = 0;
            return JNI_FALSE;
        } else if (strcmp(arg, "-version") == 0) {
            printVersion = JNI_TRUE;
            return JNI_TRUE;
        } else if (strcmp(arg, "-showversion") == 0) {  /*ibm@5558*/
            showVersion = JNI_TRUE;                     /*ibm@5558*/
        } else if (strcmp(arg, "-X") == 0) {
            *pret = PrintXUsage();
            return JNI_FALSE;
/*
 * The following case provide backward compatibility with old-style
 * command line options.
 */
        } else if (strcmp(arg, "-fullversion") == 0) {
            fprintf(stderr, "%s full version \"%s\"\n", progname,
                    FULL_VERSION);
            *pret = 0;
            return JNI_FALSE;
        } else if (strcmp(arg, "-verbosegc") == 0) {
            AddOption("-verbose:gc", NULL);
        } else if (strcmp(arg, "-t") == 0) {
            AddOption("-Xt", NULL);
        } else if (strcmp(arg, "-tm") == 0) {
            AddOption("-Xtm", NULL);
        } else if (strcmp(arg, "-debug") == 0) {
            AddOption("-Xdebug", NULL);
        } else if (strcmp(arg, "-noclassgc") == 0) {
            AddOption("-Xnoclassgc", NULL);
        } else if (strcmp(arg, "-Xfuture") == 0) {
            AddOption("-Xverify:all", NULL);
        } else if (strcmp(arg, "-verify") == 0) {
            AddOption("-Xverify:all", NULL);
        } else if (strcmp(arg, "-verifyremote") == 0) {
            AddOption("-Xverify:remote", NULL);
        } else if (strcmp(arg, "-noverify") == 0) {
            AddOption("-Xverify:none", NULL);
        } else if (strncmp(arg, "-prof", 5) == 0) {
            char *p = arg + 5;
            char *tmp = MemAlloc(strlen(arg) + 50);
            if (*p) {
                sprintf(tmp, "-Xrunhprof:cpu=old,file=%s", p + 1);
            } else {
                sprintf(tmp, "-Xrunhprof:cpu=old,file=java.prof");
            }
            AddOption(tmp, NULL);
        } else if (strncmp(arg, "-ss", 3) == 0 ||
                   strncmp(arg, "-oss", 4) == 0 ||
                   strncmp(arg, "-ms", 3) == 0 ||
                   strncmp(arg, "-mx", 3) == 0) {
            char *tmp = MemAlloc(strlen(arg) + 6);
            sprintf(tmp, "-X%s", arg + 1); /* skip '-' */
            AddOption(tmp, NULL);
        } else if (strcmp(arg, "-checksource") == 0 ||
                   strcmp(arg, "-cs") == 0 ||
                   strcmp(arg, "-noasyncgc") == 0) {
            /* No longer supported */
            fprintf(stderr,
                    "Warning: %s option is no longer supported.\n",
                    arg);
        /* Do not pass "-Xj9" Sidecar option through to JVM ibm@56789,ibm@58362 */
#ifndef JAVA_ARGS
        } else if (strcmp(arg, "-Xj9") == 0) {
#endif
        } else {
            AddOption(arg, NULL);
        }
    }
    /*
       Set a property saying that the JVM was invoked via
       the java command.                            ibm@4561
    */
    AddOption("-Dinvokedviajava",NULL);   /*ibm@4561*/

    if (--argc >= 0) {
        if (jarflag) {
            *pjarfile = *argv++;
            *pclassname = 0;
        } else {
            *pjarfile = 0;
            *pclassname = *argv++;
        }
        *pargc = argc;
        *pargv = argv;
    }

    return JNI_TRUE;
}

/**************************************************************************
 * name         - InitializeJVM
 * description  - Initializes the Java Virtual Machine. Also frees options
 *                array when finished.
 * parameters   - pvm
 *                penv
 *                ifn
 * returns      - true if CreateJavaVM returns JNI_OK, else false
 **************************************************************************/
static jboolean
InitializeJVM(JavaVM **pvm, JNIEnv **penv, InvocationFunctions *ifn)
{
    JavaVMInitArgs args;
    jint r;

#ifdef OLDJAVA
    /* Indicate that we are using the old-style launcher */
    AddOption("-Xoldjava", NULL);
#endif
#if defined(IBM_BUILD_TYPE_dev)                                     /*ibm@1303*/
    AddOption("-Djava.execsuffix=_d", NULL);                        /*ibm@1303*/
#elif defined(IBM_BUILD_TYPE_col)                                   /*ibm@1303*/
    AddOption("-Djava.execsuffix=_g", NULL);                        /*ibm@1303*/
#endif                                                              /*ibm@1303*/
#if defined(IBM_QUICKSTART)                                         /*ibm@33550*/
    AddOption("-Xquickstart", NULL);                                /*ibm@33550*//*ibm@33806*/
#endif                                                              /*ibm@33550*/

    SetInternalLinkage();                                           /*ibm@9648*/

    memset(&args, 0, sizeof(args));
    args.version  = JNI_VERSION_1_2;
    args.nOptions = numOptions;
    args.options  = options;
    args.ignoreUnrecognized = JNI_FALSE;

    if (debug) {
        int i = 0;
        printf("JavaVM args:\n    ");
        printf("version 0x%08lx, ", args.version);
        printf("ignoreUnrecognized is %s, ",
               args.ignoreUnrecognized ? "JNI_TRUE" : "JNI_FALSE");
        printf("nOptions is %ld\n", args.nOptions);
        for (i = 0; i < numOptions; i++)
            printf("    option[%2d] = '%s'\n",
                   i, args.options[i].optionString);
    }

    r = ifn->CreateJavaVM(pvm, (void **)penv, &args);
    if (r == JNI_EINVAL)    /*ibm@1097*/
        PrintUsage();       /*ibm@1097*/
    free(options);
    return r == JNI_OK;
}


#define NULL_CHECK0(e) if ((e) == 0) return 0
#define NULL_CHECK(e) if ((e) == 0) return

/**************************************************************************
 * name         - MemAlloc
 * description  - Returns a pointer to a block of at least 'size' bytes
 *                of memory. Prints error message and exits if the memory
 *                could not be allocated.
 * parameters   - size  Size of memory requested
 * returns      - Pointer to block of allocated memory.
 **************************************************************************/
static void *
MemAlloc(size_t size)
{
    void *p = malloc(size);
    if (p == 0) {
        perror("malloc");
        exit(1);
    }
    return p;
}

/**************************************************************************
 * name         - NewPlatformString
 * description  - Returns a new Java string object for the specified
 *                platform string.
 * parameters   - env
 *                s     Platform encoded string
 * returns      - Java string object pointer or null (0)
 **************************************************************************/
static jstring
NewPlatformString(JNIEnv *env, char *s)
{
    size_t len = strlen(s);                                         /*ibm@7418*/
    jclass cls;
    jmethodID mid;
    jbyteArray ary;

    NULL_CHECK0(cls = (*env)->FindClass(env, "java/lang/String"));
    NULL_CHECK0(mid = (*env)->GetMethodID(env, cls, "<init>", "([B)V"));
    ary = (*env)->NewByteArray(env, (jsize)len);                    /*ibm@7418*/
    if (ary != 0) {
        jstring str = 0;
        (*env)->SetByteArrayRegion(env, ary, 0, (jsize)len,         /*ibm@7418*/
                                   (jbyte *)s);
        if (!(*env)->ExceptionOccurred(env)) {
            str = (*env)->NewObject(env, cls, mid, ary);
        }
        (*env)->DeleteLocalRef(env, ary);
        return str;
    }
    return 0;
}

/**************************************************************************
 * name         - NewPlatformStringArray
 * description  - Returns a new array of Java string objects for the specified
 *                array of platform strings.
 * parameters   - env
 *                strv      Platform encoded string array
 *                strc      Number of strings in strv
 * returns      - Java string array object pointer
 **************************************************************************/
static jobjectArray
NewPlatformStringArray(JNIEnv *env, char **strv, int strc)
{
    jarray cls;
    jarray ary;
    int i;

    NULL_CHECK0(cls = (*env)->FindClass(env, "java/lang/String"));
    NULL_CHECK0(ary = (*env)->NewObjectArray(env, strc, cls, 0));
    for (i = 0; i < strc; i++) {
        jstring str = NewPlatformString(env, *strv++);
        NULL_CHECK0(str);
        (*env)->SetObjectArrayElement(env, ary, i, str);
        (*env)->DeleteLocalRef(env, str);
    }
    return ary;
}

/**************************************************************************
 * name         - LoadClass
 * description  - Loads a class, convert the '.' to '/'.
 * parameters   - env
 *                name      Class name to load
 * returns      - Java class object pointer
 **************************************************************************/
static jclass
LoadClass(JNIEnv *env, char *name)
{
    char *buf = MemAlloc(strlen(name) + 1);
    char *s = buf, *t = name; /*ibm@062816*/
    jclass cls;
	jclass ThrowableCls;    /*ibm@062816*/
	jmethodID toString = 0; /*ibm@062816*/
    int    nonASCII = 0;   /*ibm@062816*/
	jlong start, end;

    if (debug)
        start = CounterGet();

	/*ibm@062816 Start ::Unicode characters are not allowed into the java class name*/
	strcpy(buf, name);

	/*
     * Check if there are any non-ASCII chars in the name.
     * This is just a performance enhancement in the normal case
     * where the class name is a simple ASCII string.
     */
    for (s=name; *s; s++) {
        if (*s & 0x80 || *s=='\\') {
                nonASCII = 1;
                break;
         }
	}

	/*
     * If there are non-ASCII chars in the name, convert it
     * to UTF8.
     */
    if (nonASCII) {
       jstring str = NewPlatformString(env, name);//, ArgEncoding);
       name = (char *)(*env)->GetStringUTFChars(env, str, 0);
       if (name != NULL) {
              strcpy(buf, name);
              (*env)->ReleaseStringUTFChars(env, str, name);
              (*env)->DeleteLocalRef(env, str);
       }
    }

	/*
     * Change any period in the string to a slash since that is what
     * the class loader expects.
     */
    for (s=buf; *s; s++) {
      if (*s=='.') *s = '/';
	}

	/*
     * Get these in case we need them.  We cannot get them during
     * exception processing.
     */
	ThrowableCls = (*env)->FindClass(env, "java/lang/Throwable");
	if (ThrowableCls) {
		toString = (*env)->GetMethodID(env, ThrowableCls,
                    "toString", "()Ljava/lang/String;");
	}
    /*
     * We now have a UTF8 class name to look up.
     */
    cls = (*env)->FindClass(env, buf);

    /*ibm@062816 End ::Unicode characters are not allowed into the java class name*/

    free(buf);

    if (debug) {
        end   = CounterGet();
        printf("%ld micro seconds to load main class\n",
               (jint)Counter2Micros(end-start));
        printf("----_JAVA_LAUNCHER_DEBUG----\n");
    }

    return cls;
}

/**************************************************************************
 * name         - GetMainClassName
 * description  - Returns the main class name for the specified jar file.
 * parameters   - env
 *                jarname
 * returns      - Java string object pointer holding the main class name
 **************************************************************************/
static jstring
GetMainClassName(JNIEnv *env, char *jarname)
{
#define MAIN_CLASS "Main-Class"
    jclass cls;
    jmethodID mid;
    jobject jar, man, attr;
    jstring str, result = 0;

    NULL_CHECK0(cls = (*env)->FindClass(env, "java/util/jar/JarFile"));
    NULL_CHECK0(mid = (*env)->GetMethodID(env, cls, "<init>",
                                          "(Ljava/lang/String;)V"));
    NULL_CHECK0(str = NewPlatformString(env, jarname));
    NULL_CHECK0(jar = (*env)->NewObject(env, cls, mid, str));
    NULL_CHECK0(mid = (*env)->GetMethodID(env, cls, "getManifest",
                                          "()Ljava/util/jar/Manifest;"));
    man = (*env)->CallObjectMethod(env, jar, mid);
    if (man != 0) {
        NULL_CHECK0(mid = (*env)->GetMethodID(env,
                                    (*env)->GetObjectClass(env, man),
                                    "getMainAttributes",
                                    "()Ljava/util/jar/Attributes;"));
        attr = (*env)->CallObjectMethod(env, man, mid);
        if (attr != 0) {
            char *platformMainclass = strdup(MAIN_CLASS);                 /*ibm@11978*/
            ConvertArgsToPlatform(1, &platformMainclass);                 /*ibm@11978*/
            NULL_CHECK0(mid = (*env)->GetMethodID(env,
                                    (*env)->GetObjectClass(env, attr),
                                    "getValue",
                                    "(Ljava/lang/String;)Ljava/lang/String;"));
            NULL_CHECK0(str = NewPlatformString(env, platformMainclass)); /*ibm@11978*/
            free(platformMainclass);                                      /*ibm@11978*/
            result = (*env)->CallObjectMethod(env, attr, mid, str);
        }
    }
    return result;
}

#ifdef JAVA_ARGS
static char *java_args[] = JAVA_ARGS;
static char *app_classpath[] = APP_CLASSPATH;
#define NUM_ARGS (sizeof(java_args) / sizeof(char *))
#define NUM_APP_CLASSPATH (sizeof(app_classpath) / sizeof(char *))

/**************************************************************************
 * name         - TranslateDashJArgs
 * description  - For tools convert 'javac -J-ms32m' to 'java -ms32m ...'
 * parameters   - pargc     Pointer to an int holding the size of parameter
 *                          array
 *                pargv     Pointer to array of command line parameters
 *                          (strings)
 * returns      -
 **************************************************************************/
static void
TranslateDashJArgs(int *pargc, char ***pargv)
{
    int argc = *pargc;
    char **argv = *pargv;
    int nargc = argc + NUM_ARGS;
    char **nargv = MemAlloc((nargc + 1) * sizeof(char *));
    int i;

    *pargc = nargc;
    *pargv = nargv;

    /* Copy the VM arguments (i.e. prefixed with -J) */
    for (i = 0; i < NUM_ARGS; i++) {
        char *arg = java_args[i];
        if (arg[0] == '-' && arg[1] == 'J')
            *nargv++ = arg + 2;
    }

    for (i = 0; i < argc; i++) {
        char *arg = argv[i];
        if (arg[0] == '-' && arg[1] == 'J')
            *nargv++ = arg + 2;
    }

    /* Copy the rest of the arguments */
    for (i = 0; i < NUM_ARGS; i++) {
        char *arg = java_args[i];
        if (arg[0] != '-' || arg[1] != 'J') {
            *nargv++ = arg;
        }
    }
    for (i = 0; i < argc; i++) {
        char *arg = argv[i];
        if (arg[0] != '-' || arg[1] != 'J') {
            *nargv++ = arg;
        }
    }
    *nargv = 0;
}

/**************************************************************************
 * name         - AddApplicationOptions
 * description  -
 *      For our tools, we try to add 3 VM options:
 *          -Denv.class.path=<envcp>
 *          -Dapplication.home=<apphome>
 *          -Djava.class.path=<appcp>
 *      <envcp> is the user's setting of CLASSPATH -- for instance the user
 *              tells javac where to find binary classes through this environment
 *              variable. Notice that users will be able to compile against our
 *              tools classes (sun.tools.javac.Main) only if they explicitly add
 *              tools.jar to CLASSPATH.
 *      <apphome> is the directory where the application is installed.
 *      <appcp>   is the classpath to where our apps' classfiles are.
 * parameters   -
 * returns      - JNI_FALSE if unable to get application home, else JNI_TRUE
 **************************************************************************/
static jboolean
AddApplicationOptions()
{
    char *s, *envcp, *appcp, *apphome;
    char home[MAXPATHLEN]; /* application home */
    char separator[] = { PATH_SEPARATOR, '\0' };
    size_t size;                                                    /*ibm@7489*/
    int i;

    s = getenv("CLASSPATH");
    if (s) {
        /* 40 for -Denv.class.path= */
        envcp = (char *)MemAlloc(strlen(s) + 40);
        sprintf(envcp, "-Denv.class.path=%s", s);
        AddOption(envcp, NULL);
    }

    if (!GetApplicationHome(home, sizeof(home))) {
        fprintf(stderr, "Can't determine application home\n");
        return JNI_FALSE;
    }

    /* 40 for '-Dapplication.home=' */
    apphome = (char *)MemAlloc(strlen(home) + 40);
    sprintf(apphome, "-Dapplication.home=%s", home);
    AddOption(apphome, NULL);

    /* How big is the application's classpath? */
    size = strlen(home) * NUM_APP_CLASSPATH + 40; /* 40: -Djava.class.path */
    for (i = 0; i < NUM_APP_CLASSPATH; i++) {
        size += strlen(app_classpath[i]);
    }
    appcp = (char *)MemAlloc(size + 1);
    strcpy(appcp, "-Djava.class.path=");
    for (i = 0; i < NUM_APP_CLASSPATH; i++) {
        strcat(appcp, home);                    /* c:\program files\myapp */
        strcat(appcp, app_classpath[i]);        /* lib\myapp.jar          */
        strcat(appcp, separator);               /* ;                      */
    }
    appcp[strlen(appcp)-1] = '\0';  /* remove trailing path separator */
    AddOption(appcp, NULL);
    return JNI_TRUE;
}
#endif

/**************************************************************************
 * name         - PrintJavaVersion
 * description  - Prints the version information from the java.version
 *                and other properties.
 * parameters   - env
 * returns      -
 **************************************************************************/
static void
PrintJavaVersion(JNIEnv *env)
{
    jclass ver;                                                      /*ibm.11412*/
    jmethodID print;                                                 /*ibm.11412*/

    NULL_CHECK(ver = (*env)->FindClass(env, "sun/misc/Version"));    /*ibm.11412*/
    NULL_CHECK(print =
        (*env)->GetStaticMethodID(env, ver, "print", "()V"));        /*ibm.11412*/

    (*env)->CallStaticVoidMethod(env, ver, print);                   /*ibm.11412*/
}

/**************************************************************************
 * name         - PrintUsage
 * description  - Prints default usage message.
 * parameters   -
 * returns      -
 **************************************************************************/
static void
PrintUsage(void)
{
    fprintf(stdout,
        "Usage: %s [-options] class [args...]\n"
#ifndef OLDJAVA
        "           (to execute a class)\n"
        "   or  %s -jar [-options] jarfile [args...]\n"
        "           (to execute a jar file)\n"
#endif
        "\n"
        "where options include:\n"
#ifdef OLDJAVA
        "    -cp -classpath <directories and zip/jar files separated by %c>\n"
        "              set search path for classes and resources\n"
#else
        "    -cp -classpath <directories and zip/jar files separated by %c>\n"
        "              set search path for application classes and resources\n"
#endif
        "    -D<name>=<value>\n"
        "              set a system property\n"
        "    -verbose[:class|gc|jni]\n"
        "              enable verbose output\n"
        "    -version  print product version\n"
        "    -showversion  print product version and continue\n"
        "    -? -help  print this help message\n"
        "    -X        print help on non-standard options\n",
#ifndef OLDJAVA
        progname,
#endif
        progname, PATH_SEPARATOR
    );
}

/**************************************************************************
 * name         - PrintXUsage
 * description  - Print usage message for -X options.
 * parameters   -
 * returns      - 1 if failed else 0
 **************************************************************************/
static jint
PrintXUsage(void)
{
    char path[MAXPATHLEN];
    char buf[128];
    size_t n;                                                       /*ibm@7418*/
    FILE *fp;

    GetXUsagePath(path, sizeof(path));
    fp = fopen(path, "r");
    if (fp == 0) {
        fprintf(stderr, "Can't open %s\n", path);
        return 1;
    }
    while ((n = fread(buf, 1, sizeof(buf), fp)) != 0) {
        fwrite(buf, 1, n, stdout);
    }
    fclose(fp);
    return 0;
}
