/*
 * @(#)src/tools/sov/java.h, tool, as131, 20031014 1.7.2.2
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * US Government Users Restricted Rights - Use, duplication or disclosure
 * restricted by GSA ADP Schedule Contract with IBM Corp.
 * ===========================================================================
 */

/*
 *
 * ===========================================================================
 *
 * Copyright 2000 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 * Change activity:
 *
 * Reason  Date   Origin  Description
 * ------  ----   ------  ----------------------------------------------------
 * 056789  210103 websterm Sidecar launcher
 *
 * ===========================================================================
 */

/*
 * @(#)java.h   1.9 98/06/29
 *
 */

#ifndef _JAVA_H_
#define _JAVA_H_

/*
 * Get system specific defines.
 */
#include "jni.h"
#include "java_md.h"

/*
 * function types used for InvocationFunctions data type below.
 * ibm.91
 */
typedef jint (JNICALL *inv_func_create_t)(JavaVM **pvm, void **env, void *args);
typedef jint (JNICALL *inv_func_getargs_t)(void *args);

/*
 * Pointers to the needed JNI invocation API, initialized by LoadJavaVM.
 */
typedef struct {
    inv_func_create_t CreateJavaVM;                     /* ibm.91 */
    inv_func_getargs_t GetDefaultJavaVMInitArgs;        /* ibm.91 */
    jboolean debug;                                    /*ibm@56789*/
} InvocationFunctions;

/*ibm@9648*/
#ifndef SetInternalLinkage
#define SetInternalLinkage()
#endif

/*
 * Protoypes for launcher functions in the system specific java_md.c.
 */
jboolean LoadJavaVM(char *jvmtype, InvocationFunctions *ifn);
void GetXUsagePath(char *buf, jint bufsize);
jboolean GetApplicationHome(char *buf, jint bufsize);
void ExpandCommandLineArgs(void);                                   /*ibm@1369*/

/*
 * Make launcher spit debug output.
 */
extern jboolean debug;

#endif /* _JAVA_H_ */
