/*
 * @(#)src/tools/pfm/java_md.c, tool, an32131, 20030704 1.2.7.2
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * US Government Users Restricted Rights - Use, duplication or disclosure
 * restricted by GSA ADP Schedule Contract with IBM Corp.
 * ===========================================================================
 */

/*
 *
 * ===========================================================================
 *
 *
 * Copyright 1998-2000 Sun Microsystems, Inc. All Rights Reserved.
 *
 * ===========================================================================
 * Change activity:
 *
 * Reason  Date   Origin  Description
 * ------  ----   ------  ----------------------------------------------------
 *   5827  250100 hdece:  Registry key should be 1.3
 * 006553  030300 hdmkv:  Use /DRELEASE for dot release determination
 * 033324  180601 hdajc:  Use full version release for registry key
 * 056789  210103 websterm Sidecar launcher
 *
 * ===========================================================================
 * Module Information:
 *
 * DESCRIPTION: Platform dependent routines for java tool
 *
 * ===========================================================================
 */


#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <jni.h>
#include "java.h"

#if defined(IBM_BUILD_TYPE_dev)                                       /*ibm.49*/
  #define JVM_DLL "jvm_d.dll"
  #define JAVA_DLL "java_d.dll"
#elif defined(IBM_BUILD_TYPE_col)                                     /*ibm.49*/
  #define JVM_DLL "jvm_g.dll"
  #define JAVA_DLL "java_g.dll"
#else                                                                 /*ibm.49*/
  #define JVM_DLL "jvm.dll"
  #define JAVA_DLL "java.dll"
#endif                                                                /*ibm.49*/

/*
 * Prototypes.
 */
static jboolean
GetPublicJREHome(char *path, jint pathsize);
void __cdecl _setargv(void);                                        /*ibm@1369*/

/* start ibm@1369
 * Expand any wildcards in the command line
 */
void
ExpandCommandLineArgs(void)
{
    _setargv();
}
/* end ibm@1369 */

/*
 * Load JVM of "jvmtype", and intialize the invocation functions.  Notice that
 * if jvmtype is NULL, we try to load hotspot VM as the default.  Maybe we
 * need an environment variable that dictates the choice of default VM.
 */
jboolean
LoadJavaVM(char *jvmtype, InvocationFunctions *ifn)
{
    char home[MAXPATHLEN], javadll[MAXPATHLEN], jvmdll[MAXPATHLEN];
    HINSTANCE handle;
    struct stat s;

    /* Is JRE co-located with the application? */
    if (GetApplicationHome(home, sizeof(home))) {
        sprintf(javadll, "%s\\bin\\" JAVA_DLL, home);
        if (stat(javadll, &s) == 0)
            goto jrefound;
    }
    /* Does this app ship a private JRE in <apphome>\jre directory? */
    sprintf(javadll, "%s\\jre\\bin\\" JAVA_DLL, home);
    if (stat(javadll, &s) == 0) {
        strcat(home, "\\jre");
        goto jrefound;
    }
    /* Look for a public JRE on this machine. */
    if (!GetPublicJREHome(home, sizeof(home))) {
        return JNI_FALSE;
    }

    /* Now we know where JRE is -- the value in the "home" variable. */
jrefound:

    /* Try to load the J9 JVM ibm@56789*/
    if (JNI_TRUE == ifn->debug) {
        sprintf(jvmdll, "%s\\bin\\j9vm\\" JVM_DLL, home);
        if (stat(jvmdll, &s) == 0) {
            jvmtype = "j9vm";
        }
    }

    /* Determine if Hotspot VM is installed. */
    if (jvmtype == NULL) {
        sprintf(jvmdll, "%s\\bin\\hotspot\\" JVM_DLL, home);
        if (stat(jvmdll, &s) < 0) {
            jvmtype = "classic";
        } else {
            jvmtype = "hotspot";
        }
    }

    /* We now know what jvmtype should be */
    sprintf(jvmdll, "%s\\bin\\%s\\" JVM_DLL, home, jvmtype);
    if (debug) {
        printf("Path to JVM is %s\n", jvmdll);
    }

    /* Load the Java VM DLL */
    if ((handle = LoadLibrary(jvmdll)) == 0) {
        fprintf(stderr, "Error loading: %s\n", jvmdll);
        return JNI_FALSE;
    }

    /* Now get the function addresses */
    ifn->CreateJavaVM =
        (void *)GetProcAddress(handle, "JNI_CreateJavaVM");
    ifn->GetDefaultJavaVMInitArgs =
        (void *)GetProcAddress(handle, "JNI_GetDefaultJavaVMInitArgs");
    if (ifn->CreateJavaVM == 0 ||
        ifn->GetDefaultJavaVMInitArgs == 0) {
        fprintf(stderr, "Can't find JNI interfaces in: %s\n", jvmdll);
        return JNI_FALSE;
    }

    return JNI_TRUE;
}

/*
 * Get the path to the file that has the usage message for -X options.
 */
void
GetXUsagePath(char *buf, jint bufsize)
{
    GetModuleFileName(GetModuleHandle(JVM_DLL), buf, bufsize);
    *(strrchr(buf, '\\')) = '\0';
    strcat(buf, "\\Xusage.txt");
}

/*
 * If app is "c:\foo\bin\javac", then put "c:\foo" into buf.
 */
jboolean
GetApplicationHome(char *buf, jint bufsize)
{
    char *cp;
    GetModuleFileName(0, buf, bufsize);
    *strrchr(buf, '\\') = '\0'; /* remove .exe file name */
    if ((cp = strrchr(buf, '\\')) == 0) {
        /* This happens if the application is in a drive root, and
         * there is no bin directory. */
        buf[0] = '\0';
        return JNI_FALSE;
    }
    *cp = '\0';  /* remove the bin\ part */
    return JNI_TRUE;
}

#ifdef JAVAW
__declspec(dllimport) char **__initenv;

int WINAPI
WinMain(HINSTANCE inst, HINSTANCE previnst, LPSTR cmdline, int cmdshow)
{
    __initenv = _environ;
    return main(__argc, __argv);
}
#endif

/*
 * Helpers to look in the registry for a public JRE.
 */
#define JRE_KEY     "Software\\IBM\\Java2 Runtime Environment"       /*ibm@613*/

static jboolean
GetStringFromRegistry(HKEY key, const char *name, char *buf, jint bufsize)
{
    DWORD type, size;

    if (RegQueryValueEx(key, name, 0, &type, 0, &size) == 0
        && type == REG_SZ
        && (size < (unsigned int)bufsize)) {
        if (RegQueryValueEx(key, name, 0, 0, buf, &size) == 0) {
            return JNI_TRUE;
        }
    }
    return JNI_FALSE;
}

static jboolean
GetPublicJREHome(char *buf, jint bufsize)
{
    HKEY key, subkey;
    char version[MAXPATHLEN];
    char dotrelease[MAXPATHLEN];                                    /*ibm@6553*/
    char *ptr;                                                      /*ibm@6553*/

    /*
     * Determine our current version & releaase from the RELEASE macro  ibm@6553
     * defined at build time. We want <version>.<release> eg 1.3        ibm@6553
     */

    strcpy(dotrelease,RELEASE);       /* Initialise string            ibm@6553*/
    ptr = strchr(dotrelease,'.');     /* Find first dot               ibm@6553*/
    if (ptr) ptr = strchr(ptr+1,'.'); /* Find second dot              ibm@6553*/
    // if (ptr) *ptr = 0;                /* Change second dot to null    ibm@6553*/ /* Use full version for registry key   ibm@33324 */
    else {                                                          /*ibm@6553*/
        fprintf(stderr, "Unable to determine my own version and release.\n");
        return JNI_FALSE;
    }

    /* Find the current version of the JRE */
    if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, JRE_KEY, 0, KEY_READ, &key) != 0) {
        fprintf(stderr, "Error opening registry key '" JRE_KEY "'\n");
        return JNI_FALSE;
    }

    if (!GetStringFromRegistry(key, "CurrentVersion",
                               version, sizeof(version))) {
        fprintf(stderr, "Failed reading value of registry key:\n\t"
                JRE_KEY "\\CurrentVersion\n");
        RegCloseKey(key);
        return JNI_FALSE;
    }

    if (strcmp(version, dotrelease) != 0) {                         /*ibm@6553*/
        fprintf(stderr, "Registry key '" JRE_KEY "\\CurrentVersion'\nhas "
         "value '%s', but '%s' is required.\n",version,dotrelease); /*ibm@6553*/
        RegCloseKey(key);
        return JNI_FALSE;
    }

    /* Find directory where the current version is installed. */
    if (RegOpenKeyEx(key, version, 0, KEY_READ, &subkey) != 0) {
        fprintf(stderr, "Error opening registry key '"
                JRE_KEY "\\%s'\n", version);
        RegCloseKey(key);
        return JNI_FALSE;
    }

    if (!GetStringFromRegistry(subkey, "JavaHome", buf, bufsize)) {
        fprintf(stderr, "Failed reading value of registry key:\n\t"
                JRE_KEY "\\%s\\JavaHome\n", version);
        RegCloseKey(key);
        RegCloseKey(subkey);
        return JNI_FALSE;
    }

    if (debug) {
        char micro[MAXPATHLEN];
        if (!GetStringFromRegistry(subkey, "MicroVersion", micro,
                                   sizeof(micro))) {
            printf("Warning: Can't read MicroVersion\n");
            micro[0] = '\0';
        }
        printf("Version major.minor.micro = %s.%s\n", version, micro);
    }

    RegCloseKey(key);
    RegCloseKey(subkey);
    return JNI_TRUE;
}

/*
 * Support for doing cheap, accurate interval timing.
 */
static jboolean counterAvailable = JNI_FALSE;
static jboolean counterInitialized = JNI_FALSE;
static LARGE_INTEGER counterFrequency;

jlong CounterGet()
{
    LARGE_INTEGER count;

    if (!counterInitialized) {
        counterAvailable = QueryPerformanceFrequency(&counterFrequency);
        counterInitialized = JNI_TRUE;
    }
    if (!counterAvailable) {
        return 0;
    }
    QueryPerformanceCounter(&count);
    return (jlong)(count.QuadPart);
}

jlong Counter2Micros(jlong counts)
{
    if (!counterAvailable || !counterInitialized) {
        return 0;
    }
    return (counts * 1000 * 1000)/counterFrequency.QuadPart;
}
