/*
 * @(#)src/classes/sov/org/omg/CORBA/CharHolder.java, orb-api, as131, 20031014 1.4.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 *
 * ===========================================================================
 *
 * Copyright 1995-2000 Sun Microsystems, Inc. All Rights Reserved.
 * ===========================================================================
 */
 
/*
 * @(#)CharHolder.java	1.21 98/08/31
 *
 */


package org.omg.CORBA;

import org.omg.CORBA.portable.Streamable;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

/**
 * A Holder class for a <code>char</code>
 * that is used to store "out" and "inout" parameters in IDL methods.
 * If an IDL method signature has an IDL <code>char</code> as an "out"
 * or "inout" parameter, the programmer must pass an instance of
 * <code>CharHolder</code> as the corresponding
 * parameter in the method invocation; for "inout" parameters, the programmer
 * must also fill the "in" value to be sent to the server.
 * Before the method invocation returns, the ORB will fill in the
 * value corresponding to the "out" value returned from the server.
 * <P>
 * If <code>myCharHolder</code> is an instance of <code>CharHolder</code>,
 * the value stored in its <code>value</code> field can be accessed with
 * <code>myCharHolder.value</code>.
 *
 * @version	1.14, 09/09/97
 * @since       JDK1.2
 */
public final class CharHolder implements Streamable {

    /**
     * The <code>char</code> value held by this <code>CharHolder</code>
     * object.
     */
    public char value;
    
    /**
     * Constructs a new <code>CharHolder</code> object with its
     * <code>value</code> field initialized to <code>0</code>.
     */
    public CharHolder() {
    }
    
    /**
     * Constructs a new <code>CharHolder</code> object for the given
     * <code>char</code>.
     * @param initial the <code>char</code> with which to initialize
     *                the <code>value</code> field of the new
     *                <code>CharHolder</code> object
     */
    public CharHolder(char initial) {
	value = initial;
    }

    /**
     * Reads from <code>input</code> and initalizes the value in 
	 * this <code>CharHolder</code> object
     * with the unmarshalled data.
     *
     * @param input the InputStream containing CDR formatted data from the wire
     */
    public void _read(InputStream input) {
	value = input.read_char();
    }

    /**
     * Marshals to <code>output</code> the value in
	 * this <code>CharHolder</code> object.
     *
     * @param output the OutputStream which will contain the CDR formatted data
     */
    public void _write(OutputStream output) {
	output.write_char(value);
    }

    /**
     * Returns the <code>TypeCode</code> object  corresponding
	 * to the value held in 
	 * this <code>CharHolder</code> object.
     *
     * @return    the TypeCode of the value held in 
	 *            this <code>CharHolder</code> object
     */
    public org.omg.CORBA.TypeCode _type() {
	return ORB.init().get_primitive_tc(TCKind.tk_char);
    }
}
