/*
 * @(#)src/classes/sov/org/omg/CORBA/Current.java, orb-api, as131, 20031014 1.5.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 *
 * ===========================================================================
 *
 * Copyright 1997-2000 Sun Microsystems, Inc. All Rights Reserved.
 * ===========================================================================
 */
 
/*
 * @(#)Current.java	1.10 98/09/08
 *
 */

package org.omg.CORBA;

/**
 * An interface that makes it possible to access information
 * associated with a particular thread of execution, such as
 * security information or a transaction identifier.
 * <P>
 * An ORB or CORBA service that needs its own thread-specific
 * state extends the CORBA package's <code>Current</code>.
 * Users of the service can obtain an instance of the appropriate
 * <code>Current</code> interface by invoking
 * <code>ORB.resolve_initial_references</code>.
 * For example, the Security service obtains the <code>Current</code>
 * relevant to it by invoking
 * <PRE>
 *    ORB.resolve_initial_references("SecurityCurrent");
 * </PRE>
 * <P>
 * A CORBA service does not have to use this method of keeping context
 * but may choose to do so.
 * <P>
 * Methods on classes that implement from <code>Current</code> access state
 * associated with the thread in which they are invoked, not state associated
 * with the thread from which the <code>Current</code> was obtained.
 *  Current objects must not be exported to other processes, or externalized
 *  with ORB.object_to_string. If any attempt is made to do so, the offending
 *  operation will raise a MARSHAL system exception.
 * @see <a href="package-summary.html#unimpl"><code>portable</code>
 * package comments for unimplemented features</a>
 */

public interface Current extends CurrentOperations, org.omg.CORBA.Object, org.omg.CORBA.portable.IDLEntity 
{
} // interface Current

