/*
 * @(#)src/classes/sov/org/omg/CORBA/CustomMarshal.java, orb-api, as131, 20031014 1.4.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 * rmi-iiop/src/share/classes/org/omg/CORBA/CustomMarshal.java, rr100, rr100 99/05/27
 *
 * Copyright 1997-2000 Sun Microsystems, Inc. All Rights Reserved.
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 * 
 */

package org.omg.CORBA;

import org.omg.CORBA.DataOutputStream;
import org.omg.CORBA.DataInputStream;

// added javadoc comments						/*ibm@4279*/

/**
 * The <code>CustomMarshal</code> interface is the Java language mapping of the IDL
 * abstract valuetype <code>CORBA::CustomMarshal</code>.  It defines methods
 * that a Java language implementation of an IDL custom valuetype must provide for
 * marshaling and unmarshaling its data.
 * <p>The methods of this interface are called by the ORB during marshaling and
 * unmarshaling of custom valuetypes.  They are not intended to be called by
 * application code.
 * @see DataOutputStream 
 * @see DataInputStream 
 */
public interface CustomMarshal {

    /**
     * Writes the data that needs to be marshaled for this custom valuetype
     * instance to the output stream <code>os</code>, using the methods defined by
     * the {@link DataOutputStream} interface.
     * @param os the putput stream to which the data will be written.
     */
    void marshal(DataOutputStream os);

    /**
     * Reads the data that needs to be unmarshaled for this custom valuetype
     * instance from the input stream <code>is</code>, using the methods defined by
     * the {@link DataInputStream} interface.
     * @param is the input stream from which the data will be read.
     */
    void unmarshal(DataInputStream is);
}
