/*
 * @(#)src/classes/sov/org/omg/CORBA/DataInputStream.java, orb-api, as131, 20031014 1.6.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 * @(#)DataInputStream.java	1.5 99/06/07
 *
 * Copyright 1995-2000 Sun Microsystems, Inc. All Rights Reserved.
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 * 
 */

package org.omg.CORBA;

// added javadoc comments						/*ibm@4279*/

/**
 * The <code>DataInputStream</code> interface is the Java language mapping of the IDL
 * abstract valuetype <code>CORBA::DataInputStream</code>.  It defines methods for
 * unmarshaling the data that makes up an IDL custom valuetype.
 * <p>The methods of this interface are called by implementations of the 
 * {@link CustomMarshal#unmarshal} method.
 *
 * @see DataOutputStream
 * @see CustomMarshal 
 */
public interface DataInputStream extends org.omg.CORBA.portable.ValueBase
{
    /**
     * Reads an IDL <code>any</code> from the stream.
     * @return the unmarshaled data.
     */
    org.omg.CORBA.Any read_any ();

    /**
     * Reads an IDL <code>boolean</code> from the stream.
     * @return the unmarshaled data.
     */
    boolean read_boolean ();

    /**
     * Reads an IDL <code>char</code> from the stream.
     * @return the unmarshaled data.
     */
    char read_char ();

    /**
     * Reads an IDL <code>wchar</code> from the stream.
     * @return the unmarshaled data.
     */
    char read_wchar ();

    /**
     * Reads an IDL <code>octet</code> from the stream.
     * @return the unmarshaled data.
     */
    byte read_octet ();

    /**
     * Reads an IDL <code>short</code> from the stream.
     * @return the unmarshaled data.
     */
    short read_short ();

    /**
     * Reads an IDL <code>unsigned short</code> from the stream.
     * @return the unmarshaled data.
     */
    short read_ushort ();

    /**
     * Reads an IDL <code>long</code> from the stream.
     * @return the unmarshaled data.
     */
    int read_long ();

    /**
     * Reads an IDL <code>unsigned long</code> from the stream.
     * @return the unmarshaled data.
     */
    int read_ulong ();

    /**
     * Reads an IDL <code>long long</code> from the stream.
     * @return the unmarshaled data.
     */
    long read_longlong ();

    /**
     * Reads an IDL <code>unsigned long long</code> from the stream.
     * @return the unmarshaled data.
     */
    long read_ulonglong ();

    /**
     * Reads an IDL <code>float</code> from the stream.
     * @return the unmarshaled data.
     */
    float read_float ();

    /**
     * Reads an IDL <code>double</code> from the stream.
     * @return the unmarshaled data.
     */
    double read_double ();

    // read_longdouble not supported by IDL/Java mapping

    /**
     * Reads an IDL <code>string</code> from the stream.
     * @return the unmarshaled data.
     */
    String read_string ();

    /**
     * Reads an IDL <code>wstring</code> from the stream.
     * @return the unmarshaled data.
     */
    String read_wstring ();

    /**
     * Reads an IDL object reference from the stream.
     * @return a stub for the object reference.
     */
    org.omg.CORBA.Object read_Object ();

    /**
     * Reads an IDL abstract interface type from the stream and returns
     * either a <code>valuetype</code> or a stub, depending on the actual type
     * that was marshaled for the abstract interface.
     * @return the unmarshaled <code>valuetype</code> or stub.
     * @exception org.omg.CORBA.portable.IndirectionException if the abstract
     * interface type's CDR encoding is an indirection to a <code>valuetype</code>
     * that has not already been unmarshaled.
     */
    java.lang.Object read_Abstract ();

    /**
     * Reads an IDL <code>valuetype</code> from the stream.
     * @return the unmarshaled <code>valuetype</code>.
     * @exception org.omg.CORBA.portable.IndirectionException if the <code>valuetype</code>'s
     * CDR encoding is an indirection to a <code>valuetype</code> that has not already been
     * unmarshaled.
     */
    java.io.Serializable read_Value ();

    /**
     * Reads an IDL <code>CORBA::TypeCode</code> from the stream.
     * @return the unmarshaled data.
     */
    org.omg.CORBA.TypeCode read_TypeCode ();

    /**
     * Reads an array of IDL <code>any</code>s from the stream.
     * @param seq the holder object for the array.
     * @param offset the position of the array element to be assigned the
     * first data item read from the stream.
     * @param length the number of data items to be read.
     */
    void read_any_array (org.omg.CORBA.AnySeqHolder seq, int offset, int length);

    /**
     * Reads an array of IDL <code>boolean</code>s from the stream.
     * @param seq the holder object for the array.
     * @param offset the position of the array element to be assigned the
     * first data item read from the stream.
     * @param length the number of data items to be read.
     */
    void read_boolean_array (org.omg.CORBA.BooleanSeqHolder seq, int offset, int length);

    /**
     * Reads an array of IDL <code>char</code>s from the stream.
     * @param seq the holder object for the array.
     * @param offset the position of the array element to be assigned the
     * first data item read from the stream.
     * @param length the number of data items to be read.
     */
    void read_char_array (org.omg.CORBA.CharSeqHolder seq, int offset, int length);

    /**
     * Reads an array of IDL <code>wchar</code>s from the stream.
     * @param seq the holder object for the array.
     * @param offset the position of the array element to be assigned the
     * first data item read from the stream.
     * @param length the number of data items to be read.
     */
    void read_wchar_array (org.omg.CORBA.WCharSeqHolder seq, int offset, int length);

    /**
     * Reads an array of IDL <code>octet</code>s from the stream.
     * @param seq the holder object for the array.
     * @param offset the position of the array element to be assigned the
     * first data item read from the stream.
     * @param length the number of data items to be read.
     */
    void read_octet_array (org.omg.CORBA.OctetSeqHolder seq, int offset, int length);

    /**
     * Reads an array of IDL <code>short</code>s from the stream.
     * @param seq the holder object for the array.
     * @param offset the position of the array element to be assigned the
     * first data item read from the stream.
     * @param length the number of data items to be read.
     */
    void read_short_array (org.omg.CORBA.ShortSeqHolder seq, int offset, int length);

    /**
     * Reads an array of IDL <code>unsigned short</code>s from the stream.
     * @param seq the holder object for the array.
     * @param offset the position of the array element to be assigned the
     * first data item read from the stream.
     * @param length the number of data items to be read.
     */
    void read_ushort_array (org.omg.CORBA.UShortSeqHolder seq, int offset, int length);

    /**
     * Reads an array of IDL <code>long</code>s from the stream.
     * @param seq the holder object for the array.
     * @param offset the position of the array element to be assigned the
     * first data item read from the stream.
     * @param length the number of data items to be read.
     */
    void read_long_array (org.omg.CORBA.LongSeqHolder seq, int offset, int length);

    /**
     * Reads an array of IDL <code>unsigned long</code>s from the stream.
     * @param seq the holder object for the array.
     * @param offset the position of the array element to be assigned the
     * first data item read from the stream.
     * @param length the number of data items to be read.
     */
    void read_ulong_array (org.omg.CORBA.ULongSeqHolder seq, int offset, int length);

    /**
     * Reads an array of IDL <code>long long</code>s from the stream.
     * @param seq the holder object for the array.
     * @param offset the position of the array element to be assigned the
     * first data item read from the stream.
     * @param length the number of data items to be read.
     */
    void read_longlong_array (org.omg.CORBA.LongLongSeqHolder seq, int offset, int length);

    /**
     * Reads an array of IDL <code>unsigned long long</code>s from the stream.
     * @param seq the holder object for the array.
     * @param offset the position of the array element to be assigned the
     * first data item read from the stream.
     * @param length the number of data items to be read.
     */
    void read_ulonglong_array (org.omg.CORBA.ULongLongSeqHolder seq, int offset, int length);

    /**
     * Reads an array of IDL <code>float</code>s from the stream.
     * @param seq the holder object for the array.
     * @param offset the position of the array element to be assigned the
     * first data item read from the stream.
     * @param length the number of data items to be read.
     */
    void read_float_array (org.omg.CORBA.FloatSeqHolder seq, int offset, int length);

    /**
     * Reads an array of IDL <code>double</code>s from the stream.
     * @param seq the holder object for the array.
     * @param offset the position of the array element to be assigned the
     * first data item read from the stream.
     * @param length the number of data items to be read.
     */
    void read_double_array (org.omg.CORBA.DoubleSeqHolder seq, int offset, int length);

} // interface DataInputStream

