/*
 * @(#)src/classes/sov/org/omg/CORBA/DataOutputStream.java, orb-api, as131, 20031014 1.5.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 * @(#)DataOutputStream.java	1.5 99/06/07
 *
 * Copyright 1997-2000 Sun Microsystems, Inc. All Rights Reserved.
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 * 
 */

package org.omg.CORBA;

// added javadoc comments						/*ibm@4279*/

/**
 * The <code>DataOutputStream</code> interface is the Java language mapping of the IDL
 * abstract valuetype <code>CORBA::DataOutputStream</code>.  It defines methods for
 * marshaling the data that makes up an IDL custom valuetype.  The data is marshaled
 * in CDR format.
 * <p>The methods of this interface are called by implementations of the 
 * {@link CustomMarshal#marshal} method, passing the data that needs to be marshaled
 * for the custom valuetype instance.
 *
 * @see DataInputStream
 * @see CustomMarshal 
 */
public interface DataOutputStream extends org.omg.CORBA.portable.ValueBase
{
    /**
     * Writes an IDL <code>any</code> to the stream.
     * @param value the data to be written.
     */
    void write_any (org.omg.CORBA.Any value);

    /**
     * Writes an IDL <code>boolean</code> to the stream.
     * @param value the data to be written.
     */
    void write_boolean (boolean value);

    /**
     * Writes an IDL <code>char</code> to the stream.
     * @param value the data to be written.
     */
    void write_char (char value);

    /**
     * Writes an IDL <code>wchar</code> to the stream.
     * @param value the data to be written.
     */
    void write_wchar (char value);

    /**
     * Writes an IDL <code>octet</code> to the stream.
     * @param value the data to be written.
     */
    void write_octet (byte value);

    /**
     * Writes an IDL <code>short</code> to the stream.
     * @param value the data to be written.
     */
    void write_short (short value);

    /**
     * Writes an IDL <code>unsigned short</code> to the stream.
     * @param value the data to be written.
     */
    void write_ushort (short value);

    /**
     * Writes an IDL <code>long</code> to the stream.
     * @param value the data to be written.
     */
    void write_long (int value);

    /**
     * Writes an IDL <code>unsigned long</code> to the stream.
     * @param value the data to be written.
     */
    void write_ulong (int value);

    /**
     * Writes an IDL <code>long long</code> to the stream.
     * @param value the data to be written.
     */
    void write_longlong (long value);

    /**
     * Writes an IDL <code>unsigned long long</code> to the stream.
     * @param value the data to be written.
     */
    void write_ulonglong (long value);

    /**
     * Writes an IDL <code>float</code> to the stream.
     * @param value the data to be written.
     */
    void write_float (float value);

    /**
     * Writes an IDL <code>double</code> to the stream.
     * @param value the data to be written.
     */
    void write_double (double value);

    // write_longdouble not supported by IDL/Java mapping

    /**
     * Writes an IDL <code>string</code> to the stream.
     * @param value the data to be written.
     */
    void write_string (String value);

    /**
     * Writes an IDL <code>wstring</code> to the stream.
     * @param value the data to be written.
     */
    void write_wstring (String value);

    /**
     * Writes an IDL object reference to the stream.
     * @param value the object to be written.
     */
    void write_Object (org.omg.CORBA.Object value);

    /**
     * Writes an IDL abstract interface type to the stream.
     * @param value the object to be written.
     */
    void write_Abstract (java.lang.Object value);

    /**
     * Writes an IDL <code>valuetype</code> to the stream.
     * @param value the object to be written.
     */
    void write_Value (java.io.Serializable value);

    /**
     * Writes an IDL <code>CORBA::TypeCode</code> to the stream.
     * @param value the data to be written.
     */
    void write_TypeCode (org.omg.CORBA.TypeCode value);

    /**
     * Writes an array of IDL <code>any</code>s to the stream.
     * @param seq the array to be written.
     * @param offset the position of the first array element to be written.
     * @param length the number of array elements to be written.
     */
    void write_any_array (org.omg.CORBA.Any[] seq, int offset, int length);

    /**
     * Writes an array of IDL <code>boolean</code>s to the stream.
     * @param seq the array to be written.
     * @param offset the position of the first array element to be written.
     * @param length the number of array elements to be written.
     */
    void write_boolean_array (boolean[] seq, int offset, int length);

    /**
     * Writes an array of IDL <code>char</code>s to the stream.
     * @param seq the array to be written.
     * @param offset the position of the first array element to be written.
     * @param length the number of array elements to be written.
     */
    void write_char_array (char[] seq, int offset, int length);

    /**
     * Writes an array of IDL <code>wchar</code>s to the stream.
     * @param seq the array to be written.
     * @param offset the position of the first array element to be written.
     * @param length the number of array elements to be written.
     */
    void write_wchar_array (char[] seq, int offset, int length);

    /**
     * Writes an array of IDL <code>octet</code>s to the stream.
     * @param seq the array to be written.
     * @param offset the position of the first array element to be written.
     * @param length the number of array elements to be written.
     */
    void write_octet_array (byte[] seq, int offset, int length);

    /**
     * Writes an array of IDL <code>short</code>s to the stream.
     * @param seq the array to be written.
     * @param offset the position of the first array element to be written.
     * @param length the number of array elements to be written.
     */
    void write_short_array (short[] seq, int offset, int length);

    /**
     * Writes an array of IDL <code>unsigned short</code>s to the stream.
     * @param seq the array to be written.
     * @param offset the position of the first array element to be written.
     * @param length the number of array elements to be written.
     */
    void write_ushort_array (short[] seq, int offset, int length);

    /**
     * Writes an array of IDL <code>long</code>s to the stream.
     * @param seq the array to be written.
     * @param offset the position of the first array element to be written.
     * @param length the number of array elements to be written.
     */
    void write_long_array (int[] seq, int offset, int length);

    /**
     * Writes an array of IDL <code>unsigned long</code>s to the stream.
     * @param seq the array to be written.
     * @param offset the position of the first array element to be written.
     * @param length the number of array elements to be written.
     */
    void write_ulong_array (int[] seq, int offset, int length);

    /**
     * Writes an array of IDL <code>long long</code>s to the stream.
     * @param seq the array to be written.
     * @param offset the position of the first array element to be written.
     * @param length the number of array elements to be written.
     */
    void write_longlong_array (long[] seq, int offset, int length);

    /**
     * Writes an array of IDL <code>unsigned long long</code>s to the stream.
     * @param seq the array to be written.
     * @param offset the position of the first array element to be written.
     * @param length the number of array elements to be written.
     */
    void write_ulonglong_array (long[] seq, int offset, int length);

    /**
     * Writes an array of IDL <code>float</code>s to the stream.
     * @param seq the array to be written.
     * @param offset the position of the first array element to be written.
     * @param length the number of array elements to be written.
     */
    void write_float_array (float[] seq, int offset, int length);

    /**
     * Writes an array of IDL <code>double</code>s to the stream.
     * @param seq the array to be written.
     * @param offset the position of the first array element to be written.
     * @param length the number of array elements to be written.
     */
    void write_double_array (double[] seq, int offset, int length);

} // interface DataOutputStream
