/*
 * @(#)src/classes/sov/org/omg/CORBA/ObjectHelper.java, orb-api, as131, 20031014 1.5.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/* @(#)ObjectHelper.java	1.5 99/06/07 */
/*
 * RMI-IIOP v1.0
 *
 */

package org.omg.CORBA;

// added javadoc comments						/*ibm@4279*/

/**
 * This is the "helper" class for the IDL <code>Object</code> type (a generic CORBA object).
 * It contains static methods that are used to manipulate the <code>Object</code>
 * type in various ways.
 */
abstract public class ObjectHelper
{
    // It is useless to have instances of this class
    public ObjectHelper() { }					/*ibm@7503*/

    private static String  _id = "";

    /**
     * Inserts a CORBA object into an IDL <code>any</code>.
     * @param a the <code>any</code> object.
     * @param that the CORBA object.
     */
    public static void insert (org.omg.CORBA.Any a, org.omg.CORBA.Object that)
    {
	org.omg.CORBA.portable.OutputStream out = a.create_output_stream ();
	a.type (type ());
	write (out, that);
	a.read_value (out.create_input_stream (), type ());
    }

    /**
     * Extracts a CORBA object from an IDL <code>any</code>.
     * @param a the <code>any</code> object.
     * @return the CORBA object.
     */
    public static org.omg.CORBA.Object extract (org.omg.CORBA.Any a)
    {
	return read (a.create_input_stream ());
    }

    private static org.omg.CORBA.TypeCode __typeCode = null;
    /**
     * Returns the <code>TypeCode</code> object for a CORBA object.
     * @return the <code>TypeCode</code> object.
     */
    synchronized public static org.omg.CORBA.TypeCode type ()
    {
	if (__typeCode == null)
	    {
		__typeCode = org.omg.CORBA.ORB.init ().get_primitive_tc (TCKind.tk_objref);
	    }
	return __typeCode;
    }

    /**
     * Returns the RepositoryId for a CORBA object.
     * @return the RepositoryId.
     */
    public static String id ()
    {
	return _id;
    }

    /**
     * Unmarshals a CORBA object from an input stream.
     * @param istream the <code>InputStream</code> containing CDR formatted data.
     * @return a stub for the unmarshaled CORBA object.
     */
    public static org.omg.CORBA.Object read (org.omg.CORBA.portable.InputStream istream)
    {
	return istream.read_Object ();
    }

    /**
     * Marshals a CORBA object to an output stream.
     * @param ostream the <code>OutputStream</code> which will contain the 
     * CDR formatted data.
     * @param value the CORBA object to be marshaled.
     */
    public static void write (org.omg.CORBA.portable.OutputStream ostream, org.omg.CORBA.Object value)
    {
	ostream.write_Object (value);
    }

}
