/*
 * @(#)src/classes/sov/org/omg/CORBA/PolicyError.java, orb-api, as131, 20031014 1.6.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 *
 * ===========================================================================
 *
 * Copyright 1995-2000 Sun Microsystems, Inc. All Rights Reserved.
 * ===========================================================================
 */
 
/*
 * @(#)PolicyError.java	1.6 99/04/22
 *
 */

package org.omg.CORBA;

/**
* An exception carrying one of the following policy error reason codes
* defined in the org.omg.CORBA package: 
* BAD_POLICY, BAD_POLICY_TYPE, BAD_POLICY_VALUE, UNSUPPORTED_POLICY, UNSUPPORTED_POLICY_VALUE
*/

public final class PolicyError extends org.omg.CORBA.UserException {

/** 
 * The reason for the <code>PolicyError</code> exception being thrown.
 * @serial
 */
    public short reason;

    /**
    * Constructs a default <code>PolicyError</code> user exception
    * with no reason code and an empty reason detail message.
    */
    public PolicyError() {
	super();
    }

    /**
    * Constructs a <code>PolicyError</code> user exception
    * initialized with the given reason code and an empty reason detail message.
    * @param __reason the reason code.
    */
    public PolicyError(short __reason) {
	super();
	reason = __reason;
    }

    /**
    * Constructs a <code>PolicyError</code> user exception
    * initialized with the given reason detail message and reason code.
    * @param reason_string the reason detail message.
    * @param __reason the reason code.
    */
    public PolicyError(String reason_string, short __reason) {
	super(reason_string);
	reason = __reason;
    }
}
