/*
 * @(#)src/classes/sov/org/omg/CORBA/ValueBaseHolder.java, orb-api, as131, 20031014 1.4.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 * @(#)ValueBaseHolder.java	1.3 99/06/07
 *
 * Copyright 1995-2000 Sun Microsystems, Inc. All Rights Reserved.
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 */

package org.omg.CORBA;

import org.omg.CORBA.portable.Streamable;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

// added javadoc comments						/*ibm@4279*/

/**
 * A Holder class for an IDL <code>ValueBase</code> type (a value of type
 * <code>java.io.Serializable</code>).  It is usually
 * used to store "out" and "inout" parameters in IDL methods.
 * If an IDL method signature has an IDL <code>ValueBase</code> as an "out"
 * or "inout" parameter, the programmer must pass an instance of
 * <code>ValueBaseHolder</code> as the corresponding
 * parameter in the method invocation; for "inout" parameters, the programmer
 * must also fill the "in" value to be sent to the server.
 * Before the method invocation returns, the ORB will fill in the
 * value corresponding to the "out" value returned from the server.
 * <P>
 * If <code>myValueBaseHolder</code> is an instance of <code>ValueBaseHolder</code>,
 * the value stored in its <code>value</code> field can be accessed with
 * <code>myValueBaseHolder.value</code>.
 */
public final class ValueBaseHolder implements Streamable {

    /**
     * The <code>java.io.Serializable</code> value held by this 
     * <code>ValueBaseHolder</code> object.
     */
    public java.io.Serializable value;

    /**
     * Constructs a new <code>ValueBaseHolder</code> object with its
     * <code>value</code> field initialized to <code>null</code>.
     */
    public ValueBaseHolder() {
    }

    /**
     * Constructs a new <code>ValueBaseHolder</code> object with its
     * <code>value</code> field initialized to the given
     * <code>java.io.Serializable</code>.
     * @param initial the <code>java.io.Serializable</code> with which to initialize
     *                the <code>value</code> field of the newly-created
     *                <code>ValueBaseHolder</code> object.
     */
    public ValueBaseHolder(java.io.Serializable initial) {
	value = initial;
    }

    /**
     * Reads from <code>input</code> and initalizes the value in this
     * <code>ValueBaseHolder</code> object with the unmarshaled data.
     *
     * @param input the <code>InputStream</code> containing CDR formatted data.
     */
    public void _read(InputStream input) {
	value = ((org.omg.CORBA_2_3.portable.InputStream)input).read_value();
    }

    /**
     * Marshals to <code>output</code> the value in this
     * <code>ValueBaseHolder</code> object.
     *
     * @param output the <code>OutputStream</code> which will contain the 
     * CDR formatted data.
     */
    public void _write(OutputStream output) {
	((org.omg.CORBA_2_3.portable.OutputStream)output).write_value(value);
    }

    /**
     * Returns the <code>TypeCode</code> object corresponding to the 
     * value held in this <code>ValueBaseHolder</code> object.
     *
     * @return the <code>TypeCode</code> of the value held in this
     * <code>ValueBaseHolder</code> object.
     */
    public org.omg.CORBA.TypeCode _type() {
	return ORB.init().get_primitive_tc(TCKind.tk_value);
    }

}
