/*
 * @(#)src/classes/sov/org/omg/CORBA/WrongTransaction.java, orb-api, as131, 20031014 1.6.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 *
 * ===========================================================================
 *
 * Copyright 1997-2000 Sun Microsystems, Inc. All Rights Reserved.
 * ===========================================================================
 */
 
/*
 * @(#)WrongTransaction.java	1.14 99/04/22
 *
 */

package org.omg.CORBA;

/**
 * The CORBA <code>WrongTransaction</code> user-defined exception.
 * This exception is thrown only by the methods
 * <code>Request.get_response</code>
 * and <code>ORB.get_next_response</code> when they are invoked
 * from a transaction scope that is different from the one in
 * which the client originally sent the request.
 * See the OMG Transaction Service Specification for details.
 *
 * @see <A href="../../../../guide/idl/jidlExceptions.html">documentation on
 * Java&nbsp;IDL exceptions</A>
 */

public class WrongTransaction extends UserException {
    /**
    * Constructs a WrongTransaction object with an empty detail message.
    */
    public WrongTransaction() {
	super();
    }

    /**
    * Constructs a WrongTransaction object with the given detail message.
    * @param reason The detail message explaining what caused this exception to be thrown.
    */
    public WrongTransaction(String reason) {
	super(reason);
    }
}
