/*
 * @(#)src/classes/sov/org/omg/CORBA/portable/BoxedValueHelper.java, orb-api, as131, 20031014 1.4.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/* @(#)BoxedValueHelper.java	1.4 99/06/07 */
/*
 * RMI-IIOP v1.0
 *
 */

package org.omg.CORBA.portable;
import java.io.Serializable;

// added javadoc comments						/*ibm@4279*/

/**
 * The <code>BoxedValueHelper</code> interface is implemented by all generated 
 * concrete helper classes for boxed valuetypes.
 */
public interface BoxedValueHelper {

    /**
     * Reads an instance of a boxed valuetype from the input stream
     * <code>is</code>.
     * @param is the input stream from which to read the data. 
     * @return the boxed valuetype that was read from the stream.
     */
    Serializable read_value(InputStream is);

    /**
     * Writes an instance of a boxed valuetype to the output stream
     * <code>os</code>.
     * @param os the output stream to which to write the data. 
     * @param value the boxed valuetype to be written to the stream.
     */
    void write_value(OutputStream os, Serializable value);

    /**
     * Returns the RepositoryId of the boxed valuetype.
     * @return the RepositoryId of the boxed valuetype.
     */
    String get_id();
}
