/*
 * @(#)src/classes/sov/org/omg/CORBA/portable/IndirectionException.java, orb-api, as131, 20031014 1.4.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/* @(#)IndirectionException.java	1.6 99/06/07 */
/*
 * RMI-IIOP v1.0
 *
 */

package org.omg.CORBA.portable;

import org.omg.CORBA.SystemException;

// added javadoc comments						/*ibm@4279*/

/**
 * This exception is thrown when an 
 * {@link org.omg.CORBA_2_3.portable.InputStream} is called to 
 * unmarshal a value type whose CDR encoding is an indirection to a
 * value type that has not already been unmarshaled by the stream.
 * <p>This exception may be caused by a CDR encoding error in a GIOP
 * message received by the ORB, or it may occur when a 
 * {@link javax.rmi.CORBA.ValueHandler} calls an
 * <code>InputStream</code> to unmarshal a
 * recursive reference to an RMI value that is currently
 * being unmarshaled by the <code>ValueHandler</code>.
 * <p>In the latter case, the exception occurs because a higher-level call
 * from the <code>InputStream</code> to the <code>ValueHandler</code> has not
 * yet returned, and so the <code>InputStream</code>'s indirection table
 * does not yet contain an entry for the stream offset
 * specified by the CDR indirection tag for the recursive reference.  The
 * <code>ValueHandler</code> must use the stream offset in the
 * <code>IndirectionException</code> to resolve the
 * recursive reference before returning from the higher-level call.
 */
public class IndirectionException extends SystemException {

    /**
     * The stream offset of the object that could not be returned 
     * because it has not already been unmarshaled by the stream.
     * @serial
     */
    public int offset;

    /**
     * Constructs an <code>IndirectionException</code> object and initializes
     * its <code>offset</code> field to the value of the <code>offset</code>
     * parameter.
     * @param offset the stream offset of the object that could not be returned 
     * because it has not already been unmarshaled by the stream.
     */
    public IndirectionException(int offset){
	super("", 0, org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);
	this.offset = offset;
    }
}
