/*
 * @(#)src/classes/sov/org/omg/CORBA/portable/UnknownException.java, orb-api, as131, 20031014 1.4.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/* @(#)UnknownException.java	1.4 99/06/07 */
/*
 * RMI-IIOP v1.0
 *
 */

package org.omg.CORBA.portable;

// added javadoc comments						/*ibm@4279*/

/**
 * This exception is used to pass unknown exceptions from ties to the ORB
 * and from the ORB to stubs.  It provides a Java language representation of a
 * CORBA::UNKNOWN system exception that has an <code>UnknownExceptionInfo</code>
 * service context.
 */
public class UnknownException extends org.omg.CORBA.SystemException {

    /**
     * The exception originally thrown by the server method.
     * @serial
     */
    public Throwable originalEx;

    /**
     * Constructs an <code>UnknownException</code> object and initializes
     * its <code>originalEx</code> field to the value of the <code>ex</code>
     * parameter.
     * @param ex the exception originally thrown by the server method.
     */
    public UnknownException(Throwable ex) {
        super("", 0, org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);
        originalEx = ex;
    }
}
