/*
 * @(#)src/classes/sov/org/omg/CORBA/portable/ValueFactory.java, orb-api, as131, 20031014 1.4.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM Java(tm)2 SDK, Standard Edition, v 1.3.1
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/* @(#)ValueFactory.java	1.4 99/06/07 */
/*
 * RMI-IIOP v1.0
 *
 */

package org.omg.CORBA.portable;
import java.io.Serializable;

// added javadoc comments						/*ibm@4279*/

/**
 * The <code>ValueFactory</code> interface is the Java language mapping of the IDL
 * native type <code>CORBA::ValueFactory</code>.
 * <p>The <code>read_value</code> method is called
 * by the ORB runtime while in the process of unmarshaling an IDL valuetype.
 * A user implements this method as part of implementing a type-specific
 * value factory.  The implementation must call 
 * {@link org.omg.CORBA_2_3.portable.InputStream#read_value(java.io.Serializable)}
 * with an uninitialized valuetype to use for unmarshaling, and return
 * the result from this call.
 * For example, a user could implement the <code>read_value</code> method
 * as follows:
 * <pre>
 * public java.io.Serializable read_value(org.omg.CORBA_2_3.portable.InputStream is)
 * {		    
 *     return is.read_value(new MyValueImpl());
 * }
 * </pre>
 */
public interface ValueFactory {

    /**
     * Unmarshals the data for an IDL valuetype.
     * This method is called by the ORB runtime while in the process
     * of unmarshaling an IDL valuetype.  A user implements this method
     * as part of implementing a type-specific value factory.
     * @return the unmarshaled valuetype.
     */
    Serializable read_value(org.omg.CORBA_2_3.portable.InputStream is);
}
