/*
 * @(#)src/classes/sov/org/omg/CORBA/portable/ValueInputStream.java, orb, orb131, 20031017 1.2.1.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.3.1
 * (C) Copyright IBM Corp. 2002, 2003. All Rights Reserved
 * ===========================================================================
 */

/*
*
* Change activity:
*
* Reason Date   Origin   Description
* ------ ----   ------   ----------------------------------------------------
*  57725 030127 baldwint Added to resolve oMG Java-to-IDL issue 3151
*
* ===========================================================================
* Module Information:
*
* DESCRIPTION: Callback interface from the valuehandler to the orb stream
*
* NOTE: This file should be deleted as soon as the corresponding interface
*       is available as part of the base Sun JDK.
* ===========================================================================
*/

package org.omg.CORBA.portable;

/**
* This interface defines methods that allow the deserialization of custom-
* marshaled RMI/IDL objects from an ORB GIOP data stream.  This interface
* is used to support format version 2 of the custom-marshal data stream.
*/
public interface ValueInputStream {
    /**
     * Read a valuetype header for a nested custom valuetype enclosure
     * and increment the valuetype nesting depth.
     */
    void start_value();

    /**
     * Skip any remaining custom-marhsaled data, read the end tag for a
     * nested custom valuetype and decrement the valuetype nesting depth.
     */
    void end_value();
}
