/*
 * @(#)src/classes/sov/org/omg/PortableServer/Servant.java, orb-api, orb131, 20031017 1.4.3.5
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4
 * (C) Copyright IBM Corp. 2002. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2002 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */

/*
*
* Change activity:
*
* Reason Date   Origin Description
* ------ ----   ------ ----------------------------------------------------
*  40794 020204 hdtjb  Add IBM module header; Sun original version 1.14
*  61836 030606 dalton Visibroker incompatibility after POA backport
*  62646 030805 ktsui  IONA compatibility:new method in PortableServer::Servant
*  64211 030917 schandna method _get_interface added for bkwrd compatibility
*
* ===========================================================================
* Module Information:
*
* DESCRIPTION: POA Support
* ===========================================================================
*/


package org.omg.PortableServer;

import org.omg.CORBA.CompletionStatus;                        /*ibm@61836*/
import org.omg.CORBA.ORB;

import org.omg.PortableServer.portable.Delegate;

import sun.security.action.GetPropertyAction;                 /*ibm@61836*/

import java.lang.reflect.Method;                              /*ibm@62646*/
import java.security.AccessController;                        /*ibm@61836*/

/**
 * Defines the native <code>Servant</code> type. In Java, the
 * <code>Servant</code> type is mapped to the Java
 * <code>org.omg.PortableServer.Servant</code> class.
 * It serves as the base class for all POA servant
 * implementations and provides a number of methods that may
 * be invoked by the application programmer, as well as methods
 * which are invoked by the POA itself and may be overridden by
 * the user to control aspects of servant behavior.
 * Based on IDL to Java spec. (CORBA V2.3.1) ptc/00-01-08.pdf.
 */

abstract public class Servant {

    private transient Delegate _delegate = null;
    
    /*ibm@61836 start */
    /* It is necessary to identify when this class may be used by a
     * non-compliant Visibroker ORB e.g a VB 4.5.x or 5.0 ORB.
     * This property controls:-
     * 1. the exception thrown by _get_delegate when delegate is null
     *    see defect 61836
     * Note: I considered using the presence of an Inprise ValueHandler,
     * rather than adding a new Property, to set this field but that
     * could cause problems if/when Inprise fix these problems in a 
     * future release, depending upon how they change their POAImpl code.
     */
    private static boolean isOldVisibrokerPOA = false;
    static {
        String param = (String)AccessController.doPrivileged(
            new GetPropertyAction("com.ibm.CORBA.POACompatibilityMode"));
        if(param != null && param.equals("true"))
            isOldVisibrokerPOA = true;
    }
    /* end ibm@61836*/
    
    /**
     * Gets the ORB vendor-specific implementation of
     * <code>PortableServer::Servant</code>.
     * @return <code>_delegate</code> the ORB vendor-specific
     * implementation o@throwf <code>PortableServer::Servant</code>.
     */
    final public Delegate _get_delegate() {
        if (_delegate == null) {
            /*ibm@61836 start */
            // Need to throw an exception when _get_delegate
            // is called but the Servant has not been activated. 
            String text = 
                "The Servant has not been associated with an ORBinstance";
            
            if (isOldVisibrokerPOA) 
                // The POA implementation in the Visibroker 4.5.x and, at
                // least the early, 5.0.x ORB releases relies on an 
                // OBJ_ADAPTER exception being thrown.
                // The minor code is set for the IBM ORB to be able to
                // identify this exception.
                throw new org.omg.CORBA.OBJ_ADAPTER(text,
                    com.ibm.rmi.util.MinorCodes.BAD_INV_ORDER, 
                    CompletionStatus.COMPLETED_NO);
            else
                // The spec, at least since OMG issue 2514, mandates a
                // BAD_INV_ORDER exception.    
                throw new org.omg.CORBA.BAD_INV_ORDER(text);
        }
        /* end ibm@61836*/
        return _delegate;
    }

    /**
     * Supports the Java ORB portability
     * interfaces by providing a method for classes that support
     * ORB portability through delegation to set their delegate.
     * @param <code>delegate</code> ORB vendor-specific implementation of
     *                 the <code>PortableServer::Servant</code>.
     */
    /*ibm@61074 making _set_delegate non-final*/
    public void _set_delegate(Delegate delegate) {
        _delegate = delegate;
    }

    /**
     * Allows the servant to obtain the object reference for
     * the target CORBA object it is incarnating for that request.
     * @return <code>this_object</code> <code>Object</code> reference
     * associated with the request.
     */
    final public org.omg.CORBA.Object _this_object() {
        return _get_delegate().this_object(this);
    }

    /**
     * Allows the servant to obtain the object reference for
     * the target CORBA Object it is incarnating for that request.
     * @param <code>orb</code> ORB with which the servant is associated.
     * @return <code>_this_object</code> reference associated with the request.
     */
    final public org.omg.CORBA.Object _this_object(ORB orb) {
        try {
            ((org.omg.CORBA_2_3.ORB)orb).set_delegate(this);
        }
        catch(ClassCastException e) {
            throw
                new
                org.omg.CORBA.BAD_PARAM
                ("POA Servant requires an instance of org.omg.CORBA_2_3.ORB");
        }
        return _this_object();
    }

    /**
     * Returns the instance of the ORB
     * currently associated with the <code>Servant</code> (convenience method).
     * @return <code>orb</code> the instance of the ORB currently
     * associated with the <code>Servant</code>.
     */
    final public ORB _orb() {
        return _get_delegate().orb(this);
    }

    /**
     * ibm@62646 begins
     * Sets the instance of the ORB to be associated with 
     * the <code>Servant</code>.
     * @return void
     */
    public void _orb(ORB orb) {
        try {
            Delegate delegate = _get_delegate();
            Class delegateClass = delegate.getClass();
            Class parameters[] = new Class[1];
            parameters[0] = ORB.class; 
            Method orbMethod = delegateClass.getMethod("orb", parameters);
            Object[] args = new Object[1];
            args[0] = (Object) orb;
            orbMethod.invoke(delegate, args);
        } catch (Exception e) {
            throw new org.omg.CORBA.BAD_OPERATION (e.toString(),
			    com.ibm.rmi.util.MinorCodes.BAD_OPERATION_SET_ORB,
                            org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);
        }
    }
    // ibm@62646 ends

    /**
     * Allows easy execution of common methods, equivalent to
     * <code>PortableServer::Current:get_POA</code>.
     * @return <code>poa</code> POA associated with the servant.
     */
    final public POA _poa() {
        return _get_delegate().poa(this);
    }

    /**
     * Allows easy execution of
     * common methods, equivalent
     * to calling <code>PortableServer::Current::get_object_id</code>.
     * @return <code>object_id</code> the <code>Object</code> ID associated
     * with this servant.
     */
    final public byte[] _object_id() {
        return _get_delegate().object_id(this);
    }

    /**
     * Returns the
     * root POA from the ORB instance associated with the servant.
     * Subclasses may override this method to return a different POA.
     * @return <code>default_POA</code> the POA associated with the
     * <code>Servant</code>.
     */
    public POA _default_POA() {
        return _get_delegate().default_POA(this);
    }

    /**
     * Checks to see if the specified <code>repository_id</code> is present
     * on the list returned by <code>_all_interfaces()</code> or is the
     * <code>repository_id</code> for the generic CORBA Object.
     * @param <code>repository_id</code> the <code>repository_id</code>
     *		to be checked in the repository list or against the id
     *		of generic CORBA objects.
     * @return <code>is_a</code> boolean indicating whether the specified
     *		<code>repository_id</code> is
     *         in the repository list or is same as a generic CORBA
     *         object.
     */
    public boolean _is_a(String repository_id) {
        return _get_delegate().is_a(this, repository_id);
    }

    /**
     * Checks for the existence of an
     * <code>Object</code>.
     * The <code>Servant</code> provides a default implementation of
     * <code>_non_existent()</code> that can be overridden by derived servants.
     * @return <code>non_existent</code> <code>true</code> if that object does
     *		 not exist,  <code>false</code> otherwise.
     */
    public boolean _non_existent() {
        return _get_delegate().non_existent(this);
    }

    // Ken and Simon will ask about editorial changes
    // needed in IDL to Java mapping to the following
    // signature.
    /**
     * Returns an object in the Interface Repository
     * which provides type information that may be useful to a program.
     * <code>Servant</code> provides a default implementation of
     * <code>_get_interface()</code>
     * that can be overridden by derived servants if the default
     * behavior is not adequate.
     * @return <code>get_interface</code> type information that corresponds to this servant.
     */
    /*
    public org.omg.CORBA.Object _get_interface() {
        return _get_delegate().get_interface(this);
    }
    */
    
    /* start ibm@64211
     * This method has to be added again for backward compatibility reasons
     * This is required for external orbs which use this method and want to
     * run on ibm jdk 131, this method will not be added into 141
     */

    public org.omg.CORBA.InterfaceDef _get_interface()
    {
        org.omg.PortableServer.portable.Delegate delegate = _get_delegate();
        try {
            // If the ORB's delegate class does not implement
            // "InterfaceDef get_interface(..)", this will throw
            // an AbstractMethodError.
            return delegate.get_interface(this);
        } catch( Exception ex ) {
            throw new org.omg.CORBA.NO_IMPLEMENT();
        }
    }

    /* end ibm@64211*/

    // _get_interface_def() replaces the _get_interface() method

    /**
     * Returns an <code>InterfaceDef</code> object as a
     * <code>CORBA::Object</code> that defines the runtime type of the
     * <code>CORBA::Object</code> implemented by the <code>Servant</code>.
     * The invoker of <code>_get_interface_def</code>
     * must narrow the result to an <code>InterfaceDef</code> in order
     * to use it.
     * <P>This default implementation of <code>_get_interface_def()</code>
     * can be overridden
     * by derived servants if the default behavior is not adequate.
     * As defined in the CORBA 2.3.1 specification, section 11.3.1, the
     * default behavior of <code>_get_interface_def()</code> is to use
     * the most derived
     * interface of a static servant or the most derived interface retrieved
     * from a dynamic servant to obtain the <code>InterfaceDef</code>.
     * This behavior must
     * be supported by the <code>Delegate</code> that implements the
     * <code>Servant</code>.
     * @return <code>get_interface_def</code> an <code>InterfaceDef</code>
     * object as a
     * <code>CORBA::Object</code> that defines the runtime type of the
     * <code>CORBA::Object</code> implemented by the <code>Servant</code>.
     */
    public org.omg.CORBA.Object _get_interface_def()
    {
        // First try to call the delegate implementation class's
        // "Object get_interface_def(..)" method (will work for ORBs
        // whose delegates implement this method).
        // Else call the delegate implementation class's
        // "InterfaceDef get_interface(..)" method using reflection
        // (will work for ORBs that were built using an older version
        // of the Delegate interface with a get_interface method
        // but not a get_interface_def method).

        org.omg.PortableServer.portable.Delegate delegate = _get_delegate();
        try {
            // If the ORB's delegate class does not implement
            // "Object get_interface_def(..)", this will throw
            // an AbstractMethodError.
            return delegate.get_interface_def(this);
        } catch( AbstractMethodError aex ) {
            // Call "InterfaceDef get_interface(..)" method using reflection.
            try {
                Class[] argc = { org.omg.PortableServer.Servant.class };
                java.lang.reflect.Method meth =
                     delegate.getClass().getMethod("get_interface", argc);
                Object[] argx = { this };
                return (org.omg.CORBA.Object)meth.invoke(delegate, argx);
            } catch( java.lang.reflect.InvocationTargetException exs ) {
                Throwable t = exs.getTargetException();
                if (t instanceof Error) {
                    throw (Error) t;
                } else if (t instanceof RuntimeException) {
                    throw (RuntimeException) t;
                } else {
                    throw new org.omg.CORBA.NO_IMPLEMENT();
                }
            } catch( RuntimeException rex ) {
                throw rex;
            } catch( Exception exr ) {
                throw new org.omg.CORBA.NO_IMPLEMENT();
            }
        }
    }

    // methods for which the user must provide an
    // implementation
    /**
     * Used by the ORB to obtain complete type
     * information from the servant.
     * @param <code>poa</code> POA with which the servant is associated.
     * @param <code>objectId</code> is the id corresponding to the object
     *         associated with this servant.
     * @return list of type information for the object.
     */
    abstract public String[] _all_interfaces( POA poa, byte[] objectId);
}
