@echo off
rem #------------------------------------------------------------------------------
rem #
rem # Filename: dsnistart.bat
rem #
rem # Description: This Bat file is invoked from DSNI service to launch DSNI java application
rem #
rem # Change History:
rem #
rem #  Modifier            Date                Change ID
rem # ------------------------------------------------------------------------------
rem #  Viorel Ciurea          06/18/2004
rem #  Initial creation
rem # Gheorghe Stan       08/26/2004
rem # Classpath correction
rem #  Amy Therrien           08/24/2004      110882
rem #  Check into CMVC
rem #  Amy Therrien           11/05/2004      119575
rem #  Correct class path to correct relative position
rem #  Amy Therrien           11/08/2004      120300
rem #  Create log directories if they do not exist already
rem #  Brian Ashmore          11/11/2004      119572
rem #  Update classpath to include new JAR
rem #  Joseph Gimness         02/12/2004	  121897
rem #  Update for separate DS6000 / DS8000 startup
rem #  Viorel Ciurea          15-Jan-2005
rem #  Update for support DS6000 Full/Offline mode startup
rem #  Ezequiel Cervantes     30-Mar-2005     138453
rem #  Update for SMC lic version
rem #  Ezequiel Cervantes     20-Jun-2005     152974
rem #  Add -Xrs option to the startup. 
rem #  Yun Yuan               04-Dec-2008     224147
rem #    Remove ibmjsse.jar from classpath
rem #-----------------------------------------------------------------------------

if X%USERNAME%==X goto et1
echo %~0|find "\.\.\%~nx0" >NUL 2>NUL
if %errorlevel% EQU 0 goto et1
echo This script can be launched only by the service. >&2
echo If you want to start DSNI server, you must use startdsnisrv.bat instead. >&2
exit /B 4
:et1

@setlocal
set JAVA_HOME=%~dp0..\java\jre\bin
cd /D %~dp0..

mkdir logs\offline
mkdir logs\server

REM Start of modifications for support DS6000 Full/Offline mode startup
REM Look for the etc\DS6000Mode.properties file
findstr /I /R /C:"^ *DS6000Mode=offline *$" etc\DS6000Mode.properties >NUL 2>NUL
if %ERRORLEVEL% EQU 0 goto ds8000_ds6000_offline
findstr /I /R /C:"^ *DS6000Mode=full *$" etc\DS6000Mode.properties >NUL 2>NUL
if %ERRORLEVEL% EQU 0 goto ds6000_full
REM The etc\DS6000Mode.properties file not found, look for the DS6000 key in VPD
findstr /B /C:"ibmdsstoragemanager6000|" %WINDIR%\vpd.properties >NUL 2>NUL
if %ERRORLEVEL% EQU 0 goto ds6000_full
:ds8000_ds6000_offline
    REM The invocation for DS8000 or DS6000 Ofline mode
    "%JAVA_HOME%\java" -Xrs -classpath lib\db2j.jar;lib\ESSNIServer.jar;lib\rmcapi.jar;lib\logger.jar;lib\hwmcaapi.jar;lib -Dcom.ibm.storage.ess.ni.licversion=etc\SEA.README -Dcom.ibm.storage.ess.ni.agent.properties=NIOfflineAgent.properties -Dcom.ibm.storage.ess.ni.logging=etc\niExternalServerLogging.properties -Dcom.ibm.storage.ess.ni.olc.logging=etc\niExternalOfflineLogging.properties -DRoutingTableFileProperty=etc\MessageRouterRoutingInformation.txt -Ddb2j.system.home=etc\db2j_system\ -Xms128M -Xmx256M  -Ddb2j.storage.pageSize=8192 -Ddb2j.storage.pageCacheSize=160 com.ibm.storage.ess.ni.server.NIESSNIServer 
    goto done
:ds6000_full
    REM The invocation for DS6000 Full mode
    "%JAVA_HOME%\java" -Xrs -classpath lib\db2j.jar;lib\ESSNIServer.jar;lib\rmcapi.jar;lib\logger.jar;lib\hwmcaapi.jar;lib -Dcom.ibm.storage.ess.ni.licversion=etc\SEA.README -Dcom.ibm.storage.ess.ni.agent.properties=NIExternalAgent.properties -Dcom.ibm.storage.ess.ni.logging=etc\niExternalServerLogging.properties -Dcom.ibm.storage.ess.ni.olc.logging=etc\niExternalOfflineLogging.properties -DRoutingTableFileProperty=etc\MessageRouterRoutingInformation.txt -Ddb2j.system.home=etc\db2j_system\ -Xms128M -Xmx256M  -Ddb2j.storage.pageSize=8192 -Ddb2j.storage.pageCacheSize=160 com.ibm.storage.ess.ni.server.NIESSNIServer 
:done
REM End of modifications for support DS6000 Full/Offline mode startup

@endlocal




