#!/bin/ksh
#------------------------------------------------------------------------------
#
# Filename: securityRecoveryUtility.sh
#
# Description: 	This script file is invoked to run the SecurityRecoveryUtility, which is a
#		stand alone application that is used in install and emergency situations for
#		essni security.
#
# Change History:
#
#  Modifier            Date             Change ID
# ------------------------------------------------------------------------------
#  Matthew Ward         08/27/2004	106973
#  	Initial creation		   
#  Matthew Ward		11/04/2004	114997
#	Make corrections to java args
#  Matthew Ward         05/03/2005      148392
#       Return value from java process
#-----------------------------------------------------------------------------

JAVA_HOME=/opt/IBMJava/jre
LOG_PROPERTY_FILE=/opt/essni/etc/niServerLogging.properties
SECURTIY_UTILITY=com.ibm.storage.ess.ni.security.SecurityRecoveryUtility

# Run the recovery utility java class with the command line arguments
$JAVA_HOME/bin/java -cp ../lib/ESSNIServer.jar:/opt/essni/lib/logger.jar:/opt/essni/lib/db2j.jar -Ddb2j.system.home=../db2j_system/ -Dcom.ibm.storage.ess.ni.logging=$LOG_PROPERTY_FILE $SECURTIY_UTILITY "$@"

RC=$?

if [[ $RC -eq 0 ]]; then
	echo "securityRecoveryUtility.sh: Success"
else
	echo "securityRecoveryUtility.sh: Failed"
fi


exit $RC


