#!/bin/ksh
#------------------------------------------------------------------------------
#
# Filename: securityRecoveryUtilityLinux.sh
#
# Description: 	This script file is invoked to run the SecurityRecoveryUtility, which is a
#		stand alone application that is used in install and emergency situations for
#		essni security.
#
# Change History:
#
#  Modifier            Date             Change ID
# ------------------------------------------------------------------------------
#  Rick Martinez		05/10/2006		172694
#-----------------------------------------------------------------------------

JAVA_HOME=/opt/IBMJava2-142/jre
LOG_PROPERTY_FILE=/opt/IBM/DSNIServer/etc/niServerLogging.properties
SECURTIY_UTILITY=com.ibm.storage.ess.ni.security.SecurityRecoveryUtility

# Run the recovery utility java class with the command line arguments
$JAVA_HOME/bin/java -cp /opt/IBM/DSNIServer/lib/ESSNIServer.jar:/opt/IBM/DSNIServer/lib/logger.jar:/opt/IBM/DSNIServer/lib/db2j.jar -Ddb2j.system.home=/opt/IBM/DSNIServer/db2j_system/ -Dcom.ibm.storage.ess.ni.logging=$LOG_PROPERTY_FILE $SECURTIY_UTILITY "$@"

RC=$?

if [[ $RC -eq 0 ]]; then
	echo "securityRecoveryUtilityLinux.sh: Success"
else
	echo "securityRecoveryUtilityLinux.sh: Failed"
fi


exit $RC


