@REM Copyright IBM Corp. 2001
@REM Configuration Based Server Launcher

@REM Launch Arguments:
@REM
@REM cellName
@REM nodeName
@REM serverName

@setlocal
@echo off

@REM Bootstrap values ...

call "%~dp0setupCmdLine.bat"

@REM CONSOLE_ENCODING controls the output encoding used for stdout/stderr
@REM    console - encoding is correct for a console window
@REM    file    - encoding is the default file encoding for the system
@REM    <other> - the specified encoding is used.  e.g. Cp1252, Cp850, SJIS
@REM SET CONSOLE_ENCODING=-Dws.output.encoding=console

@REM Debugging defaults ...

SET DEFAULT_OLT_HOST=localhost
SET DEFAULT_OLT_PORT=2102
SET DEFAULT_JDWP_PORT=7777

@REM Setup the initial java invocation;

SET PATH="%WAS_HOME%/bin;%JAVA_HOME%/bin;%JAVA_HOME%/jre/bin;%PATH%"

chdir "%WAS_HOME%\bin"
rem set DEBUG=-Xdebug -Xnoagent -Xrunjdwp:transport=dt_socket,server=y,address=7777

@REM The server root ('server.root') is only used here until we can get it out of the code. It should not be used in 5.0.

"%JAVA_HOME%\bin\java" %DEBUG% "-Xbootclasspath/p:%WAS_BOOTCLASSPATH%" %CONSOLE_ENCODING% -classpath "%WAS_CLASSPATH%" -Xms64m -Xmx256m -Djava.security.auth.login.config="%WAS_HOME%/properties/wsjaas.conf" -Djava.security.policy="%WAS_HOME%/properties/server.policy" -DenableJava2Security=true -Dws.ext.dirs="%WAS_EXT_DIRS%" -Dserver.root="%WAS_HOME%" -Dcom.ibm.itp.location="%ITP_LOC%" com.ibm.ws.bootstrap.WSLauncher com.ibm.ws.webcontainer.jsp.compiler.ibmtools.JspBatchCompiler "%CONFIG_ROOT%" "-cell.name" "%WAS_CELL%" "-node.name" "%WAS_NODE%" %*


@endlocal
