@echo off
@rem IBM Confidential OCO Source Material
@rem 5630-A36 (C) COPYRIGHT International Business Machines Corp. 1997, 2003
@rem The source code for this program is not published or otherwise divested
@rem of its trade secrets, irrespective of what has been deposited with the
@rem U.S. Copyright Office.

@rem This script, depending on the parameters, can update the following:
@rem 1. Server's SOAP port
@rem 2. Server's bootstrap port
@rem 3. WsAdmin port 
@rem 4. 2 Server HTTP Transports
@rem 5. Remove the Administrative HTTP Transports & vHost
@rem Usage:
@rem UpdateExpressMultiPorts program_options
@rem   Where program_options can be:
@rem   -h[elp]
@rem   -?
@rem   -usage
@rem   -soap soap_and_wsadmin_port_value
@rem   -boot[strap] bootstrap_port_value
@rem   -http http_port_value
@rem   -https https_port_value
@rem   -remove[adminports] 

@setlocal

set prgname=%~n0
set prgdir=%~dp0

if "%1" == "" goto displayusage 

set PORT_SOAP=0
set PORT_BOOT=0
set PORT_HTTP=0
set PORT_HTTPS=0
set REMOVE_ADM=0

:parseparams

if "%1" == "" goto executeCommand

set OPTM=%~1
set OPTM=%OPTM:/=-%

rem Check for options -usage, -?, -h[elp]
if /I "%OPTM%" == "-usage" goto displayusage
if /I "%OPTM%" == "-?" goto displayusage
echo %OPTM% | findstr /I /B /C:"-h" >NUL 2>NUL
if %errorlevel% NEQ 0 goto nohelp
echo -help | findstr /I /B /C:"%OPTM%" >NUL 2>NUL
if %errorlevel% EQU 0 goto displayusage
:nohelp

rem Check for option -soap
if /I "%OPTM%" == "-soap" set PORT_SOAP=%~2 & goto checkParam

rem Check for option -boot[strap]
echo %OPTM% | findstr /I /B /C:"-boot" >NUL 2>NUL
if %errorlevel% NEQ 0 goto noboot
echo -bootstrap | findstr /I /B /C:"%OPTM%" >NUL 2>NUL
if %errorlevel% EQU 0 set PORT_BOOT=%~2 & goto checkParam
:noboot

rem Check for option -http
if /I "%OPTM%" == "-http" set PORT_HTTP=%~2 & goto checkParam

rem Check for option -https
if /I "%OPTM%" == "-https" set PORT_HTTPS=%~2 & goto checkParam

rem Check for option -remove[adminports]
echo %OPTM% | findstr /I /B /C:"-remove" >NUL 2>NUL
if %errorlevel% NEQ 0 goto noremove
echo -removeadminports | findstr /I /B /C:"%OPTM%" >NUL 2>NUL
if %errorlevel% EQU 0 set REMOVE_ADM=1 & shift & goto parseparams
:noremove

echo Invalid option %1

:displayusage
echo.
echo Usage:
echo %prgname% program_options
echo   Where program_options can be:
echo   -h[elp]
echo   -?
echo   -usage
echo   -soap soap_and_wsadmin_port_value
echo   -boot[strap] bootstrap_port_value
echo   -http http_port_value
echo   -https https_port_value
echo   -remove[adminports]
echo.
goto end

:checkParam
set /A TEST_PORT=0
set /A TEST_PORT=%2 >NUL 2>NUL
if not %TEST_PORT% GTR 0 goto badPort
shift
shift
goto parseparams

:badPort
echo Bad port specification: %1 %2
goto displayusage

:executeCommand

if %PORT_SOAP% EQU 0 goto et1e
call "%prgdir%UpdateExpressPorts.bat" -portType soap -portName SOAP_CONNECTOR_ADDRESS -portValue %PORT_SOAP%
if %errorlevel% EQU 0 goto et1g
echo Failed to set server SOAP port to %PORT_SOAP%
goto end
:et1g
echo Server SOAP port successfully set to %PORT_SOAP%
:et1e

if %PORT_BOOT% EQU 0 goto et2e
call "%prgdir%UpdateExpressPorts.bat" -portType bootstrap -portName BOOTSTRAP_ADDRESS -portValue %PORT_BOOT%
if %errorlevel% EQU 0 goto et2g
echo Failed to set server bootstrap port to %PORT_BOOT%
goto end
:et2g
echo Server bootstrap port successfully set to %PORT_BOOT%
:et2e

if %PORT_SOAP% EQU 0 goto et3e
call "%prgdir%UpdateExpressPorts.bat" -portType wsadmin -portConnType soap -portValue %PORT_SOAP%
if %errorlevel% EQU 0 goto et3g
echo Failed to set WsAdmin port to %PORT_SOAP%
goto end
:et3g
echo WsAdmin port successfully set to %PORT_SOAP%
:et3e

if %PORT_HTTP% EQU 0 goto et4e
call "%prgdir%UpdateExpressPorts.bat" -portType http -server server1 -portName HTTPTransport_1 -vhostAlias HostAlias_1 -portValue %PORT_HTTP%
if %errorlevel% EQU 0 goto et4g
echo Failed to set server HTTP port to %PORT_HTTP%
goto end
:et4g
echo Server HTTP port successfully set to %PORT_HTTP%
:et4e

if %PORT_HTTPS% EQU 0 goto et5e
call "%prgdir%UpdateExpressPorts.bat" -portType http -server server1 -portName HTTPTransport_2 -vhostAlias HostAlias_3 -portValue %PORT_HTTPS%
if %errorlevel% EQU 0 goto et5g
echo Failed to set server HTTPS port to %PORT_HTTPS%
goto end
:et5g
echo Server HTTPS port successfully set to %PORT_HTTPS%
:et5e

if %REMOVE_ADM% EQU 0 goto et6e
call "%prgdir%UpdateExpressPorts.bat" -removeAdminPorts
if %errorlevel% EQU 0 goto et6g
echo Failed to remove Administrative HTTP Transports and vHost
goto end
:et6g
echo Administrative HTTP Transports and vHost successfully removed
:et6e

:end
@endlocal
