@echo off
@rem IBM Confidential OCO Source Material
@rem 5630-A36 (C) COPYRIGHT International Business Machines Corp. 1997, 2003
@rem The source code for this program is not published or otherwise divested
@rem of its trade secrets, irrespective of what has been deposited with the
@rem U.S. Copyright Office.

@setlocal

set INSTALLSRC=%~dp0
set NODENAME=DefaultNode

if "%1" == "" goto parseParamsEnv

:parseParams
if "%1" == "" goto checkVars
if /I "%1" == "-installroot" set INSTALLROOT=%2& goto goodParam
if /I "%1" == "-hostname" set HOSTNAME=%2& goto goodParam
if /I "%1" == "-usage" goto usage
goto usageBadParam

:goodParam
shift
shift
goto parseParams


:parseParamsEnv
set INSTALLROOT=%EMBEDDEDEXPRESS_INSTALLROOT%
set HOSTNAME=%EMBEDDEDEXPRESS_HOSTNAME%
goto checkVars


:checkVars
if not defined INSTALLROOT goto usage
if not defined HOSTNAME goto usage
goto checkInstallRoot

:checkInstallRoot
FOR /f "delims=\/" %%a in ('echo %INSTALLROOT:"=%') do Set DRIVE=%%a
if not exist "%DRIVE%" goto usageBadInstallRoot
goto checkJavaDownload


:checkJavaDownload
if not exist "%INSTALLSRC:"=%\java" goto checkJavaEnv
set JAVA_HOME=%INSTALLROOT:"=%\java
goto prodInstall

:checkJavaEnv
if not exist "%JAVA_HOME:"=%" goto usageNoJava
goto prodInstall


:prodInstall
if exist "%INSTALLROOT:"=%" goto usageInstallExists
md "%INSTALLROOT:"=%"
if not %errorlevel% == 0 goto miscErrorPriv

xcopy /e /i /q "%INSTALLSRC:"=%*" "%INSTALLROOT:"=%" > NUL
if not %errorlevel% == 0 goto miscErrorOS

"%JAVA_HOME:"=%\bin\java" -classpath "%INSTALLROOT:"=%\lib\bcinstall.jar" com.ibm.ws.install.bc.bcPostInstallConfig  %INSTALLROOT% %HOSTNAME%
if not %errorlevel% == 0 goto miscErrorJConfig


if not exist "%INSTALLSRC:"=%\bin\wsinstance" goto noWSinstance

xcopy /e /i /q "%INSTALLROOT:"=%\config"     "%INSTALLROOT:"=%\bin\wsinstance\configdefaults" > NUL
if not %errorlevel% == 0 goto miscErrorOS

xcopy /e /i /q "%INSTALLROOT:"=%\etc"        "%INSTALLROOT:"=%\bin\wsinstance\etcdefaults" > NUL
if not %errorlevel% == 0 goto miscErrorOS

xcopy /i /q "%INSTALLROOT:"=%\properties" "%INSTALLROOT:"=%\bin\wsinstance\propdefaults" > NUL
if not %errorlevel% == 0 goto miscErrorOS

:noWSinstance
         

del /f /q "%INSTALLROOT:"=%\*" "%INSTALLROOT:"=%\lib\bcinstall.jar"
@endlocal
exit 0


:usageNoJava
rem set ERRORLEVEL=1
echo ERROR:  JDK not found.  There must be a valid
echo JDK installed to run EmbeddedExpress.  Please download
echo the version of EmbeddedExpress which comes with a JDK
goto done


:usage
rem set ERRORLEVEL=1
echo.
echo Usage:
echo   install.bat [-installRoot installRoot -hostName hostName]
echo or
echo   install.bat
echo.
echo Note:  If no command line args are passed in, these environment
echo variables must be set prior to running the install script.
echo EMBEDDEDEXPRESS_INSTALLROOT, and EMBEDDEDEXPRESS_HOSTNAME
echo.
goto done


:usageInstallExists
rem set ERRORLEVEL=1
echo ERROR:  The installation has been aborted because
echo %INSTALLROOT% already exists.  Please remove
echo %INSTALLROOT% or choose an alternate installation
echo location.  %INSTALLROOT% will be automatically
echo created during installation
goto done


:usageBadParam
rem set ERRORLEVEL=1
echo ERROR: The command line parameter, %1, is invalid.
echo Use -usage to see the available command line options
goto done

:usageBadInstallRoot
rem set ERRORLEVEL=1
echo ERROR:  %INSTALLROOT% is not a valid install location.
echo Please use a valid full path when specifying installRoot.
goto done

:miscErrorPriv
echo ERROR:  Due to insufficient privileges to write to
echo %INSTALLROOT%, the installation has been aborted.
goto done


:miscErrorOS
echo ERROR:  An error has occurred at the OS level which will
echo prevent proper installation.  Please check the system
echo STDERR and/or STDOUT log(s) for more information
echo which may help determine the possible cause of the error.
goto done

:miscErrorJConfig
echo ERROR:  An error has occurred during config file updating
echo Please check the system STDERR and/or STDOUT log(s) for
echo more information which may help determine the possible
echo cause of the error.  Reinstallation or hand modification of
echo the config files may be needed for proper product operation.
goto done


:done
@endlocal
exit 1

