/*
 * IBM Confidential OCO Source Material
 * 5639-D57 (C) COPYRIGHT International Business Machines Corp. 2002.
 * The source code for this program is not published or otherwise divested
 * of its trade secrets, irrespective of what has been deposited with the
 * U.S. Copyright Office.
 */

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map.Entry;
import java.util.Set;

/**
 * Represents an XML file with file name and its namespaces and schema locations.
 */
public class XMLFile {
    private String xmlUri;	// XML file
    private HashMap schemaLocations = new HashMap();

    /**
     * Constructor
     *
     * @param uri - The URI of an XML file.
     */
    public XMLFile(String uri) {
	xmlUri = uri;
    }

    /**
     * Gets the XML file's URI of the XMLFile instance.
     *
     * @return The XML file's URI in String format.
     */
    public String getURI() {
	if (xmlUri == null) {
	    return null;
	}

	return new String(xmlUri);
    } // getURI

    /**
     * Sets the new XML file's URI.
     */
    public void setURI(String newUri) {
	if (newUri == null) {
	    return;
	}
	xmlUri = new String(newUri);
    } // setUri

    /**
     * Gets a list of schema locations.
     *
     * @return A list of schema locations in Map.Entry format.
     */
    public Iterator getSchemaLocation() {
	Set set = schemaLocations.entrySet();
	return set.iterator();
    } // getSchemaLocation

    /**
     * Associates a pair of namespace and location with the XML file.
     *
     * @param namespace - XML name space.
     * @param location - XML schema location.
     */
    public void putSchemaLocation(String namespace, String location) {
	schemaLocations.put(namespace, location);
    } // putSchemaLocation
} // XMLFile
