/*
 * IBM Confidential OCO Source Material
 * 5639-D57 (C) COPYRIGHT International Business Machines Corp. 2002.
 * The source code for this program is not published or otherwise divested
 * of its trade secrets, irrespective of what has been deposited with the
 * U.S. Copyright Office.
 */

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map.Entry;
import java.util.Set;

import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class XMLSchemaValidator extends XMLSAXParser {
    //
    // Public methods
    //
    //
    // ContentHandler methods
    //

    //
    // MAIN
    //

    /** Main program entry point. */
    public static void main(String argv[]) {
        if (argv.length != 1) {
            printUsage();
            System.exit(1);
        }

	// Read XML Schema validation configuration information.
	XMLSchemaValidatorConfig xmlSchemaValidatorConfig = new XMLSchemaValidatorConfig();
	ArrayList configFiles = null;
	try {
	    configFiles = xmlSchemaValidatorConfig.get(argv[0]);
	}
	catch (Exception e) {
	    System.err.println("Error: Parse error occurred - " + e.getMessage());
	    Exception se = e;
	    if (e instanceof SAXException) {
		se = ((SAXException)e).getException();
	    }
	    if (se != null)
		se.printStackTrace(System.err);
	    else
		e.printStackTrace(System.err);
	    System.exit(-1);
	}

	// Convert the config files to include appropriate namespace (xsi)
	int noOfXMLFiles = configFiles.size();
	ArrayList convertedConfigFiles = new ArrayList();
	for (int i=0; i<noOfXMLFiles; i++) {
	    XMLFile xmlFile = (XMLFile)configFiles.get(i);
	    String xmlFileName = xmlFile.getURI();
	    XMItoXSIType converter = new XMItoXSIType(xmlFileName);
	    if (converter.convert() == null) {
            // Conversion failed.
            continue;
	    }

	    try {
    		converter.save();
	    }
        catch (Exception e) {
            System.err.println("Couldn't convert \"" + xmlFileName + "\" to the appropriate type.");
    		continue;
        }

	    xmlFile.setURI(converter.getOutputFileName());
	    convertedConfigFiles.add(xmlFile);
	} // for

	// Create parser and turn on parser's schema validation features.
	XMLSchemaValidator xmlSchemaValidator = new XMLSchemaValidator();
	try {
	    xmlSchemaValidator.setFeature(XMLSAXParser.NAMESPACES_FEATURE_ID, true);
	}
	catch (SAXException e) {
	    System.err.println("warning: Parser does not support feature (" + NAMESPACES_FEATURE_ID + ")");
	}
	try {
	    xmlSchemaValidator.setFeature(VALIDATION_FEATURE_ID, true);
	}
	catch (SAXException e) {
	    System.err.println("warning: Parser does not support feature (" + VALIDATION_FEATURE_ID+ ")");
	}
/*
	try {
	    xmlSchemaValidator.setFeature(SCHEMA_VALIDATION_FEATURE_ID, true);
	}
	catch (SAXException e) {
	    System.err.println("warning: Parser does not support feature (" + SCHEMA_VALIDATION_FEATURE_ID + ")");
	}*/

	noOfXMLFiles = convertedConfigFiles.size();
	for (int i=0; i<noOfXMLFiles; i++) {
	    XMLFile xmlFile = (XMLFile)convertedConfigFiles.get(i);
	    String xmlFileName = xmlFile.getURI();

	    // Get schema locations.
	    String schemaLocation = null;
	    Iterator schemaLocations = xmlFile.getSchemaLocation();
	    while (schemaLocations.hasNext()) {
		Entry schemaLocationEntry = (Entry)schemaLocations.next();

		// Normalize the schema location.
		String schema = (String)schemaLocationEntry.getValue();
		File file = new File(schema);
		if (file.exists() == false) {
		    System.out.println("Schema \"" + schema + "\" doesn't exist.");
		    continue;
		}
		try {
		    schema = file.getCanonicalPath();
		}
		catch (IOException e) {
		    e.toString();
		    continue;
		}

		// Construct schema location for schema validation.
		if (schemaLocation == null) {
		    // First namespace and schema location.
		    schemaLocation = schemaLocationEntry.getKey() + " " + schema;
		}
		else {
		    // Appends more namespace and schema location.
		    schemaLocation = schemaLocation + " " + schemaLocationEntry.getKey() + " " + schema;
		}
	    } // while

	    if (schemaLocation != null) {
			// Set XML parser's schema location property.
			try {
				xmlSchemaValidator.setProperty(SCHEMA_LOCATION_PROPERTY_KEY, schemaLocation);
			}
			catch (SAXException e) {
				System.err.println("warning: Parser does not support property (" + SCHEMA_LOCATION_PROPERTY_KEY + ")");
			}
	    }

	    try {
		System.out.println();
		System.out.println("** Parsing " + xmlFileName + " **");
		xmlSchemaValidator.parse(xmlFileName);
		if (xmlSchemaValidator.getParsingSuccess()) {
		    System.out.println("\tValidation of " + xmlFileName + " is complete successfully.");
		}
	    }
	    catch (IOException e) {
		System.err.println(e.getMessage());
	    }
	    catch(SAXException e) {
		System.err.println(e.getMessage());
	    }

	    // Remove the converted XML file.
	    File fileToDel = new File(xmlFileName);
	    try {
		fileToDel.delete();
	    }
	    catch (Exception e) {
		// display no message
	    }
	} // for
    } // main

	/**
	 * Default to enable schema validation.
	 */
	public XMLSchemaValidator() {
		super(true);
	}

    //
    // Private static methods
    //

    /** Prints the usage. */
    private static void printUsage() {
        System.err.println("usage: java XMLSchemaValidator <config xml file>");
		System.err.println();
		System.err.println("eg. java XMLSchemaValidator validatorconfig.xml");
        System.err.println();
    } // printUsage()

}
