/*
 * IBM Confidential OCO Source Material
 * 5639-D57 (C) COPYRIGHT International Business Machines Corp. 2002.
 * The source code for this program is not published or otherwise divested
 * of its trade secrets, irrespective of what has been deposited with the
 * U.S. Copyright Office.
 */

import java.util.ArrayList;
import java.io.IOException;

import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/**
 * Specific implementation of XMLSAXParser to retrieve XML validation configuration information.
 */
public class XMLSchemaValidatorConfig extends XMLSAXParser {
    private final String ELEMENT_TAG_CONFIG_FILE = "configfile";
    private final String ELEMENT_TAG_SCHEMA_LOCATION = "schemaLocation";
    private final String ATTR_TAG_NAME = "name";
    private final String ATTR_TAG_NAMESPACE = "namespace";
    private final String ATTR_TAG_LOCATION = "location";

    private ArrayList configFiles;	// A list of XMLFile instances.
    private XMLFile currentXMLFile;	// Current XMLFile instance.

    /**
     * Default constructor.
     */
    public XMLSchemaValidatorConfig() {
		super();
		configFiles = new ArrayList();
    } // Constructor

    /**
     * Called by the XML Parser when an XML element was parsed.
     *
     * @param uri - Namespace URI
     * @param localName - Element name
     * @param qName - Element's qualified name
     * @param attrs - Element's attributes
     */
    public void startElement(String uri, String localName, String qName, Attributes attrs)
    	throws SAXException {
    	if (localName.equals(ELEMENT_TAG_CONFIG_FILE) == true) {
    	    String currentXMLFileName = attrs.getValue(ATTR_TAG_NAME);
    	    currentXMLFile = new XMLFile(currentXMLFileName);
    	    configFiles.add(currentXMLFile);
    	}
    	else if (localName.equals(ELEMENT_TAG_SCHEMA_LOCATION) == true) {
    	    if (currentXMLFile == null) {
        		// Invalid XML syntax.
        		return;
    	    }
    
    	    String namespace = attrs.getValue(ATTR_TAG_NAMESPACE);
    	    String location = attrs.getValue(ATTR_TAG_LOCATION);
    	    if (namespace == null || location == null) {
        		// Invalid XML syntax.
        		return;
    	    }
    	    currentXMLFile.putSchemaLocation(namespace, location);
    	}
    	else {
    	    // Reset
    	    currentXMLFile = null;
    	}
    } // startElement

    /**
     * Retrieve configuration information.
     *
     * @param uri - XML file's Universal Resource Identifiers
     *
     * @return An instance of ArrayList containing XML files and their schema locations. Can be null.
     */
    public ArrayList get(String uri) {
    	parser.setContentHandler(this);
    	try {
    	    parser.parse(uri);
    	}
    	catch (SAXException e) {
    	    System.out.println(e.getMessage());
    	}
    	catch (IOException e) {
    	    System.out.println(e.getMessage());
    	}
    
    	return configFiles;
    } //get

} // XMLSchemaValidatorConfig
