::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: %PS
::
:: Licensed Internal Code - Property of IBM
::
:: 2105/2107 Licensed Internal Code
::
:: (C) Copyright IBM Corp. 2004 All Rights Reserved.
::
:: US Government Users Restricted Rights - Use, duplication or
:: disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
:: %EPS
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::Change History:
::
::Modifier			Date				Change ID
::----------------------------------------------------------------------------------
:: Shaul Pinkerfeld		Sep 29, 2004        106576
:: Initial Creation.
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Function Name: ftp_helper.cmd
::	transfer all the files under the sourceDir using FTP to 
::  the destinationHost under the destinationDir
:: 	the paramerters - 		-u <userName> -p <passWord> -h <destinationHost> 
::							-d <destLocation> -s <sourceDirLocation> -f <inputFile>
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

@echo off

setlocal
set RETURN_CODE=0
:: ###############################################################
:: Entry point

:: ###############################################################
:parse_loop
	if "%1." == "." goto parse_end
	if "%1" == "-h"  (
		goto help_screen
	)
	if "%1" == "--help" (
		goto help_screen
	)
	if "%1" == "-u" (
		goto ser_user
	)
	if "%1" == "--user" (
		goto ser_user
	)
	if "%1" == "-p" (
		goto set_password
	)
	if "%1" == "--password" (
		goto set_password
	)
	if "%1" == "-H" (
		goto set_host
	)
	if "%1" == "-host" (
		goto set_host
	)
	if "%1" == "-d" (
		goto set_dest
	)
	if "%1" == "--destination" (
		goto set_dest
	)
	if "%1" == "-s" (
		goto set_source
	)
	if "%1" == "--source" (
		goto set_source
	)
	if "%1" == "-f" (
		goto set_file
	)
	if "%1" == "--file" (
		goto set_file
	)
	shift
	goto parse_loop
:parse_end
	goto main_point
:: ############ Help screen ######################################
:help_screen
	echo -------------------------------------------------------------------
	echo %0 - FTP all the files under the sourceDir to destinatio host under the destination location 
	echo  Usage:
::	echo         %0
	echo              [-u or --user]        user name" 
	echo              [-p or --password]    user password
	echo              [-H or --host]        destination host name
	echo              [-d or --destination] Local destination path
	echo              [-s or --source]      source dir full path"
	echo              [-f or --file]        input file name"
	echo OR:
	echo         %0 [-h or --help] to display this help screen"
	echo -------------------------------------------------------------------"
	goto EOS
:: the paramerters - 		-u <userName> -p <passWord> -H <destinationHost> 
::							-d <destLocation> -s <sourceDirLocation>


:: eo help_screen
:: ############ Set password######################################
:set_password
	shift
	set PASSWORD=%1
	goto parse_loop
:: eo set_password

:: ############ Set IP ###########################################
:ser_user
	shift
	set USER=%1
	goto parse_loop
:: eo ser_user

:: ############ Set Destination ##################################
:set_dest
	shift
	set DESTINATION=%1
	goto parse_loop
:: eo set_dest

:: ############ Set Host name ############################
:set_host
	shift
	set HOST=%1
	goto parse_loop
:: eo set_host
:: ############ Set source path ##################################
:set_source
	shift
	set SOURCE=%1
	goto parse_loop
:: eo set_source
:: ############ Set input file name ##################################
:set_file
	shift
	set FILE=%1
	goto parse_loop
:: eo set_file
:: ###############################################################
:main_point
	if "%USER%." == "." set /p USER="Enter user name on remote host : "
	if "%PASSWORD%." == "." set /p PASSWORD="Enter user password on remote host : "
	if "%HOST%." == "." set/p HOST="Enter destination host name: "
	if "%DESTINATION%." == "." set/p DESTINATION="Enter host destination dir path: "
	if "%SOURCE%." == "." set/p SOURCE="Enter local source path: "
	if "%FILE%." == "." set/p FILE="Enter file name to write the ftp commands in it: "

:: for debuging - 	echo scp_helper.cmd %USER% %PASSWORD% copy %SOURCE% to %HOST% at %DESTINATION% %FILE%  build the input:
	
:: creat a temp txt file to be the commands for the ftp
	> %FILE% echo open %HOST%
	>> %FILE% echo %USER%
	>> %FILE% echo %PASSWORD%
	>> %FILE% echo cd %DESTINATION%
	>> %FILE% echo lcd %SOURCE%
	>> %FILE% echo binary
	>> %FILE% echo mput *
	>> %FILE% echo bye 
	
::	echo FINISH BUILD INPUT FILE

:: call the ftp - using the tenp file
	ftp -i -s:%FILE%
:EOS
