::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: %PS
::
:: Licensed Internal Code - Property of IBM
::
:: 2105/2107 Licensed Internal Code
::
:: (C) Copyright IBM Corp. 2004 All Rights Reserved.
::
:: US Government Users Restricted Rights - Use, duplication or
:: disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
:: %EPS
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::Change History:
::
::Modifier			Date				Change ID
::----------------------------------------------------------------------------------
:: Shaul Pinkerfeld		Sep 09, 2004        106576
:: change the  "Reef access level" to be (0-4)
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Function Name: reef_offload.cmd
::
:: Subsystem: SM RS
@echo off

setlocal
set RETURN_CODE=0
:: ###############################################################
:: Entry point
:: ###############################################################
:parse_loop
	if "%1." == "." goto parse_end
	if "%1" == "-h"  (
		goto help_screen
	)
	if "%1" == "--help" (
		goto help_screen
	)
	if "%1" == "-p" (
		goto set_password
	)
	if "%1" == "--password" (
		goto set_password
	)
	if "%1" == "-r" (
		goto set_ip
	)
	if "%1" == "--reef" (
		goto set_ip
	)
	if "%1" == "-d" (
		goto set_dest
	)
	if "%1" == "--destination" (
		goto set_dest
	)
	if "%1" == "-l" (
		goto set_level
	)
	if "%1" == "-level" (
		goto set_level
	)
	if "%1" == "-s" (
		goto set_source
	)
	if "%1" == "--source" (
		goto set_source
	)
	shift
	goto parse_loop
:parse_end
	goto main_point
:: ############ Help screen ######################################
:help_screen
	echo -------------------------------------------------------------------
	echo %0 - offload some package from Reef to the local directory
	echo  Usage:
	echo         %0
	echo              [-l|--level]       Reef access level (0-4)
	echo              [-p|--password]    Reef password"
	echo              [-r|--reef]        Reef IP address"
	echo              [-s|--source       Remote source path
	echo              [-d|--destination] Local destination path
	echo OR:
	echo         %0 [-h|--help] to display this help screen
	echo -------------------------------------------------------------------"
	goto EOS
:: eo help_screen
:: ############ Set password######################################
:set_password
	shift
	set PASSWORD=%1
	goto parse_loop
:: eo set_password

:: ############ Set IP ###########################################
:set_ip
	shift
	set IP=%1
	goto parse_loop
:: eo set_ip

:: ############ Set Destination ##################################
:set_dest
	shift
	set DESTINATION=%1
	goto parse_loop
:: eo set_dest

:: ############ Set Reef Access Level ############################
:set_level
	shift
	set TEMP_LEVEL=%1
	set back_label=parse_loop
:check_level
	if "%TEMP_LEVEL%" == "0" (
		set LEVEL=customer
	) 	else (
		if "%TEMP_LEVEL%" == "1" (
			set LEVEL=level1
		) else (
			if "%TEMP_LEVEL%" == "2" (
				set LEVEL=level2
			) else (
				if "%TEMP_LEVEL%" == "3" (
					set LEVEL=level3
				)  else (
					if "%TEMP_LEVEL%" == "4" (
						set LEVEL=copyforcustomer
					)	else (
						set RETURN_CODE=1
						goto help_screen
                        )
                    )
				)
			)
		)
	)
	goto %back_label%
:: eo set_level
:: ############ Set source path ##################################
:set_source
	shift
	set SOURCE=%1
	goto parse_loop
:: eo set_source
:: ###############################################################
:main_point
	if "%LEVEL%." == "." (
		set /p TEMP_LEVEL="Enter Reef access level (0-4): "
		set back_label=call_pscp
		goto check_level
	)
:call_pscp
	if "%PASSWORD%." == "." set /p PASSWORD="Enter Reef password: "
	if "%IP%." == "." set /p IP="Enter Reef IP address: "
	if "%DESTINATION%." == "." set/p DESTINATION="Enter local destination path: "
::	echo level="%LEVEL%"
	if "%SOURCE%." == "." set/p SOURCE="Enter remote source path: "
	call scp_helper.cmd %PASSWORD% %LEVEL%@%IP%:%SOURCE% %DESTINATION%
:EOS
