::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: %PS
::
:: Licensed Internal Code - Property of IBM
::
:: 2105/2107 Licensed Internal Code
::
:: (C) Copyright IBM Corp. 2004 All Rights Reserved.
::
:: US Government Users Restricted Rights - Use, duplication or
:: disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
:: %EPS
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Function Name: scp_helper.cmd
::
:: Subsystem: SM RS
	@echo off
	:: *****************************
	:: Display help screen and leave
	if '%1'=='-h' goto help_line
	if '%1'=='--help' goto help_line
	if '%1'=='' goto help_line
	goto start_script

:help_line
	@echo "Usage: %0 <::ote password> <source path> <destination path> [<additional options>]"
	goto end

:start_script
	set passwd=%1
	if NOT defined passwd goto help_line
	set source_path=%2
	if NOT defined source_path goto help_line
	set destination_path=%3
	if NOT defined destination_path goto help_line
	if defined DEBUG (@echo "Password = %passwd%"
		@echo "Source path = %source_path%"
		@echo "Destination path = %destination_path%"
		)
	shift
	if defined DEBUG @echo %%1=%1
	shift 
	if defined DEBUG @echo %%1=%1
	shift 
	if defined DEBUG @echo %%1=%1
	if defined DEBUG @echo %*
	set params=

:loop
	if NOT _%1==_ (set params=%params% %1 
		shift
		goto loop
		)
	pscp%params% -pw %passwd% %source_path% %destination_path% 
	if defined DEBUG @echo %errorlevel%

:end
