
<!--
 IBM Confidential

 Licensed Internal Code Source Materials

 2105 Licensed Internal Code

 (C) Copyright IBM Corp. 2002

 The source code for this program is not published or otherwise
 divested of its trade secrets, irrespective of what has been
 deposited with the U.S. Copyright Office.

-->

<!--
  assistant.jsp represents the User Assistant frame.
  It contains different controls and functions to work with the User Assistant.
 -->
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<%@ page import="java.util.*,java.io.*,java.net.*,org.eclipse.help.servlet.*" language="java" contentType="text/html" %>
<% 
	response.setContentType( "text/html; charset=UTF-8" );

	// calls the utility class to initialize the application
     
	application.getRequestDispatcher("/servlet/org.eclipse.help.servlet.InitServlet").include(request,response);

	String skinParam	= request.getParameter("skin");
	String pluginParam 	= request.getParameter("plugin");
	String topicParam	= request.getParameter("topic");
	String contentPath 	= request.getContextPath() + "/content/help:/" + pluginParam + "/" + topicParam;
	String splash    = "splash.html";

    String skinparamstr = "";
    if (skinParam!=null && skinParam.length()>0)
       skinparamstr = "&skin="+skinParam;

	/** 
	 * Logic to get historyMax value from the assistant.properties file.
	 * User can set the maximum value of history to be navigated in the
	 * User assistant. This value is in assistant.properties file.
	 * Format is - historyMax=25. The default value of historyMax
	 * variable is 10.
	 */
	
    /*	 We turned off this feature until it is really needed.
	String sprops = "assistant";
	String surl = request.getRequestURL().toString();
	int in = surl.lastIndexOf('/');
	surl = surl.substring(0,in+1);
	
	URL [] is = new URL [1];
	is[0] = new URL(surl);

	URLClassLoader ul = new URLClassLoader(is);

	ResourceBundle rbundle = ResourceBundle.getBundle(sprops, request.getLocale(), ul);
	String ss 	 = rbundle.getString("historyMax");
	// If the value 'historyMax' is not found or is not available
	// default value of historyMax is 10.
	Integer hMax 	 = new Integer(10);
	if(ss != null)
	   hMax	 = new Integer(ss);
	*/
	Integer hMax 	 = new Integer(10);
%>
<html>
  <head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title>Task Assistant</title>
<style type="text/css">
/* need this one for Mozilla */
HTML { 
	width:100%;
	height:100%;
	margin:0px;
	padding:0px;
	border:0px;
 }
BODY {
	margin:0px;
	padding:0px;
	/* Mozilla does not like width:100%, so we set height only */
	height:100%;
}
</style>
    <script language="JavaScript" src="../webclient/finder.js"></script>
    <script language="JavaScript"><!--
var loaded        = false;
var controller    = undefined;
var historyTopic  = new Array();
var historyPos    = -1;
var historyChange = true;
var historyMax = <%=hMax.intValue()%>;
/**
 * Load the User Assistant. Find the window with the help Controller (controller.jsp)
 * and remember the reference to it
 */
function doLoad() {

  loaded = true;
  try {
    var webcontrol = findHelpController();
    if ( webcontrol ) {
        controller = webcontrol;
        controller.setTaskAssistant( this, true );
    }
  } catch ( ex ) {
  }
  
}

/**
 * Done with the User Assistant. Unload and tell the controller.
 */
function doUnload() {
  try {
    if ( controller ) {
        controller . closeTAWindow (  );
    }
  } catch ( ex ) {
  }
}

/**
 * Set the controller to the provided controller.
 * @param newController  The controller to be set for this User Assistant
 */
function setController( newController ) {
  controller = newController;
}

/**
 * If controller is available then show the help for current topic.
 */
function showCurrentHelp() {
  if ( controller )
    controller.showHelp( historyTopic[ historyPos ] );
}

/**
 * Detach the User Assistant from the parent window.
 */
function detachHelp() {
  if ( controller )
    controller.detach( historyTopic[ historyPos ] );
}

/**
 * Show the help for current topic.
 */
function currentHelp() {
  if ( controller )
    controller.showCurrentAssist();
}

/**
 * Set the current topic in the history.
 * The topic is same as current topic, return.
 */
function topicShown( topicHref ) {
  if ( ! historyChange ) {
    historyChange = true;
    return;
  }

  if ( historyTopic[ historyPos ] == topicHref )
    return;
  if ( historyTopic.length == historyMax )
    historyTopic.shift();
  else
    historyPos++;
  if ( historyPos == historyTopic.length ) {
    historyTopic.push( topicHref );
  }
  else {
    if ( historyTopic[ historyPos ] == topicHref )
      return;
    historyTopic.splice(
        historyPos, historyTopic.length - historyPos, topicHref
    );
  }
}

/**
 * Navigate backwards.
 */
function pageBack() {
  if ( AssistMainFrame ) {
    if ( historyPos > 0 ) {
      historyPos--;
      historyChange = false;
      AssistMainFrame.location.href = historyTopic[ historyPos ];
    }
  }
}

/**
 * Navigate forward.
 */
function pageForward() {
  if ( AssistMainFrame ) {
    if ( historyPos < ( historyTopic.length - 1 ) ) {
      historyPos++;
      historyChange = false;
      AssistMainFrame.location.href = historyTopic[ historyPos ];
    }
  }
}

/**
 * Show the given page in the User Assistant.
 */
function showPage( page ) {
  if ( ! ( page ) )
    return;
  if ( AssistMainFrame ) {
      this.topicShown(page);
      historyChange = false;
      AssistMainFrame.location.href = page;
  }
}

//savari: facilities to provide current plugin & topic shown in Assistant
/**
 * Return the toekn at a given position so as to seperate the plugin and topic.
 */
function getTokenAt ( position )
{ 
  
 var url = this . getCurrentHREF (  );
 var tokens = url . split ( "/" );
 return tokens [ tokens . length + position ];

}
/**
 * Get the current plugin provided with URL.
 */
function getCurrentPlugin (  )
{
 return this . getTokenAt ( -2 ); 
}

/**
 * Get the current topic provided with URL.
 */
function getCurrentTopic (  )
{
 return this . getTokenAt ( -1 );
}

/*
 * Get the href provided with URL.
 */
function getCurrentHREF (  )
{
 return historyTopic [ historyPos ];
}

//--></script>
  </head>
  <frameset rows="46,*" frameborder="0" framespacing="0" border="0"
      spacing="0" onload="doLoad();" onunload="doUnload();">
    <frame name="AssistBarFrame" src="toolbar.jsp?lang=English<%= skinparamstr %>"
        marginwidth="0" marginheight="0" scrolling="no"
        frameborder="0" resize="no" />
        <frame name="AssistMainFrame" src="<%=(topicParam!=null && pluginParam!=null) ? contentPath : splash%>"
        marginwidth="0" marginheight="0" scrolling="auto" frameborder="0"
        resize="no" />
    </frameset>
  </frameset>
</html>
