<!--
 IBM Confidential
 Licensed Internal Code Source Materials

 2105 Licensed Internal Code

 (C) Copyright IBM Corp. 2002

 The source code for this program is not published or otherwise
 divested of its trade secrets, irrespective of what has been
 deposited with the U.S. Copyright Office.

-->
<!--
 toolbar.jsp represents the actual toolbar on User Assistant frame.
  It contains different controls and functions to navigate the User Assistant.
 -->
<%@ page import="java.util.*, java.io.*, java.net.*, org.eclipse.help.servlet.*" language="java" contentType="text/html" %>

<%
	response.setContentType( "text/html; charset=UTF-8" );

	String skinParam=request.getParameter("skin");
	String skin=(skinParam != null && skinParam.length() > 0) ? skinParam + "/" : "";

	String agent=request.getHeader("User-Agent").toLowerCase(Locale.US);
	boolean isIE=(agent.indexOf("msie") != -1);

%>



<%

/*  The resources file is assistant.properties file. 
 *  The appropriate locale is picked up from the request. 
 *  The key-value pairs are stored in HttpSession for faster access.
 *  These values are retrieved from the session when needed.
 */
/*
	HttpSession sess = request.getSession();;
	String sprops = "assistant";
	URL [] is = new URL [1];
	String surl = request.getRequestURL().toString();
	int in = surl.lastIndexOf('/');
	surl = surl.substring(0,in+1);
	is[0] = new URL(surl);

	URLClassLoader ul = new URLClassLoader(is);
*/
	ResourceBundle rbundle = ResourceBundle.getBundle("assistant", request.getLocale());

	String toolbar_tip_return = rbundle.getString("assist_return");
	String toolbar_tip_previous = rbundle.getString("assist_previous");
	String toolbar_tip_next = rbundle.getString("assist_next");
	String toolbar_tip_print = rbundle.getString("assist_print");
	String toolbar_tip_search = rbundle.getString("assist_search");
	String toolbar_tip_go = rbundle.getString("assist_go");

%>



<html>

  <head>

	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">

	<title>Task Assistant Toolbar</title>

    <link rel="stylesheet" type="text/css" href="<%=skin%>toolbar.css" />

<%

	String extraStyle=(isIE) ?

 	    "<style type='text/css'>#searchWord{margin-bottom:-1px;} #go{padding-left:1px;} </style>" :

 	    "<style type='text/css'>body {border-right:0px solid WindowText;}</style>";

%>

<%-- NEW --%>

<script language="JavaScript"><!--

document.write("<%=extraStyle%>");

//--></script>



<script language="JavaScript"><!--

var isIE=<%= isIE ? "true" : "false" %>;



function doSearch() {

	var form = document.forms["searchForm"];

	var searchWord = form.searchWord.value;

	var maxHits = form.maxHits.value;

	if (!searchWord || searchWord == "")

		return;

	else

		parent.controller. Search(searchWord, maxHits);

    form.searchWord.value="";

}



function fixHeights() {

	if (!isIE) return;

	

	var h = document.getElementById("searchWord").offsetHeight;

	document.getElementById("go").style.height = h;

}



function doLoad() {

	var form = document.forms["searchForm"];

	form.searchWord.value = '<%= UrlUtil.getRequestParameter(request, "searchWord")!=null?UrlUtil.JavaScriptEncode(UrlUtil.getRequestParameter(request, "searchWord")):""%>';

	fixHeights();

}



//--></script>

  </head>



  <body leftmargin="0" topmargin="0" marginheight=0" marginwidth="0" onload="doLoad();">

<table  width="100%" cellspacing="0" cellpadding="0">
 <tr>
    <td class = "toolbar" height="23" >

        <span class="separator"></span>
        <span class="indent">&nbsp;</span>

        <a href="#" onclick="parent.currentHelp();"

            title='<%= toolbar_tip_return %>'><img

            src="<%=skin%>images/return.gif" width="16" height="16" border="0"

            alt='<%= toolbar_tip_return %>'/></a>

        <span class="separator"></span>

        <a href="#" onclick="parent.pageBack();"

            title='<%= toolbar_tip_previous %>'><img

            src="<%=skin%>images/back.gif" width="16" height="16" border="0"

            alt='<%= toolbar_tip_previous %>'/></a>

        <span class="separator"></span>

        <a href="#" onclick="parent.pageForward();"

            title='<%= toolbar_tip_next %>'><img

            src="<%=skin%>images/forward.gif" width="16" height="16" border="0"

            alt='<%= toolbar_tip_next %>'/></a>

        <a href="#" onclick="parent.print();"

            title='<%= toolbar_tip_print %>'><img

            src="<%=skin%>images/print_edit.gif" width="16" height="16" border="0"

            alt='<%= toolbar_tip_print %>'/></a>

 </td>
  </tr>

<tr>
    <td class = "toolbar" height ="23">

      <form name="searchForm" onsubmit="doSearch();return false;" action="#">  

        <span class="separator"></span>
        <span class="indent">&nbsp;</span>
     	<%= toolbar_tip_search %>:

		&nbsp;<input type="text" id="searchWord" name="searchWord" value='' size="20" maxlength="256">

		<input type="hidden" name="maxHits" value="500" >

		&nbsp;<input type="button" onclick="this.blur();doSearch()" value='<%= toolbar_tip_go %>' id="go">
     </form>
    </td>
   </tr>
  </table>
 </body>

</html>

